/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.callhierarchy;

import java.util.EnumSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.handly.internal.ui.Activator;
import org.eclipse.handly.snapshot.StaleSnapshotException;
import org.eclipse.handly.ui.DefaultEditorUtility;
import org.eclipse.handly.ui.EditorOpener;
import org.eclipse.handly.ui.EditorUtility;
import org.eclipse.handly.ui.callhierarchy.CallHierarchyContentProvider;
import org.eclipse.handly.ui.callhierarchy.CallHierarchyKind;
import org.eclipse.handly.ui.callhierarchy.CallHierarchyLabelProvider;
import org.eclipse.handly.ui.callhierarchy.ICallHierarchy;
import org.eclipse.handly.ui.callhierarchy.ICallHierarchyNode;
import org.eclipse.handly.ui.callhierarchy.ICallLocation;
import org.eclipse.handly.ui.callhierarchy.LocationTableLabelProvider;
import org.eclipse.handly.ui.callhierarchy.Messages;
import org.eclipse.handly.ui.viewer.ColumnDescription;
import org.eclipse.handly.ui.viewer.DelegatingSelectionProvider;
import org.eclipse.handly.ui.viewer.LabelComparator;
import org.eclipse.handly.util.TextRange;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;

public abstract class CallHierarchyViewPart
extends ViewPart {
    protected static final String GROUP_FOCUS = "group.focus";
    private static final String KEY_HIERARCHY_KIND = "org.eclipse.handly.callhierarchy.view.kind";
    private final EnumSet<CallHierarchyKind> supportedHierarchyKinds;
    private CallHierarchyKind hierarchyKind;
    private Object[] inputElements;
    private PageBook pageBook;
    private SashForm sashForm;
    private TreeViewer hierarchyViewer;
    private TableViewer locationViewer;
    private EditorOpener editorOpener;
    private final RefreshAction refreshAction = new RefreshAction();
    private SetHierarchyKindAction[] setHierarchyKindActions = new SetHierarchyKindAction[0];
    private FocusOnSelectionAction focusOnSelectionAction;

    public CallHierarchyViewPart() {
        this(EnumSet.allOf(CallHierarchyKind.class));
    }

    public CallHierarchyViewPart(EnumSet<CallHierarchyKind> supportedHierarchyKinds) {
        if (supportedHierarchyKinds == null) {
            throw new IllegalArgumentException();
        }
        if (supportedHierarchyKinds.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.supportedHierarchyKinds = supportedHierarchyKinds.clone();
        this.hierarchyKind = (CallHierarchyKind)((Object)supportedHierarchyKinds.iterator().next());
        this.makeSetHierarchyKindActions();
    }

    private void makeSetHierarchyKindActions() {
        int size = this.supportedHierarchyKinds.size();
        if (size > 1) {
            this.setHierarchyKindActions = new SetHierarchyKindAction[size];
            int i = 0;
            for (CallHierarchyKind kind : this.supportedHierarchyKinds) {
                this.setHierarchyKindActions[i++] = new SetHierarchyKindAction(kind);
            }
            this.setHierarchyKindActions[0].setChecked(true);
        }
    }

    public void setInputElements(Object[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException();
        }
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        this.inputElements = elements;
        this.refresh();
    }

    public final Object[] getInputElements() {
        return this.inputElements;
    }

    public final CallHierarchyKind getHierarchyKind() {
        return this.hierarchyKind;
    }

    public void setHierarchyKind(CallHierarchyKind kind) {
        if (!this.supportsHierarchyKind(kind)) {
            throw new IllegalArgumentException();
        }
        if (kind == this.hierarchyKind) {
            return;
        }
        this.hierarchyKind = kind;
        SetHierarchyKindAction[] setHierarchyKindActionArray = this.setHierarchyKindActions;
        int n = this.setHierarchyKindActions.length;
        int n2 = 0;
        while (n2 < n) {
            SetHierarchyKindAction action = setHierarchyKindActionArray[n2];
            action.setChecked(action.kind == kind);
            ++n2;
        }
        this.refresh();
    }

    public final boolean supportsHierarchyKind(CallHierarchyKind kind) {
        return this.supportedHierarchyKinds.contains((Object)kind);
    }

    public void refresh() {
        if (this.inputElements == null || this.hierarchyViewer == null || this.hierarchyViewer.getControl().isDisposed()) {
            return;
        }
        ICallHierarchy hierarchy = this.createHierarchy();
        if (this.hierarchyKind != hierarchy.getKind()) {
            throw new AssertionError();
        }
        this.setHierarchy(hierarchy);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        String value;
        super.init(site, memento);
        if (memento != null && this.supportedHierarchyKinds.size() > 1 && (value = memento.getString(KEY_HIERARCHY_KIND)) != null) {
            CallHierarchyKind kind = null;
            try {
                kind = CallHierarchyKind.valueOf(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (this.supportsHierarchyKind(kind)) {
                this.setHierarchyKind(kind);
            }
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (this.supportedHierarchyKinds.size() > 1) {
            memento.putString(KEY_HIERARCHY_KIND, this.hierarchyKind.name());
        }
    }

    public void createPartControl(Composite parent) {
        this.pageBook = new PageBook(parent, 0);
        this.pageBook.showPage(this.createNoHierarchyPage((Composite)this.pageBook));
        this.sashForm = this.createSashForm((Composite)this.pageBook);
        this.hierarchyViewer = this.createHierarchyViewer((Composite)this.sashForm);
        this.locationViewer = this.createLocationViewer((Composite)this.sashForm);
        this.configureHierarchyViewer(this.hierarchyViewer);
        this.configureLocationViewer(this.locationViewer);
        ConvertingSelectionProvider selectionProvider = new ConvertingSelectionProvider();
        selectionProvider.setDelegate((ISelectionProvider)this.hierarchyViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)selectionProvider);
        this.initContextMenu(this.hierarchyViewer.getControl(), manager -> {
            this.createHierarchyViewerMenuGroups(manager);
            this.fillHierarchyViewerMenu(manager);
        }, this.getSite().getId(), (ISelectionProvider)selectionProvider);
        this.initContextMenu(this.locationViewer.getControl(), manager -> {
            this.createLocationViewerMenuGroups(manager);
            this.fillLocationViewerMenu(manager);
        }, String.valueOf(this.getSite().getId()) + ".locationViewerMenu", (ISelectionProvider)this.locationViewer);
        new OpenEditorHelper((StructuredViewer)this.hierarchyViewer);
        new OpenEditorHelper((StructuredViewer)this.locationViewer);
        this.hierarchyViewer.addSelectionChangedListener(e -> this.hierarchySelectionChanged(e.getSelection()));
        this.locationViewer.addSelectionChangedListener(e -> this.locationSelectionChanged(e.getSelection()));
        this.editorOpener = this.createEditorOpener();
        this.focusOnSelectionAction = this.createFocusOnSelectionAction();
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.focusOnSelectionAction);
        this.addRefreshAction((IAction)this.refreshAction);
        SetHierarchyKindAction[] setHierarchyKindActionArray = this.setHierarchyKindActions;
        int n = this.setHierarchyKindActions.length;
        int n2 = 0;
        while (n2 < n) {
            SetHierarchyKindAction action = setHierarchyKindActionArray[n2];
            this.addSetHierarchyKindAction((IAction)action, action.kind);
            ++n2;
        }
    }

    public void setFocus() {
        this.pageBook.setFocus();
    }

    protected abstract ICallHierarchy createHierarchy();

    protected void setHierarchy(ICallHierarchy hierarchy) {
        this.pageBook.showPage((Control)this.sashForm);
        this.hierarchyViewer.setInput(null);
        this.locationViewer.setInput(null);
        this.hierarchyViewer.setComparator(this.getHierarchyComparator(hierarchy));
        this.hierarchyViewer.setInput((Object)hierarchy);
        ICallHierarchyNode[] roots = hierarchy.getRoots();
        if (roots.length > 0) {
            this.hierarchyViewer.setSelection((ISelection)new StructuredSelection((Object)roots[0]), true);
        }
        this.hierarchyViewer.getTree().setFocus();
        this.setContentDescription(hierarchy.getLabel());
        this.refreshAction.setEnabled(true);
    }

    protected ViewerComparator getHierarchyComparator(ICallHierarchy hierarchy) {
        if (hierarchy.getKind() == CallHierarchyKind.CALLER) {
            return new LabelComparator();
        }
        return null;
    }

    protected Control createNoHierarchyPage(Composite parent) {
        Label label = new Label(parent, 16448);
        label.setText(Messages.CallHierarchyViewPart_No_hierarchy_to_display);
        return label;
    }

    protected final SashForm getSashForm() {
        return this.sashForm;
    }

    protected SashForm createSashForm(Composite parent) {
        return new SashForm(parent, 0);
    }

    protected final TreeViewer getHierarchyViewer() {
        return this.hierarchyViewer;
    }

    protected TreeViewer createHierarchyViewer(Composite parent) {
        return new TreeViewer(parent, 2);
    }

    protected void configureHierarchyViewer(TreeViewer viewer) {
        viewer.getTree().setLayoutData((Object)new GridData(1808));
        viewer.setUseHashlookup(true);
        viewer.setAutoExpandLevel(2);
        viewer.setContentProvider((IContentProvider)new CallHierarchyContentProvider(this));
        viewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new CallHierarchyLabelProvider((ILabelProvider)new WorkbenchLabelProvider())));
    }

    protected void createHierarchyViewerMenuGroups(IMenuManager manager) {
        manager.add((IContributionItem)new Separator(GROUP_FOCUS));
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void fillHierarchyViewerMenu(IMenuManager manager) {
        if (this.focusOnSelectionAction.isEnabled()) {
            manager.appendToGroup(GROUP_FOCUS, (IAction)this.focusOnSelectionAction);
        }
    }

    protected void hierarchySelectionChanged(ISelection selection) {
        Object element = CallHierarchyViewPart.getSelectedElement(selection);
        if (!(element instanceof ICallHierarchyNode)) {
            this.locationViewer.setInput(null);
        } else {
            ICallLocation[] callLocations = ((ICallHierarchyNode)element).getCallLocations();
            this.locationViewer.setInput((Object)callLocations);
            if (callLocations.length > 0) {
                this.locationViewer.setSelection((ISelection)new StructuredSelection((Object)callLocations[0]), true);
            }
            if (this.hierarchyViewer.getControl().isFocusControl()) {
                try {
                    this.revealInEditor(element, false, false);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        }
    }

    protected final TableViewer getLocationViewer() {
        return this.locationViewer;
    }

    protected TableViewer createLocationViewer(Composite parent) {
        return new TableViewer(parent, 66306);
    }

    protected void configureLocationViewer(TableViewer viewer) {
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new LocationTableLabelProvider());
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        this.createLocationColumns(table);
    }

    protected void createLocationColumns(Table table) {
        ColumnDescription[] columnDescriptions;
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        ColumnDescription[] columnDescriptionArray = columnDescriptions = this.getLocationColumnDescriptions();
        int n = columnDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDescription columnDescription = columnDescriptionArray[n2];
            ColumnLayoutData layoutData = columnDescription.getLayoutData();
            layout.addColumnData(layoutData);
            TableColumn column = new TableColumn(table, 0);
            column.setResizable(layoutData.resizable);
            String header = columnDescription.getHeader();
            if (header != null) {
                column.setText(header);
            }
            ++n2;
        }
    }

    protected ColumnDescription[] getLocationColumnDescriptions() {
        ColumnDescription iconColumn = new ColumnDescription(null, (ColumnLayoutData)new ColumnPixelData(18, false, true));
        ColumnDescription lineColumn = new ColumnDescription(Messages.CallHierarchyViewPart_Line_column_header, (ColumnLayoutData)new ColumnWeightData(60));
        ColumnDescription infoColumn = new ColumnDescription(Messages.CallHierarchyViewPart_Info_column_header, (ColumnLayoutData)new ColumnWeightData(300));
        return new ColumnDescription[]{iconColumn, lineColumn, infoColumn};
    }

    protected void createLocationViewerMenuGroups(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void fillLocationViewerMenu(IMenuManager manager) {
    }

    protected void locationSelectionChanged(ISelection selection) {
        Object element = CallHierarchyViewPart.getSelectedElement(selection);
        if (!(element instanceof ICallLocation)) {
            return;
        }
        if (this.locationViewer.getControl().isFocusControl()) {
            try {
                this.revealInEditor(element, false, false);
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        }
    }

    protected void revealInEditor(Object element, boolean activate, boolean mayOpenNewEditor) throws PartInitException {
        ICallLocation callLocation = null;
        if (element instanceof ICallLocation) {
            callLocation = (ICallLocation)element;
            element = callLocation.getCaller();
        } else if (element instanceof ICallHierarchyNode) {
            ICallHierarchyNode node = (ICallHierarchyNode)element;
            ICallLocation[] callLocations = node.getCallLocations();
            if (callLocations.length == 0) {
                element = node.getElement();
            } else {
                callLocation = callLocations[0];
                element = callLocation.getCaller();
            }
        }
        EditorUtility editorUtility = this.editorOpener.getEditorUtility();
        if (editorUtility.getEditorInput(element) == null) {
            return;
        }
        IEditorPart editor = null;
        if (mayOpenNewEditor) {
            editor = this.editorOpener.open(element, activate, callLocation == null);
        } else {
            IWorkbenchPage page = this.editorOpener.getWorkbenchPage();
            IEditorReference editorRef = editorUtility.findEditor(page, element);
            if (editorRef != null) {
                editor = editorRef.getEditor(true);
                if (activate) {
                    page.activate((IWorkbenchPart)editor);
                } else {
                    page.bringToTop((IWorkbenchPart)editor);
                }
                if (callLocation == null) {
                    editorUtility.revealElement(editor, element);
                }
            }
        }
        if (editor != null && callLocation != null) {
            TextRange callRange = callLocation.getCallRange();
            if (callRange == null) {
                editorUtility.revealElement(editor, element);
            } else {
                try {
                    editorUtility.revealTextRange(editor, callRange.getOffset(), callRange.getLength(), callLocation.getSnapshot());
                }
                catch (StaleSnapshotException e) {
                    editorUtility.revealElement(editor, element);
                }
            }
        }
    }

    protected final EditorOpener getEditorOpener() {
        return this.editorOpener;
    }

    protected EditorOpener createEditorOpener() {
        return new EditorOpener(this.getSite().getPage(), DefaultEditorUtility.INSTANCE);
    }

    protected final FocusOnSelectionAction getFocusOnSelectionAction() {
        return this.focusOnSelectionAction;
    }

    protected FocusOnSelectionAction createFocusOnSelectionAction() {
        return new FocusOnSelectionAction();
    }

    protected void addRefreshAction(IAction action) {
        this.getViewSite().getActionBars().getToolBarManager().add(action);
    }

    protected void addSetHierarchyKindAction(IAction action, CallHierarchyKind kind) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.getToolBarManager().add(action);
        actionBars.getMenuManager().add(action);
    }

    private void initContextMenu(Control parent, IMenuListener listener, String menuId, ISelectionProvider selectionProvider) {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(listener);
        Menu menu = manager.createContextMenu(parent);
        parent.setMenu(menu);
        this.getSite().registerContextMenu(menuId, manager, selectionProvider);
    }

    private static Object getSelectedElement(ISelection selection) {
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            return ss.getFirstElement();
        }
        return null;
    }

    private static class ConvertingSelectionProvider
    extends DelegatingSelectionProvider {
        private ConvertingSelectionProvider() {
        }

        @Override
        public ISelection getSelection() {
            return this.convert(super.getSelection());
        }

        @Override
        protected SelectionChangedEvent newSelectionChangedEvent(ISelection selection) {
            return super.newSelectionChangedEvent(this.convert(selection));
        }

        private ISelection convert(ISelection selection) {
            if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
                return selection;
            }
            Object[] elements = ((IStructuredSelection)selection).toArray();
            int length = elements.length;
            Object[] converted = new Object[length];
            int i = 0;
            while (i < length) {
                converted[i] = this.convert(elements[i]);
                ++i;
            }
            return new StructuredSelection(converted);
        }

        private Object convert(Object element) {
            if (element instanceof ICallHierarchyNode) {
                return ((ICallHierarchyNode)element).getElement();
            }
            return element;
        }
    }

    protected class FocusOnSelectionAction
    extends BaseSelectionListenerAction {
        public FocusOnSelectionAction() {
            super(Messages.CallHierarchyViewPart_Focus_on_selection_action_text);
            this.setToolTipText(Messages.CallHierarchyViewPart_Focus_on_selection_action_tooltip);
        }

        public void run() {
            CallHierarchyViewPart.this.setInputElements(this.getStructuredSelection().toArray());
        }

        protected boolean updateSelection(IStructuredSelection selection) {
            return !selection.isEmpty();
        }
    }

    private class OpenEditorHelper
    extends OpenAndLinkWithEditorHelper {
        OpenEditorHelper(StructuredViewer viewer) {
            super(viewer);
        }

        protected void activate(ISelection selection) {
            Object element = CallHierarchyViewPart.getSelectedElement(selection);
            if (element != null) {
                try {
                    CallHierarchyViewPart.this.revealInEditor(element, true, false);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        }

        protected void open(ISelection selection, boolean activate) {
            Object element = CallHierarchyViewPart.getSelectedElement(selection);
            if (element != null) {
                try {
                    CallHierarchyViewPart.this.revealInEditor(element, activate, true);
                }
                catch (PartInitException e) {
                    ErrorDialog.openError((Shell)CallHierarchyViewPart.this.getSite().getShell(), (String)Messages.CallHierarchyViewPart_Show_call_location, (String)Messages.CallHierarchyViewPart_Error_opening_editor, (IStatus)e.getStatus());
                }
            }
        }
    }

    private class RefreshAction
    extends Action {
        RefreshAction() {
            this.setText(Messages.CallHierarchyViewPart_Refresh_action_text);
            this.setToolTipText(Messages.CallHierarchyViewPart_Refresh_action_tooltip);
            this.setImageDescriptor(Activator.getImageDescriptor("org.eclipse.handly.ui/elcl16/refresh.png"));
            this.setDisabledImageDescriptor(Activator.getImageDescriptor("org.eclipse.handly.ui/dlcl16/refresh.png"));
            this.setEnabled(false);
        }

        public void run() {
            CallHierarchyViewPart.this.refresh();
        }
    }

    private class SetHierarchyKindAction
    extends Action {
        final CallHierarchyKind kind;

        SetHierarchyKindAction(CallHierarchyKind kind) {
            super("", 8);
            this.kind = kind;
            switch (kind) {
                case CALLER: {
                    this.setText(Messages.CallHierarchyViewPart_Show_caller_hierarchy_action_text);
                    this.setToolTipText(Messages.CallHierarchyViewPart_Show_caller_hierarchy_action_tooltip);
                    this.setImageDescriptor(Activator.getImageDescriptor("org.eclipse.handly.ui/elcl16/ch_callers.png"));
                    break;
                }
                case CALLEE: {
                    this.setText(Messages.CallHierarchyViewPart_Show_callee_hierarchy_action_text);
                    this.setToolTipText(Messages.CallHierarchyViewPart_Show_callee_hierarchy_action_tooltip);
                    this.setImageDescriptor(Activator.getImageDescriptor("org.eclipse.handly.ui/elcl16/ch_callees.png"));
                }
            }
        }

        public void run() {
            CallHierarchyViewPart.this.setHierarchyKind(this.kind);
        }
    }
}

