/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.action;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.handly.internal.ui.Activator;
import org.eclipse.handly.ui.EditorOpener;
import org.eclipse.handly.ui.EditorUtility;
import org.eclipse.handly.ui.action.Messages;
import org.eclipse.handly.util.IStatusAcceptor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class OpenAction
extends BaseSelectionListenerAction {
    private final EditorOpener editorOpener;

    public OpenAction(IWorkbenchPage page, EditorUtility editorUtility) {
        this(new EditorOpener(page, editorUtility));
    }

    public OpenAction(EditorOpener editorOpener) {
        super(Messages.OpenAction_text);
        if (editorOpener == null) {
            throw new IllegalArgumentException();
        }
        this.editorOpener = editorOpener;
    }

    public void run() {
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        EditorUtility editorUtility = this.editorOpener.getEditorUtility();
        IStatusAcceptor statusAcceptor = this.newStatusAcceptor();
        for (Object element : selection) {
            IEditorInput editorInput = editorUtility.getEditorInput(element);
            if (editorInput == null) continue;
            try {
                this.editorOpener.open(element, OpenStrategy.activateOnOpen(), true);
            }
            catch (PartInitException e) {
                statusAcceptor.accept(Activator.createErrorStatus(MessageFormat.format(Messages.OpenAction_Error_opening_editor_for__0__Reason__1, editorInput.getToolTipText(), e.getMessage()), e));
            }
        }
        statusAcceptor.done();
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        EditorUtility editorUtility = this.editorOpener.getEditorUtility();
        for (Object element : selection) {
            if (editorUtility.getEditorInput(element) != null) continue;
            return false;
        }
        return true;
    }

    protected IStatusAcceptor newStatusAcceptor() {
        final MultiStatus status = new MultiStatus("org.eclipse.handly.ui", 0, Messages.OpenAction_Error_dialog_message, null);
        return new IStatusAcceptor(){

            public void accept(IStatus s) {
                status.merge(s);
                Activator.log(s);
            }

            public void done() {
                IStatus[] children = status.getChildren();
                if (children.length == 0) {
                    return;
                }
                MessageDialog.openError((Shell)OpenAction.this.editorOpener.getWorkbenchPage().getWorkbenchWindow().getShell(), (String)Messages.OpenAction_Error_dialog_title, (String)(children.length > 1 ? status.getMessage() : children[0].getMessage()));
            }
        };
    }
}

