/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.texteditor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.handly.buffer.BufferChangeOperation;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.IBufferChange;
import org.eclipse.handly.buffer.UiBufferChangeRunner;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.internal.ui.Activator;
import org.eclipse.handly.snapshot.DocumentSnapshot;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.util.UiSynchronizer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public final class TextEditorBuffer
implements IBuffer {
    private final UiSynchronizer uiSynchronizer;
    private final IEditorInput editorInput;
    private final IDocumentProvider documentProvider;
    private IDocument document;
    private int refCount = 1;

    public TextEditorBuffer(ITextEditor editor) throws CoreException {
        if (editor == null) {
            throw new IllegalArgumentException();
        }
        this.uiSynchronizer = UiSynchronizer.getDefault();
        if (this.uiSynchronizer == null) {
            throw new AssertionError();
        }
        this.editorInput = editor.getEditorInput();
        if (this.editorInput == null) {
            throw new IllegalArgumentException();
        }
        this.checkThread();
        this.documentProvider = editor.getDocumentProvider();
        if (this.documentProvider == null) {
            throw new IllegalArgumentException();
        }
        this.documentProvider.connect((Object)this.editorInput);
        boolean f = false;
        try {
            this.document = this.documentProvider.getDocument((Object)this.editorInput);
            if (this.document == null) {
                throw new AssertionError();
            }
            f = true;
        }
        finally {
            if (!f) {
                this.documentProvider.disconnect((Object)this.editorInput);
            }
        }
    }

    public IDocument getDocument() {
        IDocument result = this.document;
        if (result == null) {
            throw new IllegalStateException("Attempt to access a disconnected TextEditorBuffer for " + this.editorInput.getToolTipText());
        }
        return result;
    }

    public ISnapshot getSnapshot() {
        return new DocumentSnapshot(this.getDocument());
    }

    public IBufferChange applyChange(IBufferChange change, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            UiBufferChangeRunner runner = new UiBufferChangeRunner(this.uiSynchronizer, new BufferChangeOperation((IBuffer)this, change));
            return runner.run(monitor);
        }
        catch (MalformedTreeException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
        catch (BadLocationException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
    }

    public void save(IContext context, IProgressMonitor monitor) throws CoreException {
        this.checkThread();
        this.documentProvider.saveDocument(monitor, (Object)this.editorInput, this.getDocument(), false);
    }

    public boolean isDirty() {
        this.checkThread();
        return this.documentProvider.canSaveDocument((Object)this.editorInput);
    }

    public synchronized void addRef() {
        ++this.refCount;
    }

    public synchronized void release() {
        if (--this.refCount == 0 && this.document != null) {
            this.document = null;
            this.uiSynchronizer.asyncExec(new Runnable(){

                @Override
                public void run() {
                    TextEditorBuffer.this.documentProvider.disconnect((Object)TextEditorBuffer.this.editorInput);
                }
            });
        }
    }

    private void checkThread() {
        if (!Thread.currentThread().equals(this.uiSynchronizer.getThread())) {
            throw new IllegalStateException("Invalid thread access to TextEditorBuffer for " + this.editorInput.getToolTipText());
        }
    }
}

