/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl.support;

import java.util.Map;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.ICoreTextFileBufferProvider;
import org.eclipse.handly.buffer.TextFileBuffer;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.model.ElementDeltas;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElementDelta;
import org.eclipse.handly.model.impl.DefaultWorkingCopyCallback;
import org.eclipse.handly.model.impl.ISourceFileImplExtension;
import org.eclipse.handly.model.impl.IWorkingCopyCallback;
import org.eclipse.handly.model.impl.support.ElementChangeEvent;
import org.eclipse.handly.model.impl.support.ElementChangeRecorder;
import org.eclipse.handly.model.impl.support.ElementDelta;
import org.eclipse.handly.model.impl.support.ElementManager;
import org.eclipse.handly.model.impl.support.INotificationManager;
import org.eclipse.handly.model.impl.support.ISourceElementImplSupport;
import org.eclipse.handly.model.impl.support.ReconcileStrategy;
import org.eclipse.handly.model.impl.support.SourceElementBody;
import org.eclipse.handly.model.impl.support.WorkingCopyHelper;
import org.eclipse.handly.model.impl.support.WorkingCopyInfo;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.ISnapshotProvider;
import org.eclipse.handly.snapshot.NonExpiringSnapshot;
import org.eclipse.handly.snapshot.TextFileSnapshot;
import org.eclipse.handly.util.Property;
import org.eclipse.handly.util.TextRange;
import org.eclipse.handly.util.ToStringOptions;

public interface ISourceFileImplSupport
extends ISourceElementImplSupport,
ISourceFileImplExtension {
    public static final Property<Object> SOURCE_AST = Property.get(String.valueOf(ISourceFileImplSupport.class.getName()) + ".sourceAst", Object.class);
    public static final Property<String> SOURCE_CONTENTS = Property.get(String.valueOf(ISourceFileImplSupport.class.getName()) + ".sourceContents", String.class);
    public static final Property<ISnapshot> SOURCE_SNAPSHOT = Property.get(String.valueOf(ISourceFileImplSupport.class.getName()) + ".sourceSnapshot", ISnapshot.class);

    @Override
    default public int defaultHashCode_() {
        IFile file = this.getFile_();
        if (file != null) {
            return file.hashCode();
        }
        return ISourceElementImplSupport.super.defaultHashCode_();
    }

    @Override
    default public boolean defaultEquals_(Object obj) {
        if (!(obj instanceof ISourceFileImplSupport)) {
            return false;
        }
        IFile file = this.getFile_();
        return (file == null || file.equals((Object)((ISourceFileImplSupport)obj).getFile_())) && ISourceElementImplSupport.super.defaultEquals_(obj);
    }

    @Override
    default public IBuffer getBuffer_(IContext context, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!this.acquireExistingWorkingCopy_((IProgressMonitor)subMonitor.split(10))) {
            return this.getFileBuffer_(context, (IProgressMonitor)subMonitor.split(90));
        }
        try {
            WorkingCopyInfo info = this.getElementManager_().peekAtWorkingCopyInfo(this);
            if (info == null) {
                throw new AssertionError((Object)"This method probably needs to be overridden");
            }
            IBuffer buffer = info.getBuffer();
            buffer.addRef();
            IBuffer iBuffer = buffer;
            return iBuffer;
        }
        finally {
            this.releaseWorkingCopy_();
        }
    }

    @Override
    default public boolean becomeWorkingCopy_(IContext context, IProgressMonitor monitor) throws CoreException {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        IBuffer buffer = (IBuffer)context.get(WORKING_COPY_BUFFER);
        if (buffer == null) {
            Throwable throwable = null;
            Object var5_7 = null;
            try (IBuffer defaultBuffer = this.getFileBuffer_(context, null);){
                return this.becomeWorkingCopy_(Contexts.with(Contexts.of(WORKING_COPY_BUFFER, defaultBuffer), context), monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        IWorkingCopyCallback callback = (IWorkingCopyCallback)context.get(WORKING_COPY_CALLBACK);
        if (callback == null) {
            callback = new DefaultWorkingCopyCallback();
        }
        WorkingCopyInfo info = new WorkingCopyInfo(buffer, this.newWorkingCopyContext_(context), new ReconcileStrategy(this), callback);
        return WorkingCopyHelper.becomeWorkingCopy(this, info, monitor);
    }

    @Override
    default public boolean acquireExistingWorkingCopy_(IProgressMonitor monitor) {
        return WorkingCopyHelper.acquireExistingWorkingCopy(this, monitor);
    }

    @Override
    default public boolean releaseWorkingCopy_() {
        WorkingCopyInfo info = this.getElementManager_().releaseWorkingCopyInfo(this);
        if (info == null) {
            throw new IllegalStateException("Not a working copy: " + this.toString_(Contexts.of(ToStringOptions.FORMAT_STYLE, ToStringOptions.FormatStyle.MEDIUM)));
        }
        if (info.isDisposed() && info.created) {
            this.workingCopyModeChanged_();
            return true;
        }
        return false;
    }

    @Override
    default public IContext getWorkingCopyContext_() {
        WorkingCopyInfo info = this.getElementManager_().peekAtWorkingCopyInfo(this);
        if (info == null) {
            return null;
        }
        if (info.created) {
            return info.getContext();
        }
        if (this.equals(ReconcileOperation.CURRENTLY_RECONCILED.get())) {
            return info.getContext();
        }
        return null;
    }

    @Override
    default public boolean isWorkingCopy_() {
        return this.getWorkingCopyContext_() != null;
    }

    @Override
    default public boolean needsReconciling_() {
        if (!this.acquireExistingWorkingCopy_(null)) {
            return false;
        }
        try {
            WorkingCopyInfo info = this.getElementManager_().peekAtWorkingCopyInfo(this);
            if (info == null) {
                throw new AssertionError((Object)"This method probably needs to be overridden");
            }
            boolean bl = info.callback.needsReconciling();
            return bl;
        }
        finally {
            this.releaseWorkingCopy_();
        }
    }

    @Override
    default public void reconcile_(IContext context, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!this.acquireExistingWorkingCopy_((IProgressMonitor)subMonitor.split(10))) {
            return;
        }
        try {
            WorkingCopyInfo info = this.getElementManager_().peekAtWorkingCopyInfo(this);
            if (info == null) {
                throw new AssertionError((Object)"This method probably needs to be overriden");
            }
            info.callback.reconcile(context, (IProgressMonitor)subMonitor.split(90));
        }
        finally {
            this.releaseWorkingCopy_();
        }
    }

    default public ReconcileOperation getReconcileOperation_() {
        if (Elements.getModelContext(this).get(INotificationManager.class) != null) {
            return new NotifyingReconcileOperation(this);
        }
        return new ReconcileOperation(this);
    }

    default public IContext newWorkingCopyContext_(IContext context) {
        return (IContext)context.getOrDefault(WORKING_COPY_CONTEXT);
    }

    default public void workingCopyModeChanged_() {
        INotificationManager notificationManager = Elements.getModelContext(this).get(INotificationManager.class);
        if (notificationManager == null) {
            return;
        }
        ElementDelta.Factory deltaFactory = Elements.getModelContext(this).get(ElementDelta.Factory.class);
        if (deltaFactory == null) {
            deltaFactory = element -> new ElementDelta(element);
        }
        ElementDelta.Builder builder = new ElementDelta.Builder(deltaFactory.newDelta(this.getRoot_()));
        if (this.fileExists_()) {
            builder.changed(this, 256L);
        } else if (this.isWorkingCopy_()) {
            builder.added(this, 256L);
        } else {
            builder.removed(this, 256L);
        }
        notificationManager.fireElementChangeEvent(new ElementChangeEvent(1, builder.getDelta()));
    }

    default public boolean fileExists_() {
        IFile file = this.getFile_();
        if (file == null) {
            throw new AssertionError((Object)"Please override this method");
        }
        return file.exists();
    }

    default public ISnapshotProvider getFileSnapshotProvider_() {
        IFile file = this.getFile_();
        if (file == null) {
            throw new AssertionError((Object)"Please override this method");
        }
        return () -> {
            TextFileSnapshot result = new TextFileSnapshot(file, TextFileSnapshot.Layer.FILESYSTEM);
            if (!result.exists()) {
                throw new IllegalStateException(this.newDoesNotExistException_());
            }
            if (result.getContents() == null && !result.getStatus().isOK()) {
                throw new IllegalStateException(new CoreException(result.getStatus()));
            }
            return result;
        };
    }

    default public IBuffer getFileBuffer_(IContext context, IProgressMonitor monitor) throws CoreException {
        IFile file = this.getFile_();
        if (file == null) {
            throw new AssertionError((Object)"Please override this method");
        }
        ICoreTextFileBufferProvider provider = ICoreTextFileBufferProvider.forLocation(file.getFullPath(), LocationKind.IFILE, ITextFileBufferManager.DEFAULT);
        if (!context.getOrDefault(Elements.CREATE_BUFFER).booleanValue() && provider.getBuffer() == null) {
            return null;
        }
        return new TextFileBuffer(provider, monitor);
    }

    @Override
    default public void validateExistence_(IContext context) throws CoreException {
        if (!this.isWorkingCopy_() && !this.fileExists_()) {
            throw this.newDoesNotExistException_();
        }
    }

    @Override
    default public void openParent_(IContext context, IProgressMonitor monitor) throws CoreException {
        if (this.isWorkingCopy_()) {
            return;
        }
        ISourceElementImplSupport.super.openParent_(context, monitor);
    }

    @Override
    default public void buildStructure_(IContext context, IProgressMonitor monitor) throws CoreException {
        if (!context.containsKey(SOURCE_CONTENTS) && !context.containsKey(SOURCE_AST)) {
            NonExpiringSnapshot snapshot;
            if (this.isWorkingCopy_()) {
                throw new AssertionError();
            }
            Throwable throwable = null;
            Object var5_5 = null;
            try (ISnapshotProvider provider = this.getFileSnapshotProvider_();){
                try {
                    snapshot = new NonExpiringSnapshot(provider);
                }
                catch (IllegalStateException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof CoreException) {
                        throw (CoreException)cause;
                    }
                    throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            context = Contexts.with(Contexts.of(SOURCE_CONTENTS, snapshot.getContents()), Contexts.of(SOURCE_SNAPSHOT, snapshot.getWrappedSnapshot()), context);
        }
        this.buildSourceStructure_(context, monitor);
        Map newElements = (Map)context.get(NEW_ELEMENTS);
        Object body = newElements.get(this);
        if (body instanceof SourceElementBody) {
            ISnapshot snapshot;
            SourceElementBody thisBody = (SourceElementBody)body;
            String source = context.get(SOURCE_CONTENTS);
            if (source != null) {
                thisBody.setFullRange(new TextRange(0, source.length()));
            }
            if ((snapshot = context.get(SOURCE_SNAPSHOT)) != null) {
                thisBody.setSnapshot(snapshot, newElements);
            }
        }
    }

    public void buildSourceStructure_(IContext var1, IProgressMonitor var2) throws CoreException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    default public void close_(IContext context) {
        ElementManager elementManager = this.getElementManager_();
        synchronized (elementManager) {
            if (this.isWorkingCopy_()) {
                return;
            }
            ISourceElementImplSupport.super.close_(context);
        }
    }

    @Override
    default public void toStringName_(StringBuilder builder, IContext context) {
        if (this.isWorkingCopy_()) {
            builder.append("[Working copy] ");
        }
        ISourceElementImplSupport.super.toStringName_(builder, context);
    }

    public static class NotifyingReconcileOperation
    extends ReconcileOperation {
        protected NotifyingReconcileOperation(ISourceFileImplSupport sourceFile) {
            super(sourceFile);
        }

        @Override
        protected void reconcile(IContext context, IProgressMonitor monitor) throws CoreException {
            if (!this.shouldReconcileStructure(context) || !this.shouldNotifyChange(context)) {
                super.reconcile(context, monitor);
            } else {
                ElementChangeRecorder recorder = this.newChangeRecorder();
                recorder.beginRecording(this.sourceFile);
                super.reconcile(context, monitor);
                IElementDelta delta = recorder.endRecording().getDelta();
                if (delta != null && ElementDeltas.getKind(delta) == 4) {
                    Elements.getModelContext(this.sourceFile).get(INotificationManager.class).fireElementChangeEvent(new ElementChangeEvent(2, delta));
                }
            }
        }

        protected boolean shouldNotifyChange(IContext context) {
            ISnapshot snapshot;
            if (NotifyingReconcileOperation.isInitialReconcile(context) && (snapshot = context.get(SOURCE_SNAPSHOT)) != null) {
                ISnapshot currentSnapshot;
                block15: {
                    currentSnapshot = null;
                    Object body = this.sourceFile.peekAtBody_();
                    if (body == null) {
                        Throwable throwable = null;
                        Object var6_7 = null;
                        try (ISnapshotProvider provider = this.sourceFile.getFileSnapshotProvider_();){
                            try {
                                currentSnapshot = provider.getSnapshot();
                            }
                            catch (IllegalStateException illegalStateException) {
                                // empty catch block
                            }
                            break block15;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    if (body instanceof SourceElementBody) {
                        currentSnapshot = ((SourceElementBody)body).getSnapshot();
                    }
                }
                if (snapshot.isEqualTo(currentSnapshot)) {
                    return false;
                }
            }
            return true;
        }

        protected ElementChangeRecorder newChangeRecorder() {
            return new ElementChangeRecorder();
        }
    }

    public static class ReconcileOperation {
        static final Property<Boolean> INITIAL_RECONCILE = Property.get(String.valueOf(ReconcileOperation.class.getName()) + ".initialReconcile", Boolean.class).withDefault(false);
        static final Property<Boolean> RECONCILING_FORCED = Property.get(String.valueOf(ReconcileOperation.class.getName()) + ".reconcilingForced", Boolean.class).withDefault(false);
        static final ThreadLocal<ISourceFileImplSupport> CURRENTLY_RECONCILED = new ThreadLocal();
        protected final ISourceFileImplSupport sourceFile;

        protected ReconcileOperation(ISourceFileImplSupport sourceFile) {
            if (sourceFile == null) {
                throw new IllegalArgumentException();
            }
            this.sourceFile = sourceFile;
        }

        protected void reconcile(IContext context, IProgressMonitor monitor) throws CoreException {
            if (this.shouldReconcileStructure(context)) {
                this.reconcileStructure(context, monitor);
            }
        }

        protected boolean shouldReconcileStructure(IContext context) {
            return ReconcileOperation.isInitialReconcile(context) || !ReconcileOperation.isReconcilingForced(context);
        }

        protected static boolean isInitialReconcile(IContext context) {
            return context.getOrDefault(INITIAL_RECONCILE);
        }

        protected static boolean isReconcilingForced(IContext context) {
            return context.getOrDefault(RECONCILING_FORCED);
        }

        protected void reconcileStructure(IContext context, IProgressMonitor monitor) throws CoreException {
            if (context.get(SOURCE_AST) == null && context.get(SOURCE_CONTENTS) == null) {
                throw new IllegalArgumentException();
            }
            if (CURRENTLY_RECONCILED.get() != null) {
                throw new AssertionError();
            }
            CURRENTLY_RECONCILED.set(this.sourceFile);
            try {
                this.sourceFile.open_(Contexts.with(Contexts.of(FORCE_OPEN, Boolean.valueOf(true)), context), monitor);
            }
            finally {
                CURRENTLY_RECONCILED.set(null);
            }
            if (ReconcileOperation.isInitialReconcile(context)) {
                WorkingCopyInfo info = this.sourceFile.getElementManager_().peekAtWorkingCopyInfo(this.sourceFile);
                if (!info.created) {
                    throw new AssertionError();
                }
                this.sourceFile.workingCopyModeChanged_();
            }
        }
    }
}

