/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.snapshot;

import org.eclipse.handly.snapshot.Snapshot;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.ISynchronizable;

public final class DocumentSnapshot
extends Snapshot {
    private final IDocument document;
    private final long modificationStamp;

    public DocumentSnapshot(IDocument document) {
        if (!(document instanceof IDocumentExtension4)) {
            throw new IllegalArgumentException();
        }
        this.document = document;
        this.modificationStamp = DocumentSnapshot.getModificationStamp(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getContents() {
        Object lock;
        if (this.document instanceof ISynchronizable && (lock = ((ISynchronizable)this.document).getLockObject()) != null) {
            Object object = lock;
            synchronized (object) {
                return this.internalGetContents();
            }
        }
        return this.internalGetContents();
    }

    @Override
    protected Boolean predictEquality(Snapshot other) {
        if (other instanceof DocumentSnapshot && this.document == ((DocumentSnapshot)other).document && this.modificationStamp == ((DocumentSnapshot)other).modificationStamp) {
            return true;
        }
        if (this.isStale()) {
            return false;
        }
        return null;
    }

    private String internalGetContents() {
        String result = null;
        if (!this.isStale()) {
            String contents = this.document.get();
            if (!this.isStale()) {
                result = contents;
            }
        }
        return result;
    }

    private boolean isStale() {
        return this.modificationStamp != DocumentSnapshot.getModificationStamp(this.document);
    }

    private static long getModificationStamp(IDocument document) {
        return ((IDocumentExtension4)document).getModificationStamp();
    }
}

