/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.IElementHandleFactory;
import org.eclipse.handly.model.IModel;
import org.eclipse.handly.model.ISourceConstruct;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.model.ISourceElementInfo;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.model.Models;
import org.eclipse.handly.model.impl.IElementImpl;
import org.eclipse.handly.model.impl.ISourceElementImpl;
import org.eclipse.handly.model.impl.ISourceFileImpl;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.StaleSnapshotException;
import org.eclipse.handly.util.Property;
import org.eclipse.handly.util.TextRange;

public class Elements {
    public static final IElement[] EMPTY_ARRAY = new IElement[0];
    public static final Property<ISnapshot> BASE_SNAPSHOT = Property.get(String.valueOf(Elements.class.getName()) + ".baseSnapshot", ISnapshot.class);
    public static final ISourceElementInfo NO_SOURCE_ELEMENT_INFO = new NoSourceElementInfo();
    public static final Property<Boolean> FORCE_RECONCILING = Property.get(String.valueOf(Elements.class.getName()) + ".forceReconciling", Boolean.class).withDefault(false);
    public static final Property<Boolean> CREATE_BUFFER = Property.get(String.valueOf(Elements.class.getName()) + ".createBuffer", Boolean.class).withDefault(true);

    public static String getName(IElement element) {
        return ((IElementImpl)element).getName_();
    }

    public static IElement getParent(IElement element) {
        return ((IElementImpl)element).getParent_();
    }

    public static IElement getRoot(IElement element) {
        return ((IElementImpl)element).getRoot_();
    }

    public static Iterable<IElement> getParentChain(IElement element) {
        return Elements.getParentChainUntil(element, null);
    }

    public static Iterable<IElement> getParentChainUntil(final IElement element, final Predicate<? super IElement> until) {
        return new Iterable<IElement>(){

            @Override
            public Iterator<IElement> iterator() {
                ParentChainItr it = new ParentChainItr(element);
                if (until == null) {
                    return it;
                }
                return it.with(until);
            }

            @Override
            public Spliterator<IElement> spliterator() {
                return Spliterators.spliteratorUnknownSize(this.iterator(), 1297);
            }
        };
    }

    public static Stream<IElement> streamParentChain(IElement element) {
        return Elements.streamParentChainUntil(element, null);
    }

    public static Stream<IElement> streamParentChainUntil(IElement element, Predicate<? super IElement> until) {
        return StreamSupport.stream(Elements.getParentChainUntil(element, until).spliterator(), false);
    }

    public static <T extends Collection<? super IElement>> T collectParentChain(IElement element, T collection) {
        while (element != null) {
            collection.add((IElement)element);
            element = Elements.getParent(element);
        }
        return collection;
    }

    /*
     * Unable to fully structure code
     */
    public static <T extends Collection<? super IElement>> T collectParentChainUntil(IElement element, T collection, Predicate<? super IElement> until) {
        if (until != null) ** GOTO lbl7
        return Elements.collectParentChain(element, collection);
        while (!until.test(element)) {
            collection.add((IElement)element);
            element = Elements.getParent(element);
lbl7:
            // 2 sources

            if (element != null) continue;
        }
        return collection;
    }

    public static IElement findMatchingAncestor(IElement element, Predicate<? super IElement> filter) {
        while (element != null) {
            if (filter.test(element)) {
                return element;
            }
            element = Elements.getParent(element);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static IElement findMatchingAncestorUntil(IElement element, Predicate<? super IElement> filter, Predicate<? super IElement> until) {
        if (until != null) ** GOTO lbl8
        return Elements.findMatchingAncestor(element, filter);
lbl-1000:
        // 1 sources

        {
            if (until.test(element)) {
                return null;
            }
            if (filter.test(element)) {
                return element;
            }
            element = Elements.getParent(element);
lbl8:
            // 2 sources

            ** while (element != null)
        }
lbl9:
        // 1 sources

        return null;
    }

    public static <T> T findAncestorOfType(IElement element, Class<T> type) {
        return type.cast(Elements.findMatchingAncestor(element, e -> type.isInstance(e)));
    }

    public static <T> T findAncestorOfTypeUntil(IElement element, Class<T> type, Predicate<? super IElement> until) {
        return type.cast(Elements.findMatchingAncestorUntil(element, e -> type.isInstance(e), until));
    }

    public static IElement findLastMatchingAncestor(IElement element, Predicate<? super IElement> filter) {
        IElement result = null;
        while (element != null) {
            if (filter.test(element)) {
                result = element;
            }
            element = Elements.getParent(element);
        }
        return result;
    }

    public static IElement findLastMatchingAncestorUntil(IElement element, Predicate<? super IElement> filter, Predicate<? super IElement> until) {
        if (until == null) {
            return Elements.findLastMatchingAncestor(element, filter);
        }
        IElement result = null;
        while (element != null) {
            if (until.test(element)) break;
            if (filter.test(element)) {
                result = element;
            }
            element = Elements.getParent(element);
        }
        return result;
    }

    public static <T> T findLastAncestorOfType(IElement element, Class<T> type) {
        return type.cast(Elements.findLastMatchingAncestor(element, e -> type.isInstance(e)));
    }

    public static <T> T findLastAncestorOfTypeUntil(IElement element, Class<T> type, Predicate<? super IElement> until) {
        return type.cast(Elements.findLastMatchingAncestorUntil(element, e -> type.isInstance(e), until));
    }

    public static IElement findCommonAncestor(IElement element, IElement other) {
        return Elements.findCommonAncestorUntil(element, other, null);
    }

    public static IElement findCommonAncestorUntil(IElement element, IElement other, Predicate<? super IElement> until) {
        if (element == null || other == null) {
            return null;
        }
        List parentChain = Elements.collectParentChainUntil(element, new ArrayList(), until);
        List otherParentChain = Elements.collectParentChainUntil(other, new ArrayList(), until);
        int index = -1;
        int i = parentChain.size() - 1;
        int j = otherParentChain.size() - 1;
        while (i >= 0 && j >= 0) {
            if (!((IElement)parentChain.get(i)).equals(otherParentChain.get(j))) break;
            index = i--;
            --j;
        }
        if (index == -1) {
            return null;
        }
        return (IElement)parentChain.get(index);
    }

    public static IElement findCommonAncestor(Iterable<? extends IElement> elements) {
        return Elements.findCommonAncestorUntil(elements, null);
    }

    public static IElement findCommonAncestorUntil(Iterable<? extends IElement> elements, Predicate<? super IElement> until) {
        IElement result = null;
        for (IElement iElement : elements) {
            if (iElement == null) {
                return null;
            }
            if (result != null) {
                result = Elements.findCommonAncestorUntil(result, iElement, until);
            } else if (until == null || !until.test(iElement)) {
                result = iElement;
            }
            if (result != null) continue;
            return null;
        }
        return result;
    }

    public static boolean isAncestorOf(IElement element, IElement other) {
        while (other != null) {
            if (Elements.equalsAndSameParentChain(element, other)) {
                return true;
            }
            other = Elements.getParent(other);
        }
        return false;
    }

    public static void removeDescendants(Collection<? extends IElement> elements) {
        Set<Key> keys = Key.toKeys(elements);
        Iterator<? extends IElement> it = elements.iterator();
        while (it.hasNext()) {
            if (!Key.hasAncestor(Key.toKey(Elements.getParent(it.next())), keys)) continue;
            it.remove();
        }
    }

    public static boolean equalsAndSameParentChain(IElement element, IElement other) {
        return ((IElementImpl)element).equalsAndSameParentChain_(other);
    }

    public static IModel getModel(IElement element) {
        return ((IElementImpl)element).getModel_();
    }

    public static boolean isOfModel(IElement element, IModel model) {
        return model.equals(Elements.getModel(element));
    }

    public static IContext getModelContext(IElement element) {
        return Models.getModelContext(Elements.getModel(element));
    }

    public static int getModelApiLevel(IElement element) {
        return Models.getModelApiLevel(Elements.getModel(element));
    }

    public static String getHandleMemento(IElement element) {
        return ((IElementImpl)element).getHandleMemento_();
    }

    public static IResource getResource(IElement element) {
        return ((IElementImpl)element).getResource_();
    }

    public static void splitIntoElementsAndResources(Iterable<?> objects, Collection<? super IElement> elements, IModel model, Collection<? super IResource> resources, IElementHandleFactory elementHandleFactory) {
        for (Object o : objects) {
            IElement element;
            if (o instanceof IElement) {
                IElement element2 = (IElement)o;
                if (model != null && !Elements.isOfModel(element2, model)) continue;
                elements.add(element2);
                continue;
            }
            if (resources == null || !(o instanceof IResource)) continue;
            IResource resource = (IResource)o;
            IElement iElement = element = elementHandleFactory == null ? null : elementHandleFactory.createFromResourceHandle(resource);
            if (element != null && (model == null || Elements.isOfModel(element, model)) && Elements.exists(element)) {
                elements.add(element);
                continue;
            }
            resources.add((IResource)resource);
        }
    }

    public static URI getLocationUri(IElement element) {
        return ((IElementImpl)element).getLocationUri_();
    }

    public static boolean exists(IElement element) {
        return ((IElementImpl)element).exists_();
    }

    public static IElement[] getChildren(IElement element) throws CoreException {
        return Elements.getChildren(element, Contexts.EMPTY_CONTEXT, null);
    }

    public static IElement[] getChildren(IElement element, IContext context, IProgressMonitor monitor) throws CoreException {
        return ((IElementImpl)element).getChildren_(context, monitor);
    }

    public static <T> T[] getChildrenOfType(IElement element, Class<T> type) throws CoreException {
        return Elements.getChildrenOfType(element, type, Contexts.EMPTY_CONTEXT, null);
    }

    public static <T> T[] getChildrenOfType(IElement element, Class<T> type, IContext context, IProgressMonitor monitor) throws CoreException {
        return ((IElementImpl)element).getChildrenOfType_(type, context, monitor);
    }

    public static String toString(IElement element, IContext context) {
        return ((IElementImpl)element).toString_(context);
    }

    public static String toDisplayString(IElement element, IContext context) {
        return ((IElementImpl)element).toDisplayString_(context);
    }

    public static ISourceElement getSourceElementAt(ISourceElement element, int position, ISnapshot base) throws CoreException {
        return Elements.getSourceElementAt(element, position, Contexts.of(BASE_SNAPSHOT, base), null);
    }

    public static ISourceElement getSourceElementAt(ISourceElement element, int position, IContext context, IProgressMonitor monitor) throws CoreException {
        return ((ISourceElementImpl)element).getSourceElementAt_(position, context, monitor);
    }

    public static ISourceElement getSourceElementAt2(ISourceElement element, int position, ISnapshot base) {
        try {
            return Elements.getSourceElementAt(element, position, base);
        }
        catch (CoreException e) {
            if (Elements.exists(element)) {
                Activator.logError(e);
            }
        }
        catch (StaleSnapshotException staleSnapshotException) {
            // empty catch block
        }
        return null;
    }

    public static ISourceElementInfo getSourceElementInfo(ISourceElement element) throws CoreException {
        return Elements.getSourceElementInfo(element, Contexts.EMPTY_CONTEXT, null);
    }

    public static ISourceElementInfo getSourceElementInfo(ISourceElement element, IContext context, IProgressMonitor monitor) throws CoreException {
        return ((ISourceElementImpl)element).getSourceElementInfo_(context, monitor);
    }

    public static ISourceElementInfo getSourceElementInfo2(ISourceElement element) {
        try {
            return Elements.getSourceElementInfo(element);
        }
        catch (CoreException e) {
            if (Elements.exists(element)) {
                Activator.logError(e);
            }
            return NO_SOURCE_ELEMENT_INFO;
        }
    }

    public static ISourceFile getSourceFile(IElement element) {
        return Elements.findAncestorOfType(element, ISourceFile.class);
    }

    public static boolean ensureReconciled(ISourceElement element, IProgressMonitor monitor) {
        ISourceFile sourceFile = Elements.getSourceFile(element);
        if (sourceFile != null) {
            try {
                Elements.reconcile(sourceFile, monitor);
            }
            catch (CoreException e) {
                Activator.logError(e);
                return false;
            }
        }
        return true;
    }

    public static IFile getFile(ISourceFile sourceFile) {
        return ((ISourceFileImpl)sourceFile).getFile_();
    }

    public static boolean isWorkingCopy(ISourceFile sourceFile) {
        return ((ISourceFileImpl)sourceFile).isWorkingCopy_();
    }

    public static boolean needsReconciling(ISourceFile sourceFile) {
        return ((ISourceFileImpl)sourceFile).needsReconciling_();
    }

    public static void reconcile(ISourceFile sourceFile, IProgressMonitor monitor) throws CoreException {
        Elements.reconcile(sourceFile, Contexts.EMPTY_CONTEXT, monitor);
    }

    public static void reconcile(ISourceFile sourceFile, IContext context, IProgressMonitor monitor) throws CoreException {
        ((ISourceFileImpl)sourceFile).reconcile_(context, monitor);
    }

    public static IBuffer getBuffer(ISourceFile sourceFile) throws CoreException {
        return Elements.getBuffer(sourceFile, Contexts.EMPTY_CONTEXT, null);
    }

    public static IBuffer getBuffer(ISourceFile sourceFile, IContext context, IProgressMonitor monitor) throws CoreException {
        return ((ISourceFileImpl)sourceFile).getBuffer_(context, monitor);
    }

    private Elements() {
    }

    private static class Key {
        final IElement e;

        Key(IElement e) {
            if (e == null) {
                throw new IllegalArgumentException();
            }
            this.e = e;
        }

        static Key toKey(IElement e) {
            return e != null ? new Key(e) : null;
        }

        static Set<Key> toKeys(Collection<? extends IElement> elements) {
            HashSet<Key> result = new HashSet<Key>(elements.size());
            for (IElement iElement : elements) {
                result.add(new Key(iElement));
            }
            return result;
        }

        static boolean hasAncestor(Key key, Set<Key> keys) {
            while (key != null) {
                if (keys.contains(key)) {
                    return true;
                }
                key = key.parent();
            }
            return false;
        }

        Key parent() {
            return Key.toKey(Elements.getParent(this.e));
        }

        public int hashCode() {
            return this.e.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Key)) {
                return false;
            }
            return Elements.equalsAndSameParentChain(this.e, ((Key)o).e);
        }
    }

    private static class NoSourceElementInfo
    implements ISourceElementInfo {
        static final ISourceConstruct[] NO_CHILDREN = new ISourceConstruct[0];

        private NoSourceElementInfo() {
        }

        @Override
        public ISnapshot getSnapshot() {
            return null;
        }

        @Override
        public <T> T get(Property<T> property) {
            return null;
        }

        @Override
        public ISourceConstruct[] getChildren() {
            return NO_CHILDREN;
        }

        @Override
        public TextRange getFullRange() {
            return null;
        }

        @Override
        public TextRange getIdentifyingRange() {
            return null;
        }
    }

    private static class ParentChainItr
    implements Iterator<IElement> {
        private IElement next;

        ParentChainItr(IElement from) {
            this.next = from;
        }

        Iterator<IElement> with(final Predicate<? super IElement> until) {
            return new ParentChainItr(this.next){

                @Override
                public boolean hasNext() {
                    if (!super.hasNext()) {
                        return false;
                    }
                    return !until.test(this.peekNext());
                }
            };
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public IElement next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            IElement result = this.next;
            this.next = Elements.getParent(this.next);
            return result;
        }

        IElement peekNext() {
            return this.next;
        }
    }
}

