/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.snapshot;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.snapshot.Snapshot;
import org.eclipse.handly.snapshot.TextFileSnapshotBase;
import org.eclipse.handly.snapshot.TextFileSnapshotWs;
import org.eclipse.handly.snapshot.TextFileStoreSnapshot;

public final class TextFileSnapshot
extends TextFileSnapshotBase {
    private final TextFileSnapshotBase delegate;

    public TextFileSnapshot(IFile file, Layer layer) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.delegate = TextFileSnapshot.createDelegate(file, layer);
    }

    @Override
    public String getContents() {
        return this.delegate.getContents();
    }

    @Override
    public IStatus getStatus() {
        return this.delegate.getStatus();
    }

    @Override
    public boolean exists() {
        return this.delegate.exists();
    }

    @Override
    protected Boolean predictEquality(Snapshot other) {
        if (other instanceof TextFileSnapshot) {
            return this.delegate.predictEquality(((TextFileSnapshot)other).delegate);
        }
        return null;
    }

    private static TextFileSnapshotBase createDelegate(IFile file, Layer layer) {
        if (layer == Layer.FILESYSTEM) {
            IFileStore fileStore;
            URI uri = file.getLocationURI();
            if (uri == null) {
                return NON_EXISTING;
            }
            try {
                fileStore = EFS.getStore((URI)uri);
            }
            catch (CoreException e) {
                Activator.logError(e);
                return NON_EXISTING;
            }
            return new TextFileStoreSnapshot(fileStore);
        }
        return new TextFileSnapshotWs(file);
    }

    public static enum Layer {
        WORKSPACE,
        FILESYSTEM;

    }
}

