/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.graph.updater;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.hawk.core.IMetaModelResourceFactory;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.graph.IGraphChangeListener;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeIndex;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.core.model.IHawkAttribute;
import org.eclipse.hawk.core.model.IHawkClass;
import org.eclipse.hawk.core.model.IHawkClassifier;
import org.eclipse.hawk.core.model.IHawkDataType;
import org.eclipse.hawk.core.model.IHawkMetaModelResource;
import org.eclipse.hawk.core.model.IHawkObject;
import org.eclipse.hawk.core.model.IHawkPackage;
import org.eclipse.hawk.core.model.IHawkReference;
import org.eclipse.hawk.core.model.IHawkStructuralFeature;
import org.eclipse.hawk.core.runtime.CompositeGraphChangeListener;
import org.eclipse.hawk.core.util.CompositeException;
import org.eclipse.hawk.graph.Slot;
import org.eclipse.hawk.graph.updater.DeletionUtils;
import org.eclipse.hawk.graph.updater.DirtyDerivedFeaturesListener;
import org.eclipse.hawk.graph.updater.GraphModelInserter;
import org.eclipse.hawk.graph.updater.TypeCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphMetaModelResourceInjector {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphMetaModelResourceInjector.class);
    private int objectCount = 0;
    private IModelIndexer hawk;
    private IGraphDatabase graph;
    private final long startTime = System.nanoTime();
    private final CompositeGraphChangeListener listener;

    public GraphMetaModelResourceInjector(IModelIndexer hawk, Set<IHawkMetaModelResource> set, CompositeGraphChangeListener listener) throws Exception {
        this.hawk = hawk;
        this.graph = hawk.getGraph();
        this.listener = listener;
        LOGGER.info("ADDING METAMODELS: ");
        LOGGER.info("ADDING: ");
        int nodes = this.insertMetamodels(set);
        LOGGER.info("{} METAMODEL NODES! (took ~{} sec)", (Object)nodes, (Object)((System.nanoTime() - this.startTime) / 1000000000L));
    }

    public GraphMetaModelResourceInjector(IModelIndexer hawk, CompositeGraphChangeListener listener) {
        this.hawk = hawk;
        this.graph = hawk.getGraph();
        this.listener = listener;
    }

    public void removeMetamodels(Set<IHawkMetaModelResource> set) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (IGraphTransaction t = this.graph.beginTransaction();){
                this.listener.changeStart();
                IGraphNodeIndex ePackageDictionary = this.graph.getMetamodelIndex();
                HashSet<IGraphNode> epns = new HashSet<IGraphNode>();
                for (IHawkMetaModelResource metamodelResource : set) {
                    Set children = metamodelResource.getAllContents();
                    for (IHawkObject child : children) {
                        if (!(child instanceof IHawkPackage)) continue;
                        Iterator it = ePackageDictionary.get("id", (Object)((IHawkPackage)child).getNsURI()).iterator();
                        if (!it.hasNext()) {
                            LOGGER.warn("Metamodel: {} with uri: {} not indexed. Nothing happened.", (Object)((IHawkPackage)child).getName(), (Object)((IHawkPackage)child).getNsURI());
                            continue;
                        }
                        IGraphNode epn = (IGraphNode)it.next();
                        LOGGER.info("Removing metamodel: {} with uri: {}", (Object)((IHawkPackage)child).getName(), (Object)((IHawkPackage)child).getNsURI());
                        epns.add(epn);
                    }
                }
                this.removeAll(epns);
                t.success();
                this.listener.changeSuccess();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e1) {
            this.listener.changeFailure();
            LOGGER.error("Error in removing metamodels (all removal changes reverted)", (Throwable)e1);
        }
    }

    private Set<String> removeAll(Set<IGraphNode> epns) throws Exception {
        HashSet<String> affectedRepositories = new HashSet<String>();
        DeletionUtils del = new DeletionUtils(this.graph);
        for (IGraphNode epn : epns) {
            for (IGraphEdge rel : epn.getIncomingWithType("dependency")) {
                LOGGER.debug("dependency from {} to {}", rel.getStartNode().getProperty("_hawkid"), epn.getProperty("_hawkid"));
                IGraphNode depmm = rel.getStartNode();
                del.delete(rel);
                epns.add(depmm);
            }
        }
        HashSet<IGraphNode> files = new HashSet<IGraphNode>();
        for (IGraphNode n : epns) {
            files.addAll(this.remove(n));
        }
        for (IGraphNode file : files) {
            affectedRepositories.add(file.getProperty("repository").toString());
        }
        for (IGraphNode file : files) {
            del.delete(file);
        }
        return affectedRepositories;
    }

    private Set<IGraphNode> remove(IGraphNode epn) throws Exception {
        long start = System.currentTimeMillis();
        HashSet<IGraphNode> fileNodes = new HashSet<IGraphNode>();
        Throwable throwable = null;
        Object var6_6 = null;
        try (IGraphTransaction transaction = this.graph.beginTransaction();){
            LOGGER.info("Deleting nodes from metamodel: {}", epn.getProperty("_hawkid"));
            HashSet<IGraphNode> metaModelElements = new HashSet<IGraphNode>();
            HashSet<IGraphNode> modelElements = new HashSet<IGraphNode>();
            DeletionUtils del = new DeletionUtils(this.graph);
            for (IGraphEdge rel : epn.getIncomingWithType("epackage")) {
                metaModelElements.add(rel.getStartNode());
                del.delete(rel);
            }
            for (IGraphEdge rel : epn.getOutgoingWithType("dependency")) {
                del.delete(rel);
            }
            del.delete(epn);
            for (IGraphNode metamodelelement : metaModelElements) {
                for (IGraphEdge rel : metamodelelement.getIncomingWithType("_hawkOfType")) {
                    modelElements.add(rel.getStartNode());
                    del.delete(rel);
                }
            }
            for (IGraphNode metamodelelement : metaModelElements) {
                for (IGraphEdge rel : metamodelelement.getIncomingWithType("_hawkOfKind")) {
                    modelElements.add(rel.getStartNode());
                    del.delete(rel);
                }
            }
            for (IGraphNode metaModelElement : metaModelElements) {
                del.delete(metaModelElement);
            }
            if (modelElements.size() > 0) {
                LOGGER.info("Deleting nodes from relevant models...");
                HashSet<Object> toBeUpdated = new HashSet<IGraphNode>();
                DirtyDerivedFeaturesListener l = new DirtyDerivedFeaturesListener(this.graph);
                if (!this.hawk.getDerivedAttributes().isEmpty()) {
                    this.hawk.addGraphChangeListener((IGraphChangeListener)l);
                }
                for (IGraphNode modelElement : modelElements) {
                    Iterator it = modelElement.getOutgoingWithType("_hawkFile").iterator();
                    if (it.hasNext()) {
                        IGraphEdge e = (IGraphEdge)it.next();
                        fileNodes.add(e.getEndNode());
                        del.delete(e);
                    }
                    del.dereference(modelElement, (IGraphChangeListener)this.listener, null);
                }
                for (IGraphNode modelElement : modelElements) {
                    del.delete(modelElement);
                }
                toBeUpdated.addAll(l.getNodesToBeUpdated());
                this.listener.remove((Object)l);
                LOGGER.info("Updating any relevant derived attributes...");
                try {
                    new GraphModelInserter(this.hawk, () -> del, new TypeCache(this.hawk)).updateDerivedAttributes(this.hawk.getDerivedAttributeExecutionEngine(), toBeUpdated);
                    toBeUpdated = new HashSet();
                }
                catch (Exception e) {
                    toBeUpdated = new HashSet();
                    LOGGER.error("Exception while updating derived attributes", (Throwable)e);
                }
            }
            transaction.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        LOGGER.info("deleted all, took: {}s", (Object)((double)(System.currentTimeMillis() - start) / 1000.0));
        return fileNodes;
    }

    private int insertMetamodels(Set<IHawkMetaModelResource> metamodels) throws Exception {
        Object t;
        HashMap<String, IHawkPackage> expanded = new HashMap<String, IHawkPackage>();
        this.expandWithDependencies(metamodels, expanded);
        HashSet<IHawkPackage> addedPackages = new HashSet<IHawkPackage>();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (IGraphTransaction t2 = this.graph.beginTransaction();){
                this.listener.changeStart();
                IGraphNodeIndex ePackageDictionary = this.graph.getMetamodelIndex();
                for (IHawkPackage pkg : expanded.values()) {
                    if (!this.addEPackage(pkg, ePackageDictionary)) continue;
                    addedPackages.add(pkg);
                }
                t2.success();
                this.listener.changeSuccess();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            this.listener.changeFailure();
            throw ex;
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        Iterator itPackage = addedPackages.iterator();
        while (itPackage.hasNext()) {
            boolean revert;
            IHawkPackage epackage;
            block44: {
                epackage = (IHawkPackage)itPackage.next();
                revert = false;
                t = this.graph.beginTransaction();
                try {
                    try {
                        this.listener.changeStart();
                        this.addEClasses(epackage);
                        t.success();
                        this.listener.changeSuccess();
                    }
                    catch (Exception eAddPackage) {
                        LOGGER.error(eAddPackage.getMessage(), (Throwable)eAddPackage);
                        t.failure();
                        this.listener.changeFailure();
                        exceptions.add(new FailedMetamodelRegistrationException(epackage.getNsURI(), eAddPackage));
                        itPackage.remove();
                        revert = true;
                        t.close();
                        break block44;
                    }
                }
                catch (Throwable throwable) {
                    t.close();
                    throw throwable;
                }
                t.close();
            }
            if (!revert) continue;
            try {
                Throwable eAddPackage = null;
                Object var10_20 = null;
                try (IGraphTransaction t2 = this.graph.beginTransaction();){
                    IGraphNode ePackageNode = (IGraphNode)this.graph.getMetamodelIndex().get("id", (Object)epackage.getNsURI()).iterator().next();
                    new DeletionUtils(this.graph).delete(ePackageNode);
                    t2.success();
                }
                catch (Throwable throwable) {
                    if (eAddPackage == null) {
                        eAddPackage = throwable;
                    } else if (eAddPackage != throwable) {
                        eAddPackage.addSuppressed(throwable);
                    }
                    throw eAddPackage;
                }
            }
            catch (Exception eRevertAddition) {
                LOGGER.error(eRevertAddition.getMessage(), (Throwable)eRevertAddition);
                exceptions.add(eRevertAddition);
            }
        }
        for (IHawkPackage ePackage : addedPackages) {
            try {
                t = null;
                Iterator iterator = null;
                try (IGraphTransaction t3 = this.graph.beginTransaction();){
                    IGraphNode epackagenode = (IGraphNode)this.graph.getMetamodelIndex().get("id", (Object)ePackage.getNsURI()).getSingle();
                    Optional s = ePackage.getResource().getMetaModelResourceFactory().dumpPackageToString(ePackage);
                    if (s.isPresent()) {
                        epackagenode.setProperty("resource", s.get());
                    }
                    t3.success();
                }
                catch (Throwable throwable) {
                    if (t == null) {
                        t = throwable;
                    } else if (t != throwable) {
                        ((Throwable)t).addSuppressed(throwable);
                    }
                    throw t;
                }
            }
            catch (Exception eSaveResource) {
                LOGGER.error("Cannot save package into the metamodel node", (Throwable)eSaveResource);
                exceptions.add(eSaveResource);
            }
        }
        if (!exceptions.isEmpty()) {
            throw new CompositeException(exceptions);
        }
        return this.objectCount;
    }

    private void expandWithDependencies(Set<IHawkMetaModelResource> metamodels, Map<String, IHawkPackage> expanded) throws Exception {
        HashSet<String> alreadyInGraph = new HashSet<String>();
        boolean firstBatch = false;
        do {
            Iterator<IHawkMetaModelResource> itM = metamodels.iterator();
            while (itM.hasNext()) {
                IHawkMetaModelResource m = itM.next();
                for (IHawkObject child : m.getAllContents()) {
                    if (!(child instanceof IHawkPackage)) continue;
                    IHawkPackage pkg = (IHawkPackage)child;
                    if (pkg.getNsURI() == null) {
                        LOGGER.info("Package {} has null URI, ignoring", (Object)pkg.getName());
                        continue;
                    }
                    if (firstBatch && this.isMetamodelRegistered(pkg.getNsURI())) {
                        alreadyInGraph.add(pkg.getNsURI());
                        itM.remove();
                        LOGGER.info("Package {} already in the graph, ignoring", (Object)pkg.getNsURI());
                        continue;
                    }
                    expanded.put(pkg.getNsURI(), pkg);
                }
            }
            firstBatch = false;
            HashSet<String> missingURIs = new HashSet<String>();
            this.addPendingDependencies(metamodels, expanded, missingURIs, alreadyInGraph);
            metamodels.clear();
            block3: for (String uri : missingURIs) {
                for (IMetaModelResourceFactory mp : this.hawk.getMetaModelParsers()) {
                    IHawkMetaModelResource mr = mp.getMetamodel(uri);
                    if (mr == null) continue;
                    metamodels.add(mr);
                    continue block3;
                }
                throw new MissingMetamodelException(uri);
            }
        } while (!metamodels.isEmpty());
    }

    private void addPendingDependencies(Set<IHawkMetaModelResource> metamodels, Map<String, IHawkPackage> expanded, Set<String> missingURIs, Set<String> alreadyInGraph) throws Exception {
        for (IHawkMetaModelResource m : metamodels) {
            for (IHawkObject child : m.getAllContents()) {
                if (!(child instanceof IHawkPackage)) continue;
                IHawkPackage pkg = (IHawkPackage)child;
                for (IHawkClassifier pkgClassifier : pkg.getClasses()) {
                    if (!(pkgClassifier instanceof IHawkClass)) continue;
                    IHawkClass eClass = (IHawkClass)pkgClassifier;
                    for (IHawkClass st : eClass.getAllSuperTypes()) {
                        this.addPendingDependencies(expanded, missingURIs, alreadyInGraph, (IHawkClassifier)st);
                    }
                    for (IHawkAttribute e : eClass.getAllAttributes()) {
                        if (e.getType() == null) continue;
                        this.addPendingDependencies(expanded, missingURIs, alreadyInGraph, e.getType());
                    }
                    for (IHawkReference r : eClass.getAllReferences()) {
                        this.addPendingDependencies(expanded, missingURIs, alreadyInGraph, r.getType());
                    }
                }
            }
        }
    }

    private void addPendingDependencies(Map<String, IHawkPackage> toBeRegistered, Set<String> missingURIs, Set<String> alreadyInGraph, IHawkClassifier targetType) throws Exception {
        String nsURI = targetType.getPackageNSURI();
        if (!(nsURI == null || toBeRegistered.containsKey(nsURI) || missingURIs.contains(nsURI) || alreadyInGraph.contains(nsURI))) {
            if (!this.isMetamodelRegistered(nsURI)) {
                missingURIs.add(nsURI);
            } else {
                alreadyInGraph.add(nsURI);
            }
        }
    }

    private boolean isMetamodelRegistered(String nsURI) throws Exception {
        boolean ret = false;
        Throwable throwable = null;
        Object var4_5 = null;
        try (IGraphTransaction tx = this.graph.beginTransaction();){
            IGraphIterable iterMatches = this.graph.getMetamodelIndex().get("id", (Object)nsURI);
            ret = iterMatches.iterator().hasNext();
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return ret;
    }

    private void addEClasses(IHawkPackage ePackage) throws MissingMetamodelException {
        for (IHawkClassifier child : ePackage.getClasses()) {
            if (child instanceof IHawkClass) {
                this.addMetaClass((IHawkClass)child);
                continue;
            }
            if (child instanceof IHawkDataType) {
                if (child.getInstanceType() != null) {
                    LOGGER.warn("Hawk does not support custom data types yet: {}::{} will be handled as its instance type {}", new Object[]{ePackage.getNsURI(), child.getName(), child.getInstanceType()});
                    continue;
                }
                LOGGER.warn("Hawk does not support custom data types yet: {}::{} will be handled as a string", (Object)ePackage.getNsURI(), (Object)child.getName());
                continue;
            }
            LOGGER.error("Unknown classifier: ({}): {}", (Object)child.getName(), child.getClass());
        }
    }

    private boolean addEPackage(IHawkPackage ePackage, IGraphNodeIndex ePackageDictionary) throws IOException {
        String uri = ePackage.getNsURI();
        if (uri == null) {
            LOGGER.warn("ePackage {} has null nsURI, ignoring", (Object)ePackage);
            return false;
        }
        if (!ePackageDictionary.get("id", (Object)uri).iterator().hasNext()) {
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put("_hawkid", uri);
            fields.put("type", ePackage.getResource().getMetaModelResourceFactory().getType());
            IGraphNode epackagenode = this.graph.createNode(fields, "epackage");
            ePackageDictionary.add(epackagenode, "id", (Object)uri);
            this.listener.metamodelAddition(ePackage, epackagenode);
            return true;
        }
        LOGGER.warn("metamodel: {} ({}) already in store, updating it instead NYI -- doing nothing!", (Object)ePackage.getName(), (Object)uri);
        return false;
    }

    public String getEObjectId(IHawkClass eClass) {
        return String.valueOf(eClass.getPackageNSURI()) + "/" + eClass.getName();
    }

    private void createEClassNode(IHawkClass eClass, String id) throws MissingMetamodelException {
        String[] metadata;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_hawkid", id);
        IGraphNode node = this.graph.createNode(new HashMap(), "eclass");
        IGraphNode metamodelNode = (IGraphNode)this.graph.getMetamodelIndex().get("id", (Object)eClass.getPackageNSURI()).getSingle();
        this.graph.createRelationship(node, metamodelNode, "epackage");
        for (IHawkClass superType : eClass.getAllSuperTypes()) {
            this.addMetamodelDependency(eClass, metamodelNode, (IHawkClassifier)superType);
        }
        for (IHawkAttribute e : eClass.getAllAttributes()) {
            if (e.getType() != null) {
                this.addMetamodelDependency(eClass, metamodelNode, e.getType());
            }
            metadata = new Slot.MetadataBuilder().attribute().many(e.isMany()).ordered(e.isOrdered()).unique(e.isUnique()).type(this.getPropertyType((IHawkStructuralFeature)e)).build();
            map.put(e.getName(), metadata);
        }
        for (IHawkReference r : eClass.getAllReferences()) {
            this.addMetamodelDependency(eClass, metamodelNode, r.getType());
            metadata = new Slot.MetadataBuilder().reference().many(r.isMany()).ordered(r.isOrdered()).unique(r.isUnique()).type(this.getPropertyType((IHawkStructuralFeature)r)).build();
            map.put(r.getName(), metadata);
        }
        for (String s : map.keySet()) {
            node.setProperty(s, map.get(s));
        }
        this.listener.classAddition(eClass, node);
    }

    private String getPropertyType(IHawkStructuralFeature e) {
        String propType = "unknown";
        if (e.getType() != null) {
            if (e.getType().getName() != null) {
                propType = e.getType().getInstanceType();
            } else {
                LOGGER.warn("warning: unknown (null) type NAME found in metamodel parsing into db for attribute: {} of type: {}", (Object)e.getName(), (Object)e.getType());
            }
        } else {
            LOGGER.warn("warning: unknown (null) type found in metamodel parsing into db for attribute: {}", (Object)e.getName());
        }
        return propType;
    }

    private void addMetamodelDependency(IHawkClass sourceType, IGraphNode metamodelNode, IHawkClassifier targetType) throws MissingMetamodelException {
        IGraphNode superTypeEPackage;
        String targetTypeMetamodelURI = targetType.getPackageNSURI();
        IGraphIterable metamodels = this.graph.getMetamodelIndex().get("id", (Object)targetTypeMetamodelURI);
        if (!metamodels.iterator().hasNext()) {
            LOGGER.error("EClass {} has supertype {} which is in a package not registered yet, reverting all changes to this package registration, please register package with URI {} first", new Object[]{sourceType.getName(), targetType.getName() == null ? targetType.getUri() : targetType.getName(), targetTypeMetamodelURI});
            throw new MissingMetamodelException(targetTypeMetamodelURI);
        }
        if (!targetTypeMetamodelURI.equals(sourceType.getPackageNSURI()) && !this.metamodelDependencyExists(metamodelNode, superTypeEPackage = (IGraphNode)metamodels.getSingle())) {
            LOGGER.debug("supertype dependency from {} to {}", (Object)sourceType.getPackageNSURI(), (Object)targetTypeMetamodelURI);
            this.graph.createRelationship(metamodelNode, superTypeEPackage, "dependency");
        }
    }

    private boolean metamodelDependencyExists(IGraphNode metamodelNode, IGraphNode superTypeEPackage) {
        boolean alreadythere = false;
        Iterable depEdges = metamodelNode.getOutgoingWithType("dependency");
        for (IGraphEdge r : depEdges) {
            if (!r.getEndNode().equals((Object)superTypeEPackage)) continue;
            alreadythere = true;
            break;
        }
        return alreadythere;
    }

    private void addMetaClass(IHawkClass eClass) throws MissingMetamodelException {
        String id = eClass.getName();
        ++this.objectCount;
        this.createEClassNode(eClass, id);
    }

    public static boolean addDerivedAttribute(String metamodeluri, String typename, String attributename, boolean isMany, boolean isOrdered, boolean isUnique, String attributetype, String derivationlanguage, String derivationlogic, IGraphDatabase graph, IGraphChangeListener listener) {
        boolean requiresPropagationToInstances = false;
        try {
            Throwable throwable = null;
            Object var13_15 = null;
            try (IGraphTransaction t = graph.beginTransaction();){
                listener.changeStart();
                IGraphIterable ep = graph.getMetamodelIndex().get("id", (Object)metamodeluri);
                IGraphNode packagenode = null;
                if (ep.size() != 1) {
                    throw new Exception("metamodel not found:" + metamodeluri);
                }
                packagenode = (IGraphNode)ep.getSingle();
                IGraphNode typenode = null;
                for (IGraphEdge e : packagenode.getIncomingWithType("epackage")) {
                    if (!e.getStartNode().getProperty("_hawkid").equals(typename)) continue;
                    typenode = e.getStartNode();
                    break;
                }
                if (typenode == null) {
                    LOGGER.error("type: {} in: {} does not exist, aborting operation: addDerivedAttribute", (Object)typename, (Object)metamodeluri);
                } else {
                    if (typenode.getIncomingWithType("_hawkOfType").iterator().hasNext() || typenode.getIncomingWithType("_hawkOfKind").iterator().hasNext()) {
                        requiresPropagationToInstances = true;
                    }
                    String[] metadata = new String[]{"d", isMany ? "t" : "f", isOrdered ? "t" : "f", isUnique ? "t" : "f", attributetype, derivationlanguage, derivationlogic};
                    if (typenode.getProperty(attributename) != null) {
                        LOGGER.warn("Attribute already derived, nothing happened!");
                        requiresPropagationToInstances = false;
                    } else {
                        typenode.setProperty(attributename, (Object)metadata);
                        if (LOGGER.isInfoEnabled()) {
                            String logic = derivationlogic.length() > 100 ? String.valueOf(derivationlogic.substring(0, 100)) + "\n[! long script, snipped !]" : derivationlogic;
                            LOGGER.info("Derived attribute added: {}::{}#{} (isMany={}|isOrdered={}|isUnique={}|type={}) {}#\n{}", new Object[]{metamodeluri, typename, attributename, isMany, isOrdered, isUnique, attributetype, derivationlanguage, logic});
                        }
                    }
                    graph.getOrCreateNodeIndex(String.valueOf(metamodeluri) + "##" + typename + "##" + attributename);
                }
                t.success();
                listener.changeSuccess();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e1) {
            LOGGER.error("error in adding a derived attribute to the metamodel", (Throwable)e1);
            listener.changeFailure();
        }
        return requiresPropagationToInstances;
    }

    public static boolean addIndexedAttribute(String metamodeluri, String typename, String attributename, IGraphDatabase graph, IGraphChangeListener listener) {
        boolean requiresPropagationToInstances = false;
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (IGraphTransaction t = graph.beginTransaction();){
                listener.changeStart();
                IGraphNode packagenode = (IGraphNode)graph.getMetamodelIndex().get("id", (Object)metamodeluri).getSingle();
                IGraphNode typenode = null;
                for (IGraphEdge e : packagenode.getIncomingWithType("epackage")) {
                    if (!e.getStartNode().getProperty("_hawkid").equals(typename)) continue;
                    typenode = e.getStartNode();
                    break;
                }
                if (typenode == null) {
                    LOGGER.error("type: {} in: {} does not exist, aborting operation: addIndexedAttribute", (Object)typename, (Object)metamodeluri);
                } else {
                    String[] metadata = (String[])typenode.getProperty(attributename);
                    if (metadata == null) {
                        LOGGER.error("attribute: {} in: {}#{} does not exist, aborting operation: addIndexedAttribute", new Object[]{attributename, metamodeluri, typename});
                    } else if (!metadata[0].equals("a")) {
                        LOGGER.error("{}#{} is not an attribute, aborting operation: addIndexedAttribute", (Object)metamodeluri, (Object)typename);
                    } else {
                        if (typenode.getIncomingWithType("_hawkOfType").iterator().hasNext() || typenode.getIncomingWithType("_hawkOfKind").iterator().hasNext()) {
                            requiresPropagationToInstances = true;
                        }
                        if (metadata.length == 6) {
                            if ("t".equals(metadata[5])) {
                                LOGGER.warn("attribute already indexed, nothing happened!");
                                requiresPropagationToInstances = false;
                            } else {
                                metadata[5] = "t";
                                typenode.setProperty(attributename, (Object)metadata);
                                graph.getOrCreateNodeIndex(String.valueOf(metamodeluri) + "##" + typename + "##" + attributename);
                                LOGGER.info("indexed attribute added: {}::{}#{}", new Object[]{metamodeluri, typename, attributename});
                            }
                        } else if (metadata.length == 7) {
                            LOGGER.warn("derived attributes are already indexed, nothing happened.");
                        } else {
                            LOGGER.error("unknown exception in addIndexedAttribute of GraphMetamodelResourceInjector");
                        }
                    }
                }
                t.success();
                listener.changeSuccess();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in adding an indexed attribute", (Throwable)e);
            listener.changeFailure();
        }
        return requiresPropagationToInstances;
    }

    public Set<String> removeMetamodels(String[] mmuris) {
        Set<String> ret = new HashSet<String>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (IGraphTransaction t = this.graph.beginTransaction();){
                Set indexNames = this.graph.getNodeIndexNames();
                HashSet<IGraphNodeIndex> markedForRemoval = new HashSet<IGraphNodeIndex>();
                this.listener.changeStart();
                IGraphNodeIndex ePackageDictionary = this.graph.getMetamodelIndex();
                HashSet<IGraphNode> epns = new HashSet<IGraphNode>();
                String[] stringArray = mmuris;
                int n = mmuris.length;
                int n2 = 0;
                while (n2 < n) {
                    String mmuri = stringArray[n2];
                    try {
                        Iterator it = indexNames.iterator();
                        while (it.hasNext()) {
                            String s = (String)it.next();
                            if (!s.startsWith(String.valueOf(mmuri) + "##")) continue;
                            IGraphNodeIndex i = this.graph.getOrCreateNodeIndex(s);
                            markedForRemoval.add(i);
                            it.remove();
                        }
                        epns.add((IGraphNode)ePackageDictionary.get("id", (Object)mmuri).getSingle());
                    }
                    catch (Exception e) {
                        LOGGER.error("Metamodel with URI " + mmuri + " not indexed. Nothing happened.", (Throwable)e);
                    }
                    ++n2;
                }
                if (epns.size() > 0) {
                    LOGGER.info("Removing metamodels with URIs {}", (Object)Arrays.toString(mmuris));
                    ret = this.removeAll(epns);
                }
                for (IGraphNodeIndex i : markedForRemoval) {
                    LOGGER.info("Deleting index {} as its metamodel was removed.", (Object)i.getName());
                    i.delete();
                }
                t.success();
                this.listener.changeSuccess();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.listener.changeFailure();
            LOGGER.error("Error in removing metamodels " + Arrays.toString(mmuris) + "\n(ALL removal changes reverted)", (Throwable)e);
        }
        return ret;
    }

    public static boolean removeIndexedAttribute(String metamodelUri, String typename, String attributename, IGraphDatabase graph, CompositeGraphChangeListener listener) {
        boolean found = false;
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (IGraphTransaction t = graph.beginTransaction();){
                listener.changeStart();
                IGraphNode packagenode = null;
                IGraphIterable ep = graph.getMetamodelIndex().get("id", (Object)metamodelUri);
                if (ep.size() != 1) {
                    throw new Exception("metamodel not found:" + metamodelUri);
                }
                packagenode = (IGraphNode)ep.getSingle();
                IGraphNode typenode = null;
                for (IGraphEdge e : packagenode.getIncomingWithType("epackage")) {
                    if (!e.getStartNode().getProperty("_hawkid").equals(typename)) continue;
                    typenode = e.getStartNode();
                    break;
                }
                if (typenode == null) {
                    LOGGER.error("type: {} in: {} does not exist, aborting operation: removeIndexedAttribute", (Object)typename, (Object)metamodelUri);
                    listener.changeFailure();
                } else {
                    String[] metadata = (String[])typenode.getProperty(attributename);
                    if (metadata == null) {
                        LOGGER.error("attribute: {} in: {}::{} does not exist, aborting operation: removeIndexedAttribute", new Object[]{attributename, metamodelUri, typename});
                        listener.changeFailure();
                    } else if (!metadata[0].equals("a")) {
                        LOGGER.error("{}::{} is a reference not an attribute, aborting operation: removeIndexedAttribute", (Object)metamodelUri, (Object)typename);
                        listener.changeFailure();
                    } else if (metadata.length == 6) {
                        if ("t".equals(metadata[5])) {
                            metadata[5] = "f";
                            typenode.setProperty(attributename, (Object)metadata);
                            String indexname = String.valueOf(metamodelUri) + "##" + typename + "##" + attributename;
                            if (graph.nodeIndexExists(indexname)) {
                                graph.getOrCreateNodeIndex(indexname).delete();
                                found = true;
                            }
                            t.success();
                            listener.changeSuccess();
                        } else {
                            LOGGER.error("attribute was not indexed, nothing happened!");
                            listener.changeFailure();
                        }
                    } else {
                        LOGGER.error("error in removeIndexedAttribute (metadata.length!=6), nothing happened!");
                        listener.changeFailure();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while removing an indexed attribute", (Throwable)e);
            listener.changeFailure();
        }
        return found;
    }

    public static boolean removeDerivedAttribute(String metamodelUri, String typeName, String attributeName, IGraphDatabase graph, CompositeGraphChangeListener listener) {
        boolean found = false;
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (IGraphTransaction t = graph.beginTransaction();){
                listener.changeStart();
                IGraphIterable ep = graph.getMetamodelIndex().get("id", (Object)metamodelUri);
                IGraphNode packagenode = null;
                if (ep.size() != 1) {
                    throw new Exception("metamodel not found:" + metamodelUri);
                }
                packagenode = (IGraphNode)ep.getSingle();
                IGraphNode typenode = null;
                for (IGraphEdge e : packagenode.getIncomingWithType("epackage")) {
                    if (!e.getStartNode().getProperty("_hawkid").equals(typeName)) continue;
                    typenode = e.getStartNode();
                    break;
                }
                if (typenode == null) {
                    LOGGER.error("type: {} in: {} does not exist, aborting operation: removeDerivedAttribute", (Object)typeName, (Object)metamodelUri);
                    listener.changeFailure();
                } else {
                    String[] metadata = (String[])typenode.getProperty(attributeName);
                    if (metadata != null) {
                        if (metadata.length == 7 && metadata[0].equals("d")) {
                            LOGGER.info("derived attribute removed: {}::{}", (Object)metamodelUri, (Object)typeName);
                            IGraphNodeIndex derivedAccessDictionary = graph.getOrCreateNodeIndex("derivedaccessdictionary");
                            IGraphNodeIndex derivedProxyDictionary = graph.getOrCreateNodeIndex("derivedproxydictionary");
                            typenode.removeProperty(attributeName);
                            graph.getOrCreateNodeIndex(String.valueOf(metamodelUri) + "##" + typeName + "##" + attributeName).delete();
                            boolean noerror = true;
                            for (IGraphEdge e : typenode.getIncomingWithType("_hawkOfType")) {
                                boolean bl = noerror = noerror && GraphMetaModelResourceInjector.removeDerivedAttribute(derivedAccessDictionary, derivedProxyDictionary, attributeName, e);
                            }
                            for (IGraphEdge e : typenode.getIncomingWithType("_hawkOfKind")) {
                                boolean bl = noerror = noerror && GraphMetaModelResourceInjector.removeDerivedAttribute(derivedAccessDictionary, derivedProxyDictionary, attributeName, e);
                            }
                            if (noerror) {
                                found = true;
                            }
                            t.success();
                            listener.changeSuccess();
                        } else {
                            LOGGER.error("Error in removeDerivedAttribute, attribute metadata not valid");
                            listener.changeFailure();
                        }
                    } else {
                        LOGGER.error("Attribute was not already derived, nothing happened!");
                        listener.changeFailure();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e1) {
            LOGGER.error("Error in removing a derived attribute to the metamodel", (Throwable)e1);
            listener.changeFailure();
        }
        return found;
    }

    private static boolean removeDerivedAttribute(IGraphNodeIndex derivedAccessDictionary, IGraphNodeIndex derivedProxyDictionary, String attributeName, IGraphEdge instanceToTypeEdge) {
        boolean error = true;
        IGraphNode n = instanceToTypeEdge.getStartNode();
        IGraphEdge dae = null;
        for (IGraphEdge ed : n.getOutgoingWithType(attributeName)) {
            if (dae == null) {
                dae = ed;
                continue;
            }
            LOGGER.error("multiple edges found for derived attribute: {} in node {}", (Object)attributeName, (Object)n);
            dae = null;
            break;
        }
        if (dae == null) {
            LOGGER.error("derived attribute ({}) not found for node {}", (Object)attributeName, (Object)n);
        } else {
            IGraphNode dan = dae.getEndNode();
            dae.delete();
            derivedAccessDictionary.remove(dan);
            derivedProxyDictionary.remove(dan);
            dan.delete();
            error = false;
        }
        return !error;
    }

    public static class FailedMetamodelRegistrationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public FailedMetamodelRegistrationException(String metamodelURI, Throwable reason) {
            super(String.format("Failed to register metamodel '%s': %s", metamodelURI, reason.getMessage()), reason);
        }
    }

    public static class MissingMetamodelException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public MissingMetamodelException(String metamodelURI) {
            super(String.format("Missing metamodel with URI '%s'", metamodelURI));
        }
    }
}

