/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.localfolder;

import java.util.List;
import org.eclipse.hawk.core.IConsole;
import org.eclipse.hawk.core.ICredentialsStore;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.core.VcsCommitItem;

public abstract class FileBasedLocation
implements IVcsManager {
    protected static final String FIRST_REV = "0";
    protected IConsole console;
    protected String repositoryURL;
    protected long lastRevision;
    private boolean isFrozen = false;

    public String getLocation() {
        return this.repositoryURL;
    }

    public void setCredentials(String username, String password, ICredentialsStore credStore) {
    }

    protected String makeRelative(String base, String extension) {
        if (!extension.startsWith(base)) {
            return extension;
        }
        return extension.substring(base.length());
    }

    public boolean isAuthSupported() {
        return false;
    }

    public boolean isPathLocationAccepted() {
        return true;
    }

    public boolean isURLLocationAccepted() {
        return true;
    }

    public String getRepositoryPath(String rawPath) {
        String emfUriPrefix = this.getLocation().replaceFirst("file:///", "file:/");
        if (rawPath.startsWith(emfUriPrefix)) {
            return rawPath.substring(emfUriPrefix.length());
        }
        return rawPath;
    }

    public String getUsername() {
        return null;
    }

    public String getPassword() {
        return null;
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public void setFrozen(boolean f) {
        this.isFrozen = f;
    }

    public String getFirstRevision() throws Exception {
        return FIRST_REV;
    }

    public String getCurrentRevision() {
        return this.getCurrentRevision(false);
    }

    protected abstract String getCurrentRevision(boolean var1);

    public void run() {
    }

    public List<VcsCommitItem> getDelta(String startRevision) throws Exception {
        return this.getDelta(startRevision, "HEAD").getCompactedCommitItems();
    }
}

