/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.localfolder;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Date;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.core.VcsChangeType;
import org.eclipse.hawk.core.VcsCommit;
import org.eclipse.hawk.core.VcsCommitItem;
import org.eclipse.hawk.core.VcsRepositoryDelta;
import org.eclipse.hawk.localfolder.FileBasedLocation;

public class LocalFile
extends FileBasedLocation {
    private long initialVersion;
    private File monitoredFile;

    public void init(String vcsloc, IModelIndexer indexer) throws Exception {
        Path path;
        this.console = indexer.getConsole();
        try {
            path = Paths.get(new URI(vcsloc));
        }
        catch (IllegalArgumentException | URISyntaxException ex) {
            path = Paths.get(vcsloc, new String[0]);
        }
        this.monitoredFile = path.toFile().getCanonicalFile();
        this.initialVersion = this.monitoredFile.lastModified();
        String repositoryURI = path.toUri().toString();
        this.repositoryURL = this.monitoredFile.exists() ? repositoryURI : vcsloc;
    }

    @Override
    protected String getCurrentRevision(boolean alter) {
        long lastModified = this.monitoredFile.lastModified();
        if (alter) {
            this.lastRevision = lastModified;
        }
        return lastModified == this.initialVersion ? "0" : String.valueOf(lastModified);
    }

    public File importFile(String revision, String p, File temp) {
        return this.monitoredFile;
    }

    public boolean isActive() {
        return this.monitoredFile != null && this.monitoredFile.exists();
    }

    public void shutdown() {
        this.monitoredFile = null;
    }

    public String getHumanReadableName() {
        return "Local File Monitor";
    }

    public VcsRepositoryDelta getDelta(String startRevision, String endRevision) throws Exception {
        VcsCommit commit = new VcsCommit();
        VcsRepositoryDelta delta = new VcsRepositoryDelta(Collections.singleton(commit));
        delta.setManager((IVcsManager)this);
        commit.setAuthor("i am a local file driver - no authors recorded");
        commit.setJavaDate(new Date());
        commit.setMessage("i am a local file driver - no messages recorded");
        VcsCommitItem c = new VcsCommitItem();
        c.setCommit(commit);
        c.setPath("/" + this.monitoredFile.getName());
        long currentTimestamp = this.monitoredFile.lastModified();
        if (currentTimestamp != this.lastRevision) {
            if (currentTimestamp == this.initialVersion) {
                c.setChangeType(VcsChangeType.ADDED);
                commit.setRevision(String.valueOf(currentTimestamp));
                commit.getItems().add(c);
            } else {
                c.setChangeType(VcsChangeType.UPDATED);
                commit.setRevision(String.valueOf(currentTimestamp));
                commit.getItems().add(c);
            }
        }
        this.getCurrentRevision(true);
        return delta;
    }

    public String getDefaultLocation() {
        return "file://path/to/file";
    }
}

