/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class File
implements TBase<File, _Fields>,
Serializable,
Cloneable,
Comparable<File> {
    private static final TStruct STRUCT_DESC = new TStruct("File");
    private static final TField NAME_FIELD_DESC = new TField("name", 11, 1);
    private static final TField CONTENTS_FIELD_DESC = new TField("contents", 11, 2);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public String name;
    public ByteBuffer contents;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    static {
        schemes.put(StandardScheme.class, new FileStandardSchemeFactory());
        schemes.put(TupleScheme.class, new FileTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.NAME, new FieldMetaData("name", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.CONTENTS, new FieldMetaData("contents", 1, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(File.class, metaDataMap);
    }

    public File() {
    }

    public File(String name, ByteBuffer contents) {
        this();
        this.name = name;
        this.contents = TBaseHelper.copyBinary((ByteBuffer)contents);
    }

    public File(File other) {
        if (other.isSetName()) {
            this.name = other.name;
        }
        if (other.isSetContents()) {
            this.contents = TBaseHelper.copyBinary((ByteBuffer)other.contents);
        }
    }

    public File deepCopy() {
        return new File(this);
    }

    public void clear() {
        this.name = null;
        this.contents = null;
    }

    public String getName() {
        return this.name;
    }

    public File setName(String name) {
        this.name = name;
        return this;
    }

    public void unsetName() {
        this.name = null;
    }

    public boolean isSetName() {
        return this.name != null;
    }

    public void setNameIsSet(boolean value) {
        if (!value) {
            this.name = null;
        }
    }

    public byte[] getContents() {
        this.setContents(TBaseHelper.rightSize((ByteBuffer)this.contents));
        return this.contents == null ? null : this.contents.array();
    }

    public ByteBuffer bufferForContents() {
        return TBaseHelper.copyBinary((ByteBuffer)this.contents);
    }

    public File setContents(byte[] contents) {
        this.contents = contents == null ? null : ByteBuffer.wrap(Arrays.copyOf(contents, contents.length));
        return this;
    }

    public File setContents(ByteBuffer contents) {
        this.contents = TBaseHelper.copyBinary((ByteBuffer)contents);
        return this;
    }

    public void unsetContents() {
        this.contents = null;
    }

    public boolean isSetContents() {
        return this.contents != null;
    }

    public void setContentsIsSet(boolean value) {
        if (!value) {
            this.contents = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case NAME: {
                if (value == null) {
                    this.unsetName();
                    break;
                }
                this.setName((String)value);
                break;
            }
            case CONTENTS: {
                if (value == null) {
                    this.unsetContents();
                    break;
                }
                this.setContents((ByteBuffer)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case NAME: {
                return this.getName();
            }
            case CONTENTS: {
                return this.getContents();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case NAME: {
                return this.isSetName();
            }
            case CONTENTS: {
                return this.isSetContents();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof File) {
            return this.equals((File)that);
        }
        return false;
    }

    public boolean equals(File that) {
        boolean that_present_contents;
        boolean that_present_name;
        if (that == null) {
            return false;
        }
        boolean this_present_name = this.isSetName();
        boolean bl = that_present_name = that.isSetName();
        if (this_present_name || that_present_name) {
            if (!this_present_name || !that_present_name) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
        }
        boolean this_present_contents = this.isSetContents();
        boolean bl2 = that_present_contents = that.isSetContents();
        if (this_present_contents || that_present_contents) {
            if (!this_present_contents || !that_present_contents) {
                return false;
            }
            if (!this.contents.equals(that.contents)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_name = this.isSetName();
        list.add(present_name);
        if (present_name) {
            list.add(this.name);
        }
        boolean present_contents = this.isSetContents();
        list.add(present_contents);
        if (present_contents) {
            list.add(this.contents);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(File other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetName()).compareTo(other.isSetName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetName() && (lastComparison = TBaseHelper.compareTo((String)this.name, (String)other.name)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetContents()).compareTo(other.isSetContents());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetContents() && (lastComparison = TBaseHelper.compareTo((Comparable)this.contents, (Comparable)other.contents)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("File(");
        boolean first = true;
        sb.append("name:");
        if (this.name == null) {
            sb.append("null");
        } else {
            sb.append(this.name);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("contents:");
        if (this.contents == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.contents, (StringBuilder)sb);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.name == null) {
            throw new TProtocolException("Required field 'name' was not present! Struct: " + this.toString());
        }
        if (this.contents == null) {
            throw new TProtocolException("Required field 'contents' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static class FileStandardScheme
    extends StandardScheme<File> {
        private FileStandardScheme() {
        }

        public void read(TProtocol iprot, File struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.name = iprot.readString();
                            struct.setNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.contents = iprot.readBinary();
                            struct.setContentsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, File struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.name != null) {
                oprot.writeFieldBegin(NAME_FIELD_DESC);
                oprot.writeString(struct.name);
                oprot.writeFieldEnd();
            }
            if (struct.contents != null) {
                oprot.writeFieldBegin(CONTENTS_FIELD_DESC);
                oprot.writeBinary(struct.contents);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class FileStandardSchemeFactory
    implements SchemeFactory {
        private FileStandardSchemeFactory() {
        }

        public FileStandardScheme getScheme() {
            return new FileStandardScheme();
        }
    }

    private static class FileTupleScheme
    extends TupleScheme<File> {
        private FileTupleScheme() {
        }

        public void write(TProtocol prot, File struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeString(struct.name);
            oprot.writeBinary(struct.contents);
        }

        public void read(TProtocol prot, File struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.name = iprot.readString();
            struct.setNameIsSet(true);
            struct.contents = iprot.readBinary();
            struct.setContentsIsSet(true);
        }
    }

    private static class FileTupleSchemeFactory
    implements SchemeFactory {
        private FileTupleSchemeFactory() {
        }

        public FileTupleScheme getScheme() {
            return new FileTupleScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        NAME(1, "name"),
        CONTENTS(2, "contents");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return NAME;
                }
                case 2: {
                    return CONTENTS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }
}

