/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.server.users.cli;

import java.io.Console;
import java.net.ConnectException;
import org.apache.thrift.TException;
import org.eclipse.hawk.service.api.UserNotFound;
import org.eclipse.hawk.service.api.UserProfile;
import org.eclipse.hawk.service.api.Users;
import org.eclipse.hawk.service.api.utils.APIUtils;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;

public class UsersCommandProvider
implements CommandProvider {
    private Users.Client client;

    public Object _usersHelp(CommandInterpreter intp) {
        return this.getHelp();
    }

    public Object _usersConnect(CommandInterpreter intp) throws Exception {
        String url = this.requiredArgument(intp, "url");
        String username = intp.nextArgument();
        String password = intp.nextArgument();
        if (username != null && password == null) {
            Console console = System.console();
            if (console == null) {
                throw new Exception("No console: cannot read password safely");
            }
            console.writer().print("Password: ");
            password = String.valueOf(console.readPassword());
        }
        this.client = (Users.Client)APIUtils.connectTo(Users.Client.class, (String)url, (APIUtils.ThriftProtocol)APIUtils.ThriftProtocol.JSON, (String)username, (String)password);
        return null;
    }

    public Object _usersDisconnect(CommandInterpreter intp) throws Exception {
        if (this.client != null) {
            this.client.getInputProtocol().getTransport().close();
            this.client = null;
            return "Connection closed";
        }
        return "Connection already closed";
    }

    public Object _usersAdd(CommandInterpreter intp) throws Exception {
        this.checkConnected();
        String username = this.requiredArgument(intp, "username");
        String realName = this.requiredArgument(intp, "realname");
        boolean isAdmin = Boolean.valueOf(this.requiredArgument(intp, "isAdmin"));
        String password = intp.nextArgument();
        if (password == null) {
            Console console = System.console();
            if (console == null) {
                throw new Exception("No console: cannot read password safely");
            }
            while (true) {
                console.writer().print("Password for new user: ");
                password = String.valueOf(console.readPassword());
                console.writer().print("Repeat password for new user: ");
                String repeat = String.valueOf(console.readPassword());
                if (password.equals(repeat)) break;
                console.writer().println("Passwords do not match.");
            }
        }
        UserProfile profile = new UserProfile();
        profile.setAdmin(isAdmin);
        profile.setRealName(realName);
        this.client.createUser(username, password, profile);
        return "Created user account " + username;
    }

    public Object _usersUpdateProfile(CommandInterpreter intp) throws UserNotFound, TException, ConnectException {
        this.checkConnected();
        String username = this.requiredArgument(intp, "username");
        String realName = this.requiredArgument(intp, "realname");
        boolean isAdmin = Boolean.valueOf(this.requiredArgument(intp, "isAdmin"));
        UserProfile profile = new UserProfile();
        profile.setAdmin(isAdmin);
        profile.setRealName(realName);
        this.client.updateProfile(username, profile);
        return "Updated profile for user account " + username;
    }

    public Object _usersUpdatePassword(CommandInterpreter intp) throws Exception {
        this.checkConnected();
        String username = this.requiredArgument(intp, "username");
        String password = intp.nextArgument();
        if (password == null) {
            Console console = System.console();
            if (console == null) {
                throw new Exception("No console: cannot read password safely");
            }
            console.writer().print("Password: ");
            password = String.valueOf(console.readPassword());
        }
        this.client.updatePassword(username, password);
        return "Updated password for user account " + username;
    }

    public Object _usersRemove(CommandInterpreter intp) throws UserNotFound, TException, ConnectException {
        this.checkConnected();
        String username = this.requiredArgument(intp, "username");
        this.client.deleteUser(username);
        return "Removed user account " + username;
    }

    public String getHelp() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("---User management (commands are case insensitive)---\n\t");
        sbuf.append("usersHelp - lists all the available commands for Users\n");
        sbuf.append("--Connections--\n\t");
        sbuf.append("usersConnect <url> [username] [password] - connects to a Thrift endpoint\n\t");
        sbuf.append("usersDisconnect - disconnects from the current Thrift endpoint\n");
        sbuf.append("--Commands--\n\t");
        sbuf.append("usersAdd <username> <realname> <isAdmin: true|false> [password] - adds the user to the database\n\t");
        sbuf.append("usersUpdateProfile <username> <realname> <isAdmin: true|false> - changes the personal information of a user\n\t");
        sbuf.append("usersUpdatePassword <username> [password] - changes the password of a user\n\t");
        sbuf.append("usersRemove <username> - removes a user\n\t");
        sbuf.append("usersCheck <username> [password] - validates credentials\n");
        return sbuf.toString();
    }

    private void checkConnected() throws ConnectException {
        if (this.client == null) {
            throw new ConnectException("Please connect to a Thrift endpoint first!");
        }
    }

    private String requiredArgument(CommandInterpreter intp, String argumentName) {
        String value = intp.nextArgument();
        if (value == null) {
            throw new IllegalArgumentException(String.format("Required argument '%s' has not been provided", argumentName));
        }
        return value;
    }
}

