/*******************************************************************************
 * Copyright (c) 2011-2015 The University of York.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 3.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-3.0
 *
 * Contributors:
 *     Konstantinos Barmpis - initial API and implementation
 ******************************************************************************/
package org.eclipse.hawk.bpmn;

import java.util.HashSet;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.hawk.core.model.*;

public class BPMNAttribute extends BPMNObject implements IHawkAttribute {

	private EAttribute emfattribute;

	public BPMNAttribute(EAttribute att) {
		super(att);
		emfattribute = att;
	}

	// public EAttribute getEmfattribute() {
	// return emfattribute;
	// }

	public boolean isDerived() {
		return emfattribute.isDerived();
	}

	public String getName() {
		return emfattribute.getName();
	}

	public HashSet<IHawkAnnotation> getAnnotations() {

		HashSet<IHawkAnnotation> ann = new HashSet<IHawkAnnotation>();

		for (EAnnotation e : emfattribute.getEAnnotations()) {

			IHawkAnnotation a = new BPMNAnnotation(e);

			ann.add(a);

		}

		return ann;

	}

	// @Override
	// public EStructuralFeature getEMFattribute() {
	//
	// return emfattribute;
	// }

	@Override
	public boolean isMany() {
		return emfattribute.isMany();
	}

	@Override
	public boolean isUnique() {
		return emfattribute.isUnique();
	}

	@Override
	public boolean isOrdered() {
		return emfattribute.isOrdered();
	}

	@Override
	public IHawkClassifier getType() {
		EClassifier type = emfattribute.getEType();
		if (type instanceof EClass)
			return new BPMNClass((EClass) emfattribute.getEType());
		else if (type instanceof EDataType)
			return new BPMNDataType((EDataType) emfattribute.getEType());
		else {
			// System.err.println("attr: "+emfattribute.getEType());
			return null;
		}
	}

	@Override
	public int hashCode() {
		return emfattribute.hashCode();

	}

	public EAttribute getEObject() {
		return null;
	}
	
}
