/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.bpmn;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.hawk.bpmn.BPMNAttribute;
import org.eclipse.hawk.bpmn.BPMNFeatureMapReference;
import org.eclipse.hawk.bpmn.BPMNObject;
import org.eclipse.hawk.bpmn.BPMNReference;
import org.eclipse.hawk.core.model.IHawkAttribute;
import org.eclipse.hawk.core.model.IHawkClass;
import org.eclipse.hawk.core.model.IHawkReference;
import org.eclipse.hawk.core.model.IHawkStructuralFeature;

public class BPMNClass
extends BPMNObject
implements IHawkClass {
    private EClass eclass;

    public BPMNClass(EClass o) {
        super((EObject)o);
        this.eclass = o;
    }

    @Override
    public EObject getEObject() {
        return this.eclass;
    }

    public String getName() {
        return this.eclass.getName();
    }

    public String getInstanceType() {
        String it = this.eclass.getInstanceClassName();
        switch (it = it == null ? "NULL_INSTANCE_TYPE" : it) {
            case "long": {
                return Long.class.getName();
            }
            case "int": {
                return Integer.class.getName();
            }
            case "float": {
                return Float.class.getName();
            }
            case "double": {
                return Double.class.getName();
            }
            case "boolean": {
                return Boolean.class.getName();
            }
        }
        return it;
    }

    public String getPackageNSURI() {
        EPackage ep = this.eclass.getEPackage();
        if (this.eclass.eIsProxy()) {
            System.err.println("WARNING -- proxy class: " + this.eclass.toString());
        }
        return ep == null ? "NULL_EPACKAGE" : ep.getNsURI();
    }

    public Set<IHawkAttribute> getAllAttributes() {
        HashSet<IHawkAttribute> atts = new HashSet<IHawkAttribute>();
        for (EAttribute att : this.eclass.getEAllAttributes()) {
            atts.add(new BPMNAttribute(att));
        }
        return atts;
    }

    public Set<IHawkClass> getAllSuperTypes() {
        HashSet<IHawkClass> c = new HashSet<IHawkClass>();
        for (EClass e : this.eclass.getEAllSuperTypes()) {
            c.add(new BPMNClass(e));
        }
        return c;
    }

    public Set<IHawkClass> getSuperTypes() {
        return this.getAllSuperTypes();
    }

    public Set<IHawkReference> getAllReferences() {
        HashSet<IHawkReference> c = new HashSet<IHawkReference>();
        for (EReference e : this.eclass.getEAllReferences()) {
            c.add(new BPMNReference(e));
        }
        for (EAttribute att : this.eclass.getEAllAttributes()) {
            if (att.getEType().getInstanceClass() != FeatureMap.Entry.class) continue;
            c.add(new BPMNFeatureMapReference(att));
        }
        return c;
    }

    public boolean isAbstract() {
        return this.eclass.isAbstract();
    }

    public boolean isInterface() {
        return this.eclass.isInterface();
    }

    public IHawkStructuralFeature getStructuralFeature(String name) {
        EStructuralFeature esf = this.eclass.getEStructuralFeature(name);
        if (esf instanceof EAttribute) {
            if (esf.getEType().getInstanceClass() == FeatureMap.Entry.class) {
                return new BPMNFeatureMapReference((EAttribute)esf);
            }
            return new BPMNAttribute((EAttribute)esf);
        }
        if (esf instanceof EReference) {
            return new BPMNReference((EReference)esf);
        }
        System.err.println("getEStructuralFeature( " + name + " ) is not an attribute or a reference, debug:");
        return null;
    }

    @Override
    public int hashCode() {
        return this.eclass.hashCode();
    }
}

