/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.bpmn;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.hawk.bpmn.BPMNClass;
import org.eclipse.hawk.core.model.IHawkAttribute;
import org.eclipse.hawk.core.model.IHawkClass;
import org.eclipse.hawk.core.model.IHawkClassifier;
import org.eclipse.hawk.core.model.IHawkDataType;
import org.eclipse.hawk.core.model.IHawkObject;
import org.eclipse.hawk.core.model.IHawkReference;
import org.eclipse.hawk.core.model.IHawkStructuralFeature;

public class BPMNObject
implements IHawkObject {
    protected EObject eob;
    private byte[] signature;

    public BPMNObject(EObject o) {
        this.eob = o;
    }

    public EObject getEObject() {
        return this.eob;
    }

    public boolean isInDifferentResourceThan(IHawkObject o) {
        if (o instanceof BPMNObject) {
            BPMNObject otherR = (BPMNObject)o;
            return this.eob.eIsProxy() || otherR.eob.eResource() != this.eob.eResource();
        }
        return false;
    }

    public String getUri() {
        return EcoreUtil.getURI((EObject)this.eob).toString();
    }

    public String getUriFragment() {
        URI uri = null;
        try {
            uri = EcoreUtil.getURI((EObject)this.eob);
            String frag = uri.fragment();
            return frag;
        }
        catch (Exception e) {
            System.err.println(this.eob);
            System.err.println(this.eob.eResource());
            System.err.println(this.eob.eClass());
            System.err.println("Error in finding URI: " + uri + ", returning null");
            return null;
        }
    }

    public boolean isFragmentUnique() {
        return false;
    }

    public IHawkClassifier getType() {
        return new BPMNClass(this.eob.eClass());
    }

    public boolean isSet(IHawkStructuralFeature hsf) {
        EStructuralFeature sf = this.eob.eClass().getEStructuralFeature(hsf.getName());
        return this.eob.eIsSet(sf) || sf.getDefaultValue() != null;
    }

    public Object get(IHawkAttribute attribute) {
        Object ret = this.eob.eGet(this.eob.eClass().getEStructuralFeature(attribute.getName()));
        if (ret instanceof FeatureMap) {
            LinkedList<Object> subset = new LinkedList<Object>();
            FeatureMap.ValueListIterator it = ((FeatureMap)ret).valueListIterator();
            while (it.hasNext()) {
                Object next = it.next();
                if (next instanceof EObject) continue;
                subset.add(next);
            }
            return subset;
        }
        return ret;
    }

    public Object get(IHawkReference reference, boolean resolve) {
        Object ret;
        Object source = this.eob.eGet(this.eob.eClass().getEStructuralFeature(reference.getName()), resolve);
        if (source instanceof Iterable) {
            ret = new LinkedList();
            if (source instanceof FeatureMap) {
                FeatureMap.ValueListIterator it = ((FeatureMap)source).valueListIterator();
                while (it.hasNext()) {
                    Object next = it.next();
                    if (!(next instanceof EObject)) continue;
                    ((LinkedList)ret).add(new BPMNObject((EObject)next));
                }
            } else {
                for (EObject e : (Iterable)source) {
                    ((LinkedList)ret).add(new BPMNObject(e));
                }
            }
        } else {
            ret = new BPMNObject((EObject)source);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (o instanceof BPMNObject) {
            return this.eob.equals(((BPMNObject)o).getEObject());
        }
        return false;
    }

    public int hashCode() {
        return this.eob.hashCode();
    }

    public byte[] signature() {
        if (this.signature == null) {
            if (this.eob.eIsProxy()) {
                System.err.println("signature called on proxy object returning null");
                return null;
            }
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                System.err.println("signature() tried to create a SHA-1 digest but a NoSuchAlgorithmException was thrown, returning null");
                return null;
            }
            md.update(this.getUri().getBytes());
            md.update(this.getUriFragment().getBytes());
            IHawkClassifier type = this.getType();
            md.update(type.getName().getBytes());
            md.update(type.getPackageNSURI().getBytes());
            if (!(type instanceof IHawkDataType)) {
                if (type instanceof IHawkClass) {
                    for (IHawkAttribute eAttribute : ((IHawkClass)type).getAllAttributes()) {
                        if (!eAttribute.isDerived() && !this.isSet((IHawkStructuralFeature)eAttribute)) continue;
                        md.update(eAttribute.getName().getBytes());
                        if (eAttribute.isDerived()) continue;
                        md.update(this.get(eAttribute).toString().getBytes());
                    }
                    for (IHawkReference eRef : ((IHawkClass)type).getAllReferences()) {
                        if (!this.isSet((IHawkStructuralFeature)eRef)) continue;
                        md.update(eRef.getName().getBytes());
                        Object destinationObjects = this.get(eRef, false);
                        if (destinationObjects instanceof Iterable) {
                            for (IHawkObject o : (Iterable)destinationObjects) {
                                md.update(o.getUriFragment().getBytes());
                            }
                            continue;
                        }
                        md.update(((IHawkObject)destinationObjects).getUriFragment().getBytes());
                    }
                } else {
                    System.err.println("warning emf object tried to create signature, but found type: " + type);
                }
            }
            this.signature = md.digest();
        }
        return this.signature;
    }

    public String toString() {
        String ret = "";
        ret = String.valueOf(ret) + "> " + this.eob + " :::with attributes::: ";
        for (EAttribute e : this.eob.eClass().getEAllAttributes()) {
            ret = String.valueOf(ret) + e + " : " + this.eob.eGet((EStructuralFeature)e);
        }
        ret = String.valueOf(ret);
        return ret;
    }

    public boolean isRoot() {
        return this.eob.eContainer() == null;
    }

    public boolean URIIsRelative() {
        return EcoreUtil.getURI((EObject)this.eob).isRelative();
    }
}

