/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.bpmn.metamodel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.di.BpmnDiPackage;
import org.eclipse.dd.dc.DcPackage;
import org.eclipse.dd.di.DiPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EcorePackageImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xml.type.impl.XMLTypePackageImpl;
import org.eclipse.hawk.bpmn.BPMNPackage;
import org.eclipse.hawk.bpmn.metamodel.BPMNMetaModelResource;
import org.eclipse.hawk.bpmn.model.util.RegisterMeta;
import org.eclipse.hawk.core.IMetaModelResourceFactory;
import org.eclipse.hawk.core.model.IHawkMetaModelResource;
import org.eclipse.hawk.core.model.IHawkPackage;

public class BPMNMetaModelResourceFactory
implements IMetaModelResourceFactory {
    private static final String TYPE = "org.eclipse.hawk.emf.metamodel.BPMNMetaModelParser";
    private static final String HUMAN_READABLE_NAME = "BPMN Metamodel Resource Factory";
    ResourceSet resourceSet;

    public BPMNMetaModelResourceFactory() {
        if (EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/emf/2002/Ecore") == null) {
            EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
        }
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
    }

    public final String getType() {
        return TYPE;
    }

    public String getHumanReadableName() {
        return HUMAN_READABLE_NAME;
    }

    public void shutdown() {
    }

    public IHawkMetaModelResource parse(File f) throws Exception {
        Resource r = this.resourceSet.createResource(URI.createFileURI((String)f.getAbsolutePath()));
        r.load(null);
        RegisterMeta.registerPackages(r);
        BPMNMetaModelResource ret = new BPMNMetaModelResource(r, this);
        return ret;
    }

    public Set<String> getMetaModelExtensions() {
        return Collections.emptySet();
    }

    public IHawkMetaModelResource parseFromString(String name, String contents) throws Exception {
        if (name != null && contents != null) {
            Resource r = this.resourceSet.createResource(URI.createURI((String)name));
            ByteArrayInputStream input = new ByteArrayInputStream(contents.getBytes("UTF-8"));
            r.load((InputStream)input, null);
            RegisterMeta.registerPackages(r);
            return new BPMNMetaModelResource(r, this);
        }
        return null;
    }

    public Optional<String> dumpPackageToString(IHawkPackage pkg) throws Exception {
        BPMNPackage ePackage = (BPMNPackage)pkg;
        Resource newResource = this.resourceSet.createResource(URI.createURI((String)("resource_from_epackage_" + ePackage.getNsURI())));
        EObject eob = ePackage.getEObject();
        newResource.getContents().add((Object)EcoreUtil.copy((EObject)eob));
        ByteArrayOutputStream bOS = new ByteArrayOutputStream();
        newResource.save((OutputStream)bOS, null);
        String contents = new String(bOS.toByteArray());
        return Optional.of(contents);
    }

    public boolean canParse(File f) {
        String[] split = f.getPath().split("\\.");
        String extension = split[split.length - 1];
        return this.getMetaModelExtensions().contains(extension);
    }

    public HashSet<IHawkMetaModelResource> getStaticMetamodels() {
        HashSet<IHawkMetaModelResource> set = new HashSet<IHawkMetaModelResource>();
        LinkedList<String> missingPackages = this.checkRegistry();
        EPackage.Registry globalRegistry = EPackage.Registry.INSTANCE;
        if (missingPackages.size() > 0) {
            RegisterMeta.registerPackages((EPackage)EcorePackageImpl.eINSTANCE);
            RegisterMeta.registerPackages((EPackage)XMLTypePackageImpl.eINSTANCE);
            RegisterMeta.registerPackages((EPackage)Bpmn2Package.eINSTANCE);
            RegisterMeta.registerPackages((EPackage)BpmnDiPackage.eINSTANCE);
            RegisterMeta.registerPackages((EPackage)DiPackage.eINSTANCE);
            RegisterMeta.registerPackages((EPackage)DcPackage.eINSTANCE);
            missingPackages = this.checkRegistry();
        }
        if (missingPackages.size() == 0) {
            set.add(new BPMNMetaModelResource(globalRegistry.getEPackage("http://www.eclipse.org/emf/2003/XMLType").eResource(), this));
            set.add(new BPMNMetaModelResource(globalRegistry.getEPackage("http://www.omg.org/spec/BPMN/20100524/MODEL-XMI").eResource(), this));
            set.add(new BPMNMetaModelResource(globalRegistry.getEPackage("http://www.omg.org/spec/DD/20100524/DC-XMI").eResource(), this));
            set.add(new BPMNMetaModelResource(globalRegistry.getEPackage("http://www.eclipse.org/emf/2002/Ecore").eResource(), this));
            set.add(new BPMNMetaModelResource(globalRegistry.getEPackage("http://www.omg.org/spec/BPMN/20100524/DI-XMI").eResource(), this));
            set.add(new BPMNMetaModelResource(globalRegistry.getEPackage("http://www.omg.org/spec/DD/20100524/DI-XMI").eResource(), this));
        } else {
            System.err.println("WARNING: one or more of the static metamodels of BPMN were not found, no static metamodels inserted for this plugin, please insert the relevant metamodels manually:\n" + missingPackages.toString());
        }
        return set;
    }

    private LinkedList<String> checkRegistry() {
        EPackage.Registry globalRegistry = EPackage.Registry.INSTANCE;
        LinkedList<String> missingPackages = new LinkedList<String>();
        if (!globalRegistry.containsKey((Object)"http://www.eclipse.org/emf/2003/XMLType")) {
            missingPackages.add("http://www.eclipse.org/emf/2003/XMLType");
        }
        if (!globalRegistry.containsKey((Object)"http://www.omg.org/spec/BPMN/20100524/MODEL-XMI")) {
            missingPackages.add("http://www.omg.org/spec/BPMN/20100524/MODEL-XMI");
        }
        if (!globalRegistry.containsKey((Object)"http://www.omg.org/spec/DD/20100524/DC-XMI")) {
            missingPackages.add("http://www.omg.org/spec/DD/20100524/DC-XMI");
        }
        if (!globalRegistry.containsKey((Object)"http://www.eclipse.org/emf/2002/Ecore")) {
            missingPackages.add("http://www.eclipse.org/emf/2002/Ecore");
        }
        if (!globalRegistry.containsKey((Object)"http://www.omg.org/spec/BPMN/20100524/DI-XMI")) {
            missingPackages.add("http://www.omg.org/spec/BPMN/20100524/DI-XMI");
        }
        if (!globalRegistry.containsKey((Object)"http://www.omg.org/spec/DD/20100524/DI-XMI")) {
            missingPackages.add("http://www.omg.org/spec/DD/20100524/DI-XMI");
        }
        return missingPackages;
    }
}

