/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.bpmn.model;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.bpmn2.util.Bpmn2ResourceFactoryImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hawk.bpmn.model.BPMNModelResource;
import org.eclipse.hawk.core.IFileImporter;
import org.eclipse.hawk.core.IModelResourceFactory;
import org.eclipse.hawk.core.model.IHawkModelResource;

public class BPMNModelResourceFactory
implements IModelResourceFactory {
    private static final String TYPE = "org.eclipse.hawk.emf.metamodel.BPMNModelParser";
    private static final String HUMAN_READABLE_NAME = "BPMN Model Resource Factory";
    Set<String> modelExtensions = new HashSet<String>();

    public BPMNModelResourceFactory() {
        this.modelExtensions.add(".bpmn");
        this.modelExtensions.add(".bpmn2");
    }

    public final String getType() {
        return TYPE;
    }

    public String getHumanReadableName() {
        return HUMAN_READABLE_NAME;
    }

    public IHawkModelResource parse(IFileImporter importer, File f) {
        BPMNModelResource ret;
        Resource r = null;
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("bpmn", new Bpmn2ResourceFactoryImpl());
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("bpmn2", new Bpmn2ResourceFactoryImpl());
            r = resourceSet.createResource(URI.createFileURI((String)f.getPath()));
            r.load(null);
            ret = new BPMNModelResource(r, this);
        }
        catch (Exception e) {
            System.err.print("error in parse(File f): ");
            System.err.println(e.getCause());
            ret = null;
        }
        return ret;
    }

    public void shutdown() {
    }

    public Set<String> getModelExtensions() {
        return this.modelExtensions;
    }

    public boolean canParse(File f) {
        String[] split = f.getPath().split("\\.");
        String extension = split[split.length - 1];
        return this.getModelExtensions().contains("." + extension);
    }
}

