/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.epsilon.emc;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.eol.EolModule;
import org.eclipse.epsilon.eol.IEolModule;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.EolUndefinedVariableException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotInstantiableModelElementTypeException;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.execute.control.DefaultExecutionController;
import org.eclipse.epsilon.eol.execute.control.ExecutionController;
import org.eclipse.epsilon.eol.execute.introspection.IPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.IPropertySetter;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.types.EolAnyType;
import org.eclipse.epsilon.eol.types.EolSequence;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.IStateListener;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeIndex;
import org.eclipse.hawk.core.graph.IGraphNodeReference;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNodeIndex;
import org.eclipse.hawk.core.query.IQueryEngine;
import org.eclipse.hawk.core.query.InvalidQueryException;
import org.eclipse.hawk.core.query.QueryExecutionException;
import org.eclipse.hawk.core.util.Utils;
import org.eclipse.hawk.epsilon.emc.AbstractHawkModel;
import org.eclipse.hawk.epsilon.emc.DeriveFeature;
import org.eclipse.hawk.epsilon.emc.contextful.CEOLQueryEngine;
import org.eclipse.hawk.epsilon.emc.optimisation.OptimisableCollection;
import org.eclipse.hawk.epsilon.emc.pgetters.GraphPropertyGetter;
import org.eclipse.hawk.epsilon.emc.tracking.AccessListener;
import org.eclipse.hawk.epsilon.emc.wrappers.FileNodeWrapper;
import org.eclipse.hawk.epsilon.emc.wrappers.MetamodelNodeWrapper;
import org.eclipse.hawk.epsilon.emc.wrappers.TypeNodeWrapper;
import org.eclipse.hawk.graph.FileNode;
import org.eclipse.hawk.graph.GraphWrapper;
import org.eclipse.hawk.graph.MetamodelNode;
import org.eclipse.hawk.graph.ModelElementNode;
import org.eclipse.hawk.graph.ProxyReferenceList;
import org.eclipse.hawk.graph.TypeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EOLQueryEngine
extends AbstractHawkModel
implements IQueryEngine {
    public static final String TYPE = "org.eclipse.hawk.epsilon.emc.EOLQueryEngine";
    private static final Logger LOGGER = LoggerFactory.getLogger(EOLQueryEngine.class);
    private static final String MMURI_TYPE_SEPARATOR = "::";
    private static final String ANY_TYPE = new EolAnyType().getName();
    protected IModelIndexer indexer = null;
    protected IGraphDatabase graph = null;
    protected IGraphNodeIndex metamodeldictionary;
    protected Set<String> defaultNamespaces = null;
    protected GraphPropertyGetter propertyGetter;
    private Map<String, List<IGraphNode>> typeNodesCache = new WeakHashMap<String, List<IGraphNode>>();
    private boolean useOptimisableCollection;

    public Collection<?> allContents() {
        IGraphIterable iterableNodes = this.graph.allNodes("eobject");
        IGraphIterableCollection allContents = new IGraphIterableCollection((IGraphIterable<? extends IGraphNode>)iterableNodes);
        this.broadcastAllOfXAccess(allContents);
        return allContents;
    }

    public Object createInstance(String metaClassName) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        throw new EolNotInstantiableModelElementTypeException("Hawk Model Index", metaClassName);
    }

    public void deleteElement(Object arg0) throws EolRuntimeException {
        throw new EolRuntimeException("Hawk Model Index: this type of model cannot create/delete elements");
    }

    @Override
    public Collection<Object> getAllOf(String typeName, String typeorkind) throws EolModelElementTypeNotFoundException, EolInternalException {
        try {
            List<IGraphNode> typeNodes = this.getTypeNodes(typeName);
            if (typeNodes.size() == 1) {
                return this.getAllOf(typeNodes.get(0), typeorkind);
            }
        }
        catch (Exception e) {
            throw new EolInternalException((Throwable)e);
        }
        throw new EolModelElementTypeNotFoundException(this.getName(), typeName);
    }

    public Collection<GraphNodeWrapper> getAllOf(String metamodelURI, String typeName, String filePatterns) throws EolInternalException, EolModelElementTypeNotFoundException {
        return this.getAllOf(metamodelURI, typeName, "*", filePatterns);
    }

    public Collection<GraphNodeWrapper> getAllOf(String metamodelURI, String typeName, String repoPattern, String filePatterns) throws EolInternalException, EolModelElementTypeNotFoundException {
        try {
            List<IGraphNode> typeNodes = this.getTypeNodes(metamodelURI, typeName);
            if (typeNodes.size() == 1) {
                TypeNode targetTypeNode = new TypeNode(typeNodes.get(0));
                ArrayList<GraphNodeWrapper> results = new ArrayList<GraphNodeWrapper>();
                Set fileNodes = new GraphWrapper(this.graph).getFileNodes(Collections.singleton(repoPattern), Arrays.asList(filePatterns.split(",")));
                for (FileNode fn : fileNodes) {
                    for (ModelElementNode me : fn.getModelElements()) {
                        if (!me.isOfKind(targetTypeNode)) continue;
                        results.add(this.wrap(me.getNode()));
                    }
                }
                return results;
            }
        }
        catch (Exception e) {
            throw new EolInternalException((Throwable)e);
        }
        throw new EolModelElementTypeNotFoundException(this.getName(), typeName);
    }

    public Collection<Object> getAllOf(IGraphNode typeNode, String typeorkind) {
        Collection<Object> nodes = this.createAllOfCollection(typeNode);
        for (IGraphEdge n : typeNode.getIncomingWithType(typeorkind)) {
            nodes.add(this.wrap(n.getStartNode()));
        }
        this.broadcastAllOfXAccess(nodes);
        return nodes;
    }

    protected Collection<Object> createAllOfCollection(IGraphNode typeNode) {
        OptimisableCollection nodes = this.useOptimisableCollection ? new OptimisableCollection((IModel)this, this.wrap(typeNode)) : new EolSequence();
        return nodes;
    }

    public List<IGraphNode> getTypeNodes(String typeName) {
        List<IGraphNode> typeNodes = this.typeNodesCache.get(typeName);
        if (typeNodes == null) {
            typeNodes = this.computeTypeNodes(typeName);
            this.typeNodesCache.put(typeName, typeNodes);
        }
        return typeNodes;
    }

    protected List<IGraphNode> computeTypeNodes(String typeName) {
        int idxColon = typeName.lastIndexOf(MMURI_TYPE_SEPARATOR);
        if (idxColon != -1) {
            String epackage = typeName.substring(0, idxColon);
            String type = typeName.substring(idxColon + MMURI_TYPE_SEPARATOR.length());
            return this.getTypeNodes(epackage, type);
        }
        IGraphIterable allMetamodels = this.metamodeldictionary.query("id", (Object)"*");
        LinkedList<IGraphNode> candidates = new LinkedList<IGraphNode>();
        for (IGraphNode pack : allMetamodels) {
            for (IGraphEdge n : pack.getIncomingWithType("epackage")) {
                IGraphNode othernode = n.getStartNode();
                Object id = othernode.getProperty("_hawkid");
                if (!id.equals(typeName)) continue;
                candidates.add(othernode);
            }
        }
        if (candidates.size() == 1) {
            return candidates;
        }
        if (candidates.size() > 1) {
            Iterator it = candidates.iterator();
            while (it.hasNext()) {
                IGraphNode n = (IGraphNode)it.next();
                String metamodel = new TypeNode(n).getMetamodelURI();
                if (this.defaultNamespaces == null || this.defaultNamespaces.isEmpty() || this.defaultNamespaces.contains(metamodel)) continue;
                it.remove();
            }
            return candidates;
        }
        return Collections.emptyList();
    }

    protected List<IGraphNode> getTypeNodes(String mmURI, String type) {
        Iterator itPack = this.metamodeldictionary.get("id", (Object)mmURI).iterator();
        if (!itPack.hasNext()) {
            throw new NoSuchElementException("Could not find the metamodel node for " + mmURI);
        }
        IGraphNode pack = (IGraphNode)itPack.next();
        for (IGraphEdge r : pack.getIncomingWithType("epackage")) {
            IGraphNode othernode = r.getStartNode();
            if (!othernode.getProperty("_hawkid").equals(type)) continue;
            return Collections.singletonList(othernode);
        }
        return Collections.emptyList();
    }

    protected void broadcastAllOfXAccess(Iterable<?> ret) {
        if (this.propertyGetter.getBroadcastStatus()) {
            for (Object n : ret) {
                AccessListener accessListener = this.propertyGetter.getAccessListener();
                String sID = String.valueOf(((GraphNodeWrapper)n).getId());
                accessListener.accessed(sID, "property_unused_type_or_kind");
            }
        }
    }

    public Object getElementById(String id) {
        IGraphNode ret = this.graph.getNodeById((Object)id);
        return ret == null ? null : this.wrap(ret);
    }

    public String getElementId(Object arg0) {
        if (arg0 instanceof GraphNodeWrapper) {
            return String.valueOf(((GraphNodeWrapper)arg0).getId());
        }
        return null;
    }

    public String getTypeNameOf(Object arg0) {
        String ret = null;
        try {
            TypeNodeWrapper type = this.getTypeOf(arg0);
            IGraphNode typeNode = ((GraphNodeWrapper)((Object)type)).getNode();
            ret = typeNode.getProperty("_hawkid").toString();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    public TypeNodeWrapper getTypeOf(Object arg0) {
        IGraphNode objectNode = ((GraphNodeWrapper)arg0).getNode();
        TypeNode typeNode = new ModelElementNode(objectNode).getTypeNode();
        if (typeNode != null) {
            return new TypeNodeWrapper(typeNode, this);
        }
        return null;
    }

    @Override
    public FileNodeWrapper getFileOf(Object arg0) {
        IGraphNode objectNode = ((GraphNodeWrapper)arg0).getNode();
        FileNode fileNode = new ModelElementNode(objectNode).getFileNode();
        if (fileNode != null) {
            return new FileNodeWrapper(fileNode, this);
        }
        return null;
    }

    @Override
    public List<FileNodeWrapper> getFilesOf(Object arg0) {
        ArrayList<FileNodeWrapper> ret = new ArrayList<FileNodeWrapper>();
        IGraphNode objectNode = ((GraphNodeWrapper)arg0).getNode();
        for (FileNode fn : new ModelElementNode(objectNode).getFileNodes()) {
            ret.add(new FileNodeWrapper(fn, this));
        }
        return ret;
    }

    public boolean hasType(String type) {
        return this.getTypeNodes(type).size() == 1;
    }

    public boolean isModelElement(Object arg0) {
        return arg0 instanceof GraphNodeWrapper;
    }

    public void load() throws EolModelLoadingException {
        if (this.graph == null) {
            throw new EolModelLoadingException(new Exception("load called with no graph store initialized"), (IModel)this);
        }
        this.load(null);
    }

    public void load(IModelIndexer m) throws EolModelLoadingException {
        if (m != null) {
            this.indexer = m;
            this.graph = m.getGraph();
            this.aliases.add(m.getName());
        }
        if (this.name == null) {
            this.name = "Model";
        }
        if (this.propertyGetter == null || this.propertyGetter.getGraph() != this.graph) {
            this.propertyGetter = this.createContextlessPropertyGetter();
        }
        if (this.graph != null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (IGraphTransaction tx = this.graph.beginTransaction();){
                    this.metamodeldictionary = this.graph.getMetamodelIndex();
                    this.useOptimisableCollection = !this.indexer.getIndexedAttributes().isEmpty() || !this.indexer.getDerivedAttributes().isEmpty();
                    tx.success();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                LOGGER.error("Could not retrieve the metamodel index", (Throwable)e);
            }
        } else {
            throw new EolModelLoadingException(new Exception("Attempt to load a model from an invalid graph: " + this.graph), (IModel)this);
        }
    }

    public boolean owns(Object arg0) {
        if (arg0 instanceof GraphNodeWrapper) {
            GraphNodeWrapper gnw = (GraphNodeWrapper)arg0;
            if (gnw.getContainerModel() == null || gnw.getContainerModel() == this) {
                return true;
            }
            LOGGER.warn("owns failed on {} with getContainerModel(): {} and 'this': {}", new Object[]{arg0, gnw.getContainerModel(), this});
        }
        return false;
    }

    public boolean isOfKind(Object instance, String metaClass) throws EolModelElementTypeNotFoundException {
        return this.isOf(instance, metaClass, ModelElementNode::isOfKind);
    }

    public boolean isOfType(Object instance, String metaClass) throws EolModelElementTypeNotFoundException {
        return this.isOf(instance, metaClass, ModelElementNode::isOfType);
    }

    private boolean isOf(Object instance, String metaClass, Function3<ModelElementNode, IGraphNode, Boolean> isOfCheck) {
        if (!(instance instanceof GraphNodeWrapper)) {
            return false;
        }
        if (ANY_TYPE.equals(metaClass)) {
            return true;
        }
        List<IGraphNode> typeNodes = this.getTypeNodes(metaClass);
        if (typeNodes.isEmpty()) {
            return false;
        }
        GraphNodeWrapper gnw = (GraphNodeWrapper)instance;
        ModelElementNode men = new ModelElementNode(gnw.getNode());
        return isOfCheck.apply(men, typeNodes.get(0));
    }

    public boolean knowsAboutProperty(Object instance, String property) {
        if (!this.owns(instance)) {
            return false;
        }
        return instance instanceof GraphNodeWrapper;
    }

    public IPropertyGetter getPropertyGetter() {
        if (this.propertyGetter == null) {
            LOGGER.warn("null property getter, was load() called?");
        }
        return this.propertyGetter;
    }

    public IPropertySetter getPropertySetter() {
        return null;
    }

    public IGraphDatabase getBackend() {
        return this.graph;
    }

    public List<ProxyReferenceList> getProxies() throws Exception {
        return ProxyReferenceList.getLists((IGraphDatabase)this.graph);
    }

    public List<ProxyReferenceList> getProxies(String repositoryPrefix) throws Exception {
        return ProxyReferenceList.getLists((IGraphDatabase)this.graph, (String)repositoryPrefix);
    }

    public List<TypeNodeWrapper> getTypes() {
        ArrayList<TypeNodeWrapper> nodes = new ArrayList<TypeNodeWrapper>();
        for (IGraphNode n : this.graph.getMetamodelIndex().query("*", (Object)"*")) {
            MetamodelNode pn = new MetamodelNode(n);
            for (TypeNode tn : pn.getTypes()) {
                nodes.add(new TypeNodeWrapper(tn, this));
            }
        }
        return nodes;
    }

    public List<MetamodelNodeWrapper> getMetamodels() {
        ArrayList<MetamodelNodeWrapper> nodes = new ArrayList<MetamodelNodeWrapper>();
        for (IGraphNode n : this.graph.getMetamodelIndex().query("*", (Object)"*")) {
            MetamodelNode pn = new MetamodelNode(n);
            nodes.add(new MetamodelNodeWrapper(pn, this));
        }
        return nodes;
    }

    public Set<FileNodeWrapper> getFiles() {
        HashSet<FileNodeWrapper> allFNW = new HashSet<FileNodeWrapper>();
        for (IGraphNode n : this.graph.allNodes("file")) {
            allFNW.add(new FileNodeWrapper(new FileNode(n), this));
        }
        return allFNW;
    }

    public AccessListener calculateDerivedAttributes(IModelIndexer m, Iterable<IGraphNode> nodes) {
        boolean enableDebug = false;
        this.indexer = m;
        this.graph = m.getGraph();
        if (this.propertyGetter == null) {
            this.propertyGetter = this.createContextlessPropertyGetter();
        }
        try {
            this.load(m);
        }
        catch (EolModelLoadingException e2) {
            e2.printStackTrace();
        }
        GraphPropertyGetter pg = null;
        pg = (GraphPropertyGetter)this.getPropertyGetter();
        pg.setBroadcastAccess(true);
        HashMap<String, EolModule> cachedModules = new HashMap<String, EolModule>();
        try {
            Throwable throwable = null;
            Object var7_10 = null;
            try (IGraphTransaction t = this.graph.beginTransaction();){
                for (IGraphNode n : nodes) {
                    String attrType = "" + n.getProperty("attributetype");
                    if ("TimelineAnnotation".equals(attrType)) {
                        this.calculateTimelineAnnotation(cachedModules, n);
                        continue;
                    }
                    this.calculateDerivedAttributes(cachedModules, n);
                }
                t.success();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to compute the derived attributes", (Throwable)e);
        }
        pg.setBroadcastAccess(false);
        return pg.getAccessListener();
    }

    private void calculateTimelineAnnotation(Map<String, EolModule> cachedModules, IGraphNode n) {
        String derivationLogic = "" + n.getProperty("derivationlogic");
        String name = ((IGraphEdge)n.getIncoming().iterator().next()).getType();
        try {
            Object value = new DeriveFeature().deriveTimelineAnnotation(cachedModules, this.indexer, n, this, derivationLogic);
            if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
                IGraphNode elementNode = ((IGraphEdge)n.getIncoming().iterator().next()).getStartNode();
                String idxName = n.getProperty("indexName").toString();
                IGraphNodeIndex idxNodeByDerivedValue = this.graph.getOrCreateNodeIndex(idxName);
                if (idxNodeByDerivedValue instanceof ITimeAwareGraphNodeIndex) {
                    ITimeAwareGraphNodeIndex taNI = (ITimeAwareGraphNodeIndex)idxNodeByDerivedValue;
                    taNI.annotate(elementNode, name);
                } else {
                    idxNodeByDerivedValue.remove(elementNode, name, null);
                    idxNodeByDerivedValue.add(elementNode, name, (Object)true);
                }
                elementNode.setProperty("h_lastDerived", (Object)System.nanoTime());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while deriving timeline annotation " + derivationLogic, (Throwable)e);
        }
    }

    protected GraphPropertyGetter createContextlessPropertyGetter() {
        return new GraphPropertyGetter(this.graph, this);
    }

    protected void calculateDerivedAttributes(Map<String, EolModule> cachedModules, IGraphNode n) {
        for (String propKey : n.getPropertyKeys()) {
            String propValue = n.getProperty(propKey).toString();
            if (!propValue.startsWith("_NYD##")) continue;
            Object derived = "DERIVATION_EXCEPTION";
            try {
                derived = new DeriveFeature().deriveFeature(cachedModules, this.indexer, n, this, propValue);
            }
            catch (Exception e) {
                LOGGER.error("Error while deriving feature " + propValue, (Throwable)e);
            }
            String derivedEdgeLabel = "de" + propKey;
            for (IGraphEdge edge : n.getOutgoingWithType(derivedEdgeLabel)) {
                LOGGER.debug("Clearing edge {}", (Object)edge.getType());
                edge.delete();
            }
            n.removeProperty(propKey);
            if (derived instanceof Object[] && ((Object[])derived).length > 0 && ((Object[])derived)[0] instanceof GraphNodeWrapper) {
                GraphNodeWrapper[] nodes;
                GraphNodeWrapper[] graphNodeWrapperArray = nodes = (GraphNodeWrapper[])derived;
                int n2 = nodes.length;
                int n3 = 0;
                while (n3 < n2) {
                    GraphNodeWrapper gw = graphNodeWrapperArray[n3];
                    this.graph.createRelationship(n, gw.getNode(), derivedEdgeLabel);
                    ++n3;
                }
            } else if (derived instanceof GraphNodeWrapper) {
                GraphNodeWrapper gw = (GraphNodeWrapper)derived;
                this.graph.createRelationship(n, gw.getNode(), derivedEdgeLabel);
            } else if (derived != null) {
                n.setProperty(propKey, derived);
            } else {
                n.setProperty(propKey, (Object)new String[0]);
            }
            IGraphNode elementNode = ((IGraphEdge)n.getIncoming().iterator().next()).getStartNode();
            String idxName = n.getProperty("indexName").toString();
            IGraphNodeIndex idxNodeByDerivedValue = this.graph.getOrCreateNodeIndex(idxName);
            if (derived == null) continue;
            if (derived.getClass().getComponentType() != null || derived instanceof Collection) {
                derived = new Utils().toString(derived);
            }
            idxNodeByDerivedValue.remove(elementNode, propKey, null);
            idxNodeByDerivedValue.add(elementNode, propKey, derived);
            elementNode.setProperty("h_lastDerived", (Object)System.nanoTime());
        }
        IGraphNodeIndex derivedProxyDictionary = this.graph.getOrCreateNodeIndex("derivedproxydictionary");
        derivedProxyDictionary.remove(n);
    }

    public String getType() {
        return TYPE;
    }

    public List<String> validate(String derivationlogic) {
        IEolModule module = this.createModule();
        LinkedList<String> ret = new LinkedList<String>();
        try {
            module.parse(derivationlogic);
            for (ParseProblem p : module.getParseProblems()) {
                ret.add(p.toString());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while parsing EOL", (Throwable)e);
        }
        return ret;
    }

    public Object query(IModelIndexer m, String query, Map<String, Object> context) throws InvalidQueryException, QueryExecutionException {
        IStateListener.HawkState currentState = m.getCompositeStateListener().getCurrentState();
        if (currentState != IStateListener.HawkState.RUNNING) {
            throw new QueryExecutionException(String.format("Cannot run the query, as the indexer is not in the RUNNING state: it is %s instead.", currentState));
        }
        if (context != null && (context.containsKey("REPOSITORY") || context.containsKey("FILE") || context.containsKey("SUBTREE"))) {
            return this.contextfulQuery(m, query, context);
        }
        return this.contextlessQuery(m, query, context);
    }

    protected Object contextlessQuery(IModelIndexer m, String query, Map<String, Object> context) throws QueryExecutionException, InvalidQueryException {
        String defaultnamespaces = null;
        if (context != null) {
            defaultnamespaces = (String)context.get("DEFAULTNAMESPACES");
        }
        EOLQueryEngine q = new EOLQueryEngine();
        try {
            q.load(m);
            q.setDefaultNamespaces(defaultnamespaces);
        }
        catch (EolModelLoadingException e) {
            throw new QueryExecutionException("Loading of EOLQueryEngine failed");
        }
        IEolModule module = this.createModule();
        this.parseQuery(query, context, q, module);
        return q.runQuery(module);
    }

    protected Object contextfulQuery(IModelIndexer m, String query, Map<String, Object> context) throws QueryExecutionException, InvalidQueryException {
        CEOLQueryEngine q = new CEOLQueryEngine();
        try {
            q.load(m);
            q.setContext(context);
        }
        catch (EolModelLoadingException e) {
            throw new QueryExecutionException("Loading of EOLQueryEngine failed");
        }
        LOGGER.debug("Graph path: {}", (Object)this.graph.getPath());
        IEolModule module = this.createModule();
        this.parseQuery(query, context, q, module);
        return q.runQuery(module);
    }

    protected IEolModule createModule() {
        return new EolModule();
    }

    protected void parseQuery(String query, Map<String, Object> context, EOLQueryEngine model, IEolModule module) throws InvalidQueryException {
        try {
            module.parse(query);
            if (!module.getParseProblems().isEmpty()) {
                StringBuilder sb = new StringBuilder("Query failed to parse correctly:");
                for (ParseProblem problem : module.getParseProblems()) {
                    sb.append("\n");
                    sb.append(problem.toString());
                }
                throw new InvalidQueryException(sb.toString());
            }
        }
        catch (Exception ex) {
            throw new InvalidQueryException((Throwable)ex);
        }
        module.getContext().getModelRepository().addModel((IModel)model);
        this.addQueryArguments(context, module);
        if (context != null && context.containsKey("EXEC_CANCEL_CONSUMER")) {
            Consumer cancelProvider = (Consumer)context.get("EXEC_CANCEL_CONSUMER");
            SettableExecutionController controller = new SettableExecutionController();
            module.getContext().getExecutorFactory().setExecutionController((ExecutionController)controller);
            cancelProvider.accept(() -> controller.setTerminated(true));
        }
    }

    protected Object runQuery(IEolModule module) throws QueryExecutionException {
        Object ret = null;
        try {
            try {
                Throwable throwable = null;
                Object var4_7 = null;
                try (IGraphTransaction tx = this.graph.beginTransaction();){
                    ret = module.execute();
                    tx.success();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (EolUndefinedVariableException ex) {
                try {
                    Throwable throwable = null;
                    Object var5_14 = null;
                    try {
                        IGraphTransaction tx = this.graph.beginTransaction();
                        try {
                            EOLQueryEngine eolQuery = (EOLQueryEngine)((Object)module.getContext().getModelRepository().getModels().get(0));
                            List<IGraphNode> typeNodes = eolQuery.getTypeNodes(ex.getVariableName());
                            StringBuilder sb = new StringBuilder("Ambiguous type reference '" + ex.getVariableName() + "' across these metamodels:\n");
                            for (IGraphNode typeNode : typeNodes) {
                                sb.append("\n* ");
                                sb.append(new TypeNode(typeNode).getMetamodelURI());
                            }
                            sb.append("\n\nSpecify the desired one in the default namespaces to resolve the ambiguity.");
                            tx.success();
                            if (typeNodes.size() > 1) {
                                throw new QueryExecutionException(sb.toString());
                            }
                            throw new QueryExecutionException((Throwable)ex);
                        }
                        catch (Throwable throwable3) {
                            if (tx != null) {
                                tx.close();
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (QueryExecutionException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new QueryExecutionException((Throwable)e);
                }
            }
            catch (Exception e) {
                throw new QueryExecutionException((Throwable)e);
            }
        }
        finally {
            module.getContext().getModelRepository().dispose();
            module.getContext().dispose();
            module.getContext().setOperationFactory(null);
            this.typeNodesCache.clear();
            this.propertyGetter = null;
            this.metamodeldictionary = null;
        }
        return ret;
    }

    protected void addQueryArguments(Map<String, Object> context, IEolModule module) {
        Map args;
        if (context != null && (args = (Map)context.get("ARGUMENTS")) != null) {
            for (Map.Entry entry : args.entrySet()) {
                module.getContext().getFrameStack().putGlobal(new Variable((String)entry.getKey(), entry.getValue(), null));
            }
        }
    }

    public void setDefaultNamespaces(String namespaces) {
        try {
            this.defaultNamespaces = new HashSet<String>();
            if (namespaces != null && !namespaces.trim().equals("")) {
                String[] eps;
                String[] stringArray = eps = namespaces.split(",");
                int n = eps.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    this.defaultNamespaces.add(s.trim());
                    ++n2;
                }
            }
        }
        catch (Throwable t) {
            LOGGER.error("Setting default namespaces failed, malformed property: " + namespaces, t);
        }
    }

    public String getHumanReadableName() {
        return "EOL Query Engine";
    }

    public GraphNodeWrapper wrap(IGraphNode node) {
        return new GraphNodeWrapper(node, this);
    }

    static interface Function3<T, U, V> {
        public V apply(T var1, U var2);
    }

    public class GraphNodeWrapper
    implements IGraphNodeReference {
        protected String id;
        protected EOLQueryEngine containerModel;
        protected WeakReference<IGraphNode> node;

        protected GraphNodeWrapper(IGraphNode n, EOLQueryEngine containerModel) {
            this.node = new WeakReference<IGraphNode>(n);
            this.id = n.getId().toString();
            this.containerModel = containerModel;
        }

        public IGraphNode getNode() {
            IGraphNode ret = (IGraphNode)this.node.get();
            if (ret == null) {
                ret = this.containerModel.getBackend().getNodeById((Object)this.id);
                this.node = new WeakReference<IGraphNode>(ret);
            }
            return ret;
        }

        public String getId() {
            return this.id;
        }

        public EOLQueryEngine getContainerModel() {
            return this.containerModel;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GraphNodeWrapper other = (GraphNodeWrapper)obj;
            return Objects.equals((Object)this.containerModel, (Object)other.containerModel) && Objects.equals(this.id, other.id);
        }

        public Object getFeature(String name) throws EolRuntimeException {
            return this.containerModel.getPropertyGetter().invoke((Object)this, name);
        }

        public boolean isContainedWithin(String repository, String path) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (IGraphTransaction t = this.containerModel.getBackend().beginTransaction();){
                    ModelElementNode men = new ModelElementNode(this.getNode());
                    return men.isContainedWithin(repository, path);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return false;
            }
        }

        public String getTypeName() {
            String type = "";
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (IGraphTransaction t = this.containerModel.getBackend().beginTransaction();){
                    IGraphNode n = this.getNode();
                    Iterator itTypeNode = n.getOutgoingWithType("_hawkOfType").iterator();
                    if (itTypeNode.hasNext()) {
                        IGraphNode typeNode = ((IGraphEdge)itTypeNode.next()).getEndNode();
                        type = typeNode.getProperty("_hawkid").toString();
                    } else {
                        LOGGER.error("No type node found for node {}", (Object)n);
                    }
                    t.success();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            return type;
        }

        public String toString() {
            String info = "";
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (IGraphTransaction t = this.containerModel.getBackend().beginTransaction();){
                    info = String.valueOf(info) + "type:" + this.getTypeName();
                    info = String.valueOf(info);
                    t.success();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            return "GNW|id:" + this.id + "|" + (info.equals("") ? "[no meta-info]" : info);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.containerModel, this.id});
        }
    }

    protected class IGraphIterableCollection
    implements Collection<GraphNodeWrapper> {
        private final IGraphIterable<? extends IGraphNode> iterableNodes;

        protected IGraphIterableCollection(IGraphIterable<? extends IGraphNode> iterableNodes) {
            this.iterableNodes = iterableNodes;
        }

        @Override
        public int size() {
            return this.iterableNodes.size();
        }

        @Override
        public boolean isEmpty() {
            return this.iterableNodes.size() > 0;
        }

        @Override
        public boolean contains(Object o) {
            Iterator<GraphNodeWrapper> itN = this.iterator();
            while (itN.hasNext()) {
                if (!itN.next().equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Iterator<GraphNodeWrapper> iterator() {
            final Iterator itNodes = this.iterableNodes.iterator();
            return new Iterator<GraphNodeWrapper>(){

                @Override
                public boolean hasNext() {
                    return itNodes.hasNext();
                }

                @Override
                public GraphNodeWrapper next() {
                    return EOLQueryEngine.this.wrap((IGraphNode)itNodes.next());
                }
            };
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[this.size()]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length < this.size()) {
                Object[] result = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
                return this.toArray(result);
            }
            int i = 0;
            for (GraphNodeWrapper n : this) {
                a[i] = n;
                ++i;
            }
            while (i < a.length) {
                a[i++] = null;
            }
            return a;
        }

        @Override
        public boolean add(GraphNodeWrapper e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object e : c) {
                if (this.contains(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends GraphNodeWrapper> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    public static class SettableExecutionController
    extends DefaultExecutionController {
        private volatile boolean isTerminated = false;

        public boolean isTerminated() {
            return this.isTerminated;
        }

        public void setTerminated(boolean terminated) {
            this.isTerminated = terminated;
        }
    }
}

