/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.epsilon.emc.pgetters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.epsilon.eol.exceptions.EolIllegalPropertyException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.introspection.AbstractPropertyGetter;
import org.eclipse.epsilon.eol.types.EolOrderedSet;
import org.eclipse.epsilon.eol.types.EolSequence;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.util.Utils;
import org.eclipse.hawk.epsilon.emc.EOLQueryEngine;
import org.eclipse.hawk.epsilon.emc.tracking.AccessListener;
import org.eclipse.hawk.epsilon.emc.wrappers.GraphEdgeWrapper;
import org.eclipse.hawk.graph.ModelElementNode;
import org.eclipse.hawk.graph.TypeNode;

public class GraphPropertyGetter
extends AbstractPropertyGetter {
    public static final String REVERSE_REFNAV_PREFIX = "revRefNav_";
    protected static final int IDX_FLAG_MANY = 1;
    protected static final int IDX_FLAG_ORDERED = 2;
    protected static final int IDX_FLAG_UNIQUE = 3;
    protected boolean broadcastAccess = false;
    protected IGraphDatabase graph;
    protected EOLQueryEngine model;
    protected AccessListener accessListener = new AccessListener();
    protected Map<IGraphNode, Map<String, PropertyType>> propertyTypeCache = new WeakHashMap<IGraphNode, Map<String, PropertyType>>();
    protected Map<IGraphNode, Map<String, String[]>> propertyTypeFlagsCache = new WeakHashMap<IGraphNode, Map<String, String[]>>();
    private IGraphNode featureStartingNodeClassNode;

    public GraphPropertyGetter(IGraphDatabase graph, EOLQueryEngine m) {
        this.graph = graph;
        this.model = m;
    }

    public Object invoke(Object object, String property, IEolContext context) throws EolRuntimeException {
        return this.invoke(object, property);
    }

    public Object invoke(Object object, String property) throws EolRuntimeException {
        if (!(object instanceof EOLQueryEngine.GraphNodeWrapper)) {
            throw new EolRuntimeException("a non GraphNodeWrapper object passed to GraphPropertyGetter!");
        }
        IGraphNode node = ((EOLQueryEngine.GraphNodeWrapper)object).getNode();
        Object ret = this.invokePredefined(property, node);
        if (ret == null) {
            ret = this.invokeElementProperty(object, property, node);
        }
        if (this.broadcastAccess) {
            this.broadcastAccess(object, property);
        }
        return ret;
    }

    protected Object invokeElementProperty(Object obj, String property, IGraphNode node) throws EolRuntimeException, EolIllegalPropertyException {
        PropertyType propertyType = this.getPropertyType(node, property);
        switch (propertyType) {
            case ATTRIBUTE: {
                Object value = node.getProperty(property);
                if (value != null) {
                    if (!this.isMany(property)) {
                        return value;
                    }
                    return new Utils().asList(value);
                }
                return null;
            }
            case DERIVED: {
                Object derivedValue = null;
                for (IGraphEdge r : node.getOutgoingWithType(property)) {
                    if (derivedValue != null) {
                        throw new EolRuntimeException(String.format("WARNING: a derived property node (arity 1) -- (%s) has more than 1 links in store!", property));
                    }
                    IGraphNode nDerived = r.getEndNode();
                    derivedValue = nDerived.getProperty(property);
                    if (derivedValue != null) continue;
                    EolSequence derivedTargets = null;
                    for (IGraphEdge edge : nDerived.getOutgoingWithType("de" + property)) {
                        if (derivedTargets == null) {
                            derivedTargets = new EolSequence();
                            derivedValue = derivedTargets;
                        }
                        derivedTargets.add(this.model.wrap(edge.getEndNode()));
                    }
                }
                if (derivedValue == null) {
                    throw new EolRuntimeException("derived attribute lookup failed for: " + node + " # " + property);
                }
                if (derivedValue instanceof String && ((String)derivedValue).startsWith("_NYD##")) {
                    System.err.println("attribute: " + property + " is NYD for node: " + node.getId());
                }
                return derivedValue;
            }
            case MIXED: {
                Collection<Object> retCollection = this.getCollectionForProperty(property);
                if (node.getProperty(property) != null) {
                    List values = new Utils().asList(node.getProperty(property));
                    retCollection.addAll(values);
                }
                for (IGraphEdge r : node.getOutgoingWithType(property)) {
                    retCollection.add(this.model.wrap(r.getEndNode()));
                }
                return retCollection;
            }
            case REFERENCE: {
                EOLQueryEngine.GraphNodeWrapper otherNode = null;
                Collection<Object> otherNodes = null;
                if (this.isMany(property)) {
                    otherNodes = this.getCollectionForProperty(property);
                }
                for (IGraphEdge r : node.getOutgoingWithType(property)) {
                    if (otherNodes != null) {
                        otherNodes.add(this.model.wrap(r.getEndNode()));
                        continue;
                    }
                    if (otherNode == null) {
                        otherNode = this.model.wrap(r.getEndNode());
                        continue;
                    }
                    throw new EolRuntimeException("A relationship with arity 1 ( " + property + " ) has more than 1 links");
                }
                return otherNodes != null ? otherNodes : otherNode;
            }
        }
        return null;
    }

    protected Object invokePredefined(String property, IGraphNode node) throws EolRuntimeException {
        if (property.startsWith(REVERSE_REFNAV_PREFIX)) {
            String referenceName = property.substring(REVERSE_REFNAV_PREFIX.length());
            EolSequence ret = new EolSequence();
            for (IGraphEdge r : node.getIncomingWithType(referenceName)) {
                ret.add((Object)this.model.wrap(r.getStartNode()));
            }
            for (IGraphEdge r : node.getIncomingWithType("de" + referenceName)) {
                IGraphNode derivedNode = r.getStartNode();
                IGraphNode elementNode = ((IGraphEdge)derivedNode.getIncoming().iterator().next()).getStartNode();
                ret.add((Object)this.model.wrap(elementNode));
            }
            return ret;
        }
        switch (property) {
            case "hawkFile": {
                String sep = "";
                StringBuilder buff = new StringBuilder(32);
                for (IGraphEdge e : node.getOutgoingWithType("_hawkFile")) {
                    buff.append(sep);
                    buff.append(e.getEndNode().getProperty("_hawkid").toString());
                    sep = ";";
                }
                return buff.toString();
            }
            case "hawkRepo": {
                String sep = "";
                StringBuilder buff = new StringBuilder(32);
                for (IGraphEdge e : node.getOutgoingWithType("_hawkFile")) {
                    buff.append(sep);
                    buff.append(e.getEndNode().getProperty("repository").toString());
                    sep = ";";
                }
                return buff.toString();
            }
            case "hawkFiles": {
                HashSet<String> files = new HashSet<String>();
                for (IGraphEdge e : node.getOutgoingWithType("_hawkFile")) {
                    files.add(e.getEndNode().getProperty("_hawkid").toString());
                }
                return files;
            }
            case "hawkRepos": {
                HashSet<String> repos = new HashSet<String>();
                for (IGraphEdge e : node.getOutgoingWithType("_hawkFile")) {
                    repos.add(e.getEndNode().getProperty("repository").toString());
                }
                return repos;
            }
            case "eContainer": {
                EOLQueryEngine.GraphNodeWrapper ret = null;
                for (IGraphEdge r : node.getIncoming()) {
                    if (r.getProperty("isContainment") == null) continue;
                    ret = this.model.wrap(r.getStartNode());
                    break;
                }
                if (ret == null) {
                    for (IGraphEdge r : node.getOutgoing()) {
                        if (r.getProperty("isContainer") == null) continue;
                        ret = this.model.wrap(r.getEndNode());
                        break;
                    }
                }
                return ret;
            }
            case "eContainers": {
                Object ret = null;
                for (IGraphEdge r : node.getIncoming()) {
                    if (r.getProperty("isContainment") == null) continue;
                    return Collections.singletonList(this.model.wrap(r.getStartNode()));
                }
                if (ret == null) {
                    for (IGraphEdge r : node.getOutgoing()) {
                        if (r.getProperty("isContainer") == null) continue;
                        return Collections.singletonList(this.model.wrap(r.getEndNode()));
                    }
                }
                return Collections.emptyList();
            }
            case "eContents": {
                return this.getContents(node);
            }
            case "eAllContents": {
                return this.addAllContents(node, new ArrayList<EOLQueryEngine.GraphNodeWrapper>());
            }
            case "hawkIn": 
            case "hawkOut": {
                boolean isIncoming = property.equals("hawkIn");
                EolSequence results = new EolSequence();
                Iterable edges = isIncoming ? node.getIncoming() : node.getOutgoing();
                for (IGraphEdge r : edges) {
                    IGraphNode edgeNode;
                    if (ModelElementNode.TRANSIENT_EDGE_LABELS.contains(r.getType())) continue;
                    IGraphNode iGraphNode = edgeNode = isIncoming ? r.getStartNode() : r.getEndNode();
                    if (r.getProperty("isDerived") != null) {
                        Iterable it = isIncoming ? edgeNode.getIncoming() : edgeNode.getOutgoing();
                        for (IGraphEdge derivedEdge : it) {
                            IGraphNode derivedEdgeNode = isIncoming ? derivedEdge.getStartNode() : derivedEdge.getEndNode();
                            EOLQueryEngine.GraphNodeWrapper edgeNodeWrapper = this.model.wrap(derivedEdgeNode);
                            results.add(edgeNodeWrapper);
                        }
                        continue;
                    }
                    EOLQueryEngine.GraphNodeWrapper edgeNodeWrapper = this.model.wrap(edgeNode);
                    results.add(edgeNodeWrapper);
                }
                return results;
            }
            case "hawkOutEdges": 
            case "hawkInEdges": {
                boolean isIncoming = property.equals("hawkInEdges");
                EolSequence results = new EolSequence();
                Iterable edges = isIncoming ? node.getIncoming() : node.getOutgoing();
                for (IGraphEdge r : edges) {
                    if (ModelElementNode.TRANSIENT_EDGE_LABELS.contains(r.getType())) continue;
                    if (r.getProperty("isDerived") != null) {
                        IGraphNode derivedNode = isIncoming ? r.getStartNode() : r.getEndNode();
                        Iterable it = isIncoming ? derivedNode.getIncoming() : derivedNode.getOutgoing();
                        for (IGraphEdge derivedEdge : it) {
                            results.add(new GraphEdgeWrapper(derivedEdge, this.model));
                        }
                        continue;
                    }
                    results.add(new GraphEdgeWrapper(r, this.model));
                }
                return results;
            }
            case "hawkURIFragment": {
                return node.getProperty("_hawkid");
            }
            case "hawkProxies": {
                ModelElementNode men = new ModelElementNode(node);
                return men.getProxies();
            }
        }
        return null;
    }

    private List<EOLQueryEngine.GraphNodeWrapper> addAllContents(IGraphNode node, List<EOLQueryEngine.GraphNodeWrapper> results) {
        for (EOLQueryEngine.GraphNodeWrapper child : this.getContents(node)) {
            results.add(child);
            this.addAllContents(child.getNode(), results);
        }
        return results;
    }

    private List<EOLQueryEngine.GraphNodeWrapper> getContents(IGraphNode node) {
        ArrayList<EOLQueryEngine.GraphNodeWrapper> results = new ArrayList<EOLQueryEngine.GraphNodeWrapper>();
        for (IGraphEdge r : node.getOutgoing()) {
            if (r.getProperty("isContainment") == null) continue;
            results.add(this.model.wrap(r.getEndNode()));
        }
        for (IGraphEdge r : node.getIncoming()) {
            if (r.getProperty("isContainer") == null) continue;
            results.add(this.model.wrap(r.getStartNode()));
        }
        return results;
    }

    protected Collection<Object> getCollectionForProperty(String property) {
        if (this.isUnique(property)) {
            return new EolOrderedSet();
        }
        return new EolSequence();
    }

    protected void broadcastAccess(Object object, String property) {
        this.accessListener.accessed(String.valueOf(((EOLQueryEngine.GraphNodeWrapper)object).getId()), property);
    }

    public void setBroadcastAccess(boolean b) {
        this.broadcastAccess = b;
    }

    public AccessListener getAccessListener() {
        return this.accessListener;
    }

    public IGraphDatabase getGraph() {
        return this.graph;
    }

    public boolean getBroadcastStatus() {
        return this.broadcastAccess;
    }

    protected boolean canHaveDerivedAttr(IGraphNode node, String property) {
        return this.getPropertyType(node, property) == PropertyType.DERIVED;
    }

    protected boolean canHaveMixed(IGraphNode node, String property) {
        return this.getPropertyType(node, property) == PropertyType.MIXED;
    }

    protected boolean canHaveAttr(IGraphNode node, String property) {
        return this.getPropertyType(node, property) == PropertyType.ATTRIBUTE;
    }

    protected boolean canHaveRef(IGraphNode node, String property) {
        return this.getPropertyType(node, property) == PropertyType.REFERENCE;
    }

    protected boolean isMany(String ref) {
        return this.isTypeFlagActive(ref, 1);
    }

    protected boolean isOrdered(String ref) {
        return this.isTypeFlagActive(ref, 2);
    }

    protected boolean isUnique(String ref) {
        return this.isTypeFlagActive(ref, 3);
    }

    protected PropertyType getPropertyType(IGraphNode node, String property) {
        Iterator itTypeOf = node.getOutgoingWithType("_hawkOfType").iterator();
        if (itTypeOf.hasNext()) {
            PropertyType actual;
            this.featureStartingNodeClassNode = ((IGraphEdge)itTypeOf.next()).getEndNode();
            Map<String, PropertyType> knownProperties = this.propertyTypeCache.get(this.featureStartingNodeClassNode);
            if (knownProperties == null) {
                knownProperties = new HashMap<String, PropertyType>();
                this.propertyTypeCache.put(this.featureStartingNodeClassNode, knownProperties);
            }
            if ((actual = knownProperties.get(property)) == null) {
                String value = "_null_hawk_value_error";
                if (this.featureStartingNodeClassNode.getProperty(property) != null) {
                    value = ((String[])this.featureStartingNodeClassNode.getProperty(property))[0];
                }
                if ((actual = PropertyType.fromCharacter(value)) == PropertyType.INVALID) {
                    System.err.println("property: " + property + " not found in metamodel for type: " + this.featureStartingNodeClassNode.getProperty("_hawkid"));
                }
                knownProperties.put(property, actual);
            }
            return actual;
        }
        System.err.println("type not found for node " + node);
        return PropertyType.INVALID;
    }

    protected boolean isTypeFlagActive(String reference, int index) {
        String[] typeFlags;
        if (this.featureStartingNodeClassNode == null) {
            System.err.println("type not found previously for " + reference);
            return false;
        }
        Map<String, String[]> knownTypeFlags = this.propertyTypeFlagsCache.get(this.featureStartingNodeClassNode);
        if (knownTypeFlags == null) {
            knownTypeFlags = new HashMap<String, String[]>();
            this.propertyTypeFlagsCache.put(this.featureStartingNodeClassNode, knownTypeFlags);
        }
        if ((typeFlags = knownTypeFlags.get(reference)) == null && this.featureStartingNodeClassNode.getProperty(reference) != null) {
            typeFlags = (String[])this.featureStartingNodeClassNode.getProperty(reference);
            knownTypeFlags.put(reference, typeFlags);
        }
        if (typeFlags != null) {
            return typeFlags[index].equals("t");
        }
        System.err.println("reference: " + reference + " not found in metamodel (isMany) for type: " + this.featureStartingNodeClassNode.getProperty("_hawkid"));
        return false;
    }

    public String debug(EOLQueryEngine.GraphNodeWrapper object) {
        IGraphNode node = object.getNode();
        String ret = node.toString();
        for (String p : node.getPropertyKeys()) {
            Object n = node.getProperty(p);
            String temp = "error: " + n.getClass();
            if (n instanceof int[]) {
                temp = Arrays.toString((int[])n);
            }
            if (n instanceof long[]) {
                temp = Arrays.toString((long[])n);
            }
            if (n instanceof String[]) {
                temp = Arrays.toString((String[])n);
            }
            if (n instanceof boolean[]) {
                temp = Arrays.toString((boolean[])n);
            }
            ret = String.valueOf(ret) + "[" + p + ";" + (p.equals("class") || p.equals("superclass") ? (temp.length() < 1000 ? temp : "[<TOO LONG TO LOG (>1000chars)>]") : n) + "] ";
        }
        HashSet<String> refs = new HashSet<String>();
        for (IGraphEdge r : node.getOutgoing()) {
            refs.add(r.getType().toString());
        }
        return String.valueOf(ret) + "\nOF TYPE: " + new TypeNode(node).getTypeName() + "\nWITH OUTGOING REFERENCES: " + refs;
    }

    protected static enum PropertyType {
        ATTRIBUTE,
        DERIVED,
        REFERENCE,
        MIXED,
        INVALID;


        static PropertyType fromCharacter(String s) {
            switch (s) {
                case "d": {
                    return DERIVED;
                }
                case "r": {
                    return REFERENCE;
                }
                case "a": {
                    return ATTRIBUTE;
                }
                case "m": {
                    return MIXED;
                }
            }
            return INVALID;
        }
    }
}

