/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.ui2.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.hawk.core.IHawkPlugin;
import org.eclipse.hawk.ui2.util.HUIManager;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class HawkPluginSelectionBlock {
    private Composite control;
    private CheckboxTableViewer metamodelTableViewer;
    private CheckboxTableViewer modelTableViewer;
    private CheckboxTableViewer graphChangeListenerTableViewer;
    private CheckboxTableViewer queryEngineTableViewer;
    private List<IHawkPlugin> plugins = HUIManager.getInstance().getAvailablePlugins();

    public void createControl(Composite parent) {
        ScrolledComposite scrolled = new ScrolledComposite(parent, 512);
        scrolled.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.control = new Composite((Composite)scrolled, 0);
        Font font = parent.getFont();
        this.control.setFont(font);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        layout.horizontalSpacing = 1;
        this.control.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        this.control.setLayoutData((Object)data);
        boolean allChecked = true;
        this.metamodelTableViewer = this.createPluginTableBlock("&Metamodel parsers:", IHawkPlugin.Category.METAMODEL_RESOURCE_FACTORY, true);
        this.modelTableViewer = this.createPluginTableBlock("&Model parsers:", IHawkPlugin.Category.MODEL_RESOURCE_FACTORY, true);
        this.graphChangeListenerTableViewer = this.createPluginTableBlock("&Graph change listeners:", IHawkPlugin.Category.GRAPH_CHANGE_LISTENER, false);
        this.queryEngineTableViewer = this.createPluginTableBlock("&Query engines:", IHawkPlugin.Category.QUERY_ENGINE, true);
        scrolled.setContent((Control)this.control);
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        scrolled.setMinSize(this.control.computeSize(-1, -1));
    }

    private CheckboxTableViewer createPluginTableBlock(String labelText, IHawkPlugin.Category category, boolean allChecked) {
        GridData labelGd = new GridData(1808);
        labelGd.horizontalSpan = 2;
        labelGd.minimumHeight = 20;
        Label label = new Label(this.control, 0);
        label.setText(labelText);
        label.setLayoutData((Object)labelGd);
        Composite tableComposite = this.getTableComposite(this.control);
        CheckboxTableViewer tableViewer = this.newTableViewer(tableComposite);
        tableViewer.setLabelProvider((IBaseLabelProvider)new TypedLabelProvider());
        tableViewer.setContentProvider((IContentProvider)new TypedContentProvider(category));
        tableViewer.setInput(this.plugins);
        tableViewer.setAllChecked(allChecked);
        this.addSelectionButtons(tableViewer, this.control);
        return tableViewer;
    }

    private Composite getTableComposite(Composite control) {
        Composite cTable = new Composite(control, 0);
        GridData gd = new GridData(4, 128, true, true);
        gd.heightHint = 120;
        cTable.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        cTable.setLayout((Layout)layout);
        return cTable;
    }

    private Composite getButtonComposite(Composite control) {
        Composite cTable = new Composite(control, 0);
        FillLayout layout = new FillLayout(512);
        cTable.setLayout((Layout)layout);
        return cTable;
    }

    private void addSelectionButtons(final CheckboxTableViewer tableViewer, Composite composite) {
        Composite cTableButtons = this.getButtonComposite(composite);
        Button btnEnableAll = new Button(cTableButtons, 0);
        btnEnableAll.setText("Enable all");
        btnEnableAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                tableViewer.setAllChecked(true);
            }
        });
        Button btnDisableAll = new Button(cTableButtons, 0);
        btnDisableAll.setText("Disable all");
        btnDisableAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                tableViewer.setAllChecked(false);
            }
        });
    }

    public CheckboxTableViewer getMetamodelTableViewer() {
        return this.metamodelTableViewer;
    }

    public CheckboxTableViewer getModelTableViewer() {
        return this.modelTableViewer;
    }

    public CheckboxTableViewer getGraphChangeListenerTableViewer() {
        return this.graphChangeListenerTableViewer;
    }

    public CheckboxTableViewer getQueryEngineTableViewer() {
        return this.queryEngineTableViewer;
    }

    public Composite getControl() {
        return this.control;
    }

    public void update(List<IHawkPlugin> plugins) {
        this.plugins.clear();
        this.plugins.addAll(plugins);
        this.metamodelTableViewer.refresh();
        this.modelTableViewer.refresh();
        this.graphChangeListenerTableViewer.refresh();
        this.queryEngineTableViewer.refresh();
    }

    public List<String> getAllChecked() {
        ArrayList<String> checked = new ArrayList<String>();
        checked.addAll(this.getCheckedList(this.metamodelTableViewer));
        checked.addAll(this.getCheckedList(this.modelTableViewer));
        checked.addAll(this.getCheckedList(this.graphChangeListenerTableViewer));
        checked.addAll(this.getCheckedList(this.queryEngineTableViewer));
        return checked;
    }

    public List<String> getAllSelectable() {
        ArrayList<String> available = new ArrayList<String>();
        available.addAll(this.getAvailableList(this.metamodelTableViewer));
        available.addAll(this.getAvailableList(this.modelTableViewer));
        available.addAll(this.getAvailableList(this.graphChangeListenerTableViewer));
        available.addAll(this.getAvailableList(this.queryEngineTableViewer));
        return available;
    }

    private List<String> getAvailableList(CheckboxTableViewer tv) {
        ArrayList<String> l = new ArrayList<String>();
        int count = tv.getTable().getItemCount();
        int i = 0;
        while (i < count) {
            IHawkPlugin plugin = (IHawkPlugin)tv.getElementAt(i);
            l.add(plugin.getType());
            ++i;
        }
        return l;
    }

    private CheckboxTableViewer newTableViewer(Composite composite) {
        CheckboxTableViewer modelTableViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2564);
        modelTableViewer.setUseHashlookup(true);
        GridData gd = new GridData(1808);
        gd.minimumHeight = 80;
        modelTableViewer.getTable().setLayoutData((Object)gd);
        modelTableViewer.getTable().setHeaderVisible(false);
        return modelTableViewer;
    }

    private List<String> getCheckedList(CheckboxTableViewer viewer) {
        return Arrays.asList(viewer.getCheckedElements()).stream().map(e -> ((IHawkPlugin)e).getType()).collect(Collectors.toList());
    }

    class TypedContentProvider
    implements IStructuredContentProvider {
        private IHawkPlugin.Category category;

        public TypedContentProvider(IHawkPlugin.Category category) {
            this.category = category;
        }

        public Object[] getElements(Object input) {
            return HawkPluginSelectionBlock.this.plugins.parallelStream().filter(p -> p.getCategory().equals((Object)this.category)).collect(Collectors.toList()).toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    class TypedLabelProvider
    extends LabelProvider
    implements IToolTipProvider {
        TypedLabelProvider() {
        }

        public String getText(Object element) {
            return ((IHawkPlugin)element).getHumanReadableName();
        }

        public String getToolTipText(Object element) {
            return ((IHawkPlugin)element).getType();
        }
    }
}

