/*******************************************************************************
 * Copyright (c) 2008 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Daniel Sanders - Initial cut
 *******************************************************************************/
package org.eclipse.higgins.audit.api;

/**
 * Standard Event Codes as defined by the OpenGroup XDAS specification. 
 */
public final class AuditEvents
{
	// Logger that should be specified for audit log events
	public static final String	HIGGINS_AUDIT_EVENT_LOGGER = "higgins.audit.events";
	
	public static final int AE_NOT_SPECIFIED                 = 0x00000000;
	
	public static final int AE_CREATE_ACCOUNT                = 0x01000001;
	public static final int AE_DELETE_ACCOUNT                = 0x01000002;
	public static final int AE_DISABLE_ACCOUNT               = 0x01000003;
	public static final int AE_ENABLE_ACCOUNT                = 0x01000004;
	public static final int AE_QUERY_ACCOUNT                 = 0x01000005;
	public static final int AE_MODIFY_ACCOUNT                = 0x01000006;
	
	public static final int AE_CREATE_SESSION                = 0x01000007;
	public static final int AE_TERMINATE_SESSION             = 0x01000008;
	public static final int AE_QUERY_SESSION                 = 0x01000009;
	public static final int AE_MODIFY_SESSION                = 0x0100000A;
	
	public static final int AE_CREATE_DATA_ITEM              = 0x0100000B;
	public static final int AE_DELETE_DATA_ITEM              = 0x0100000C;
	public static final int AE_QUERY_DATA_ITEM_ATT           = 0x0100000D;
	public static final int AE_MODIFY_DATA_ITEM_ATT          = 0x0100000E;
	
	public static final int AE_INSTALL_SERVICE               = 0x0100000F;
	public static final int AE_REMOVE_SERVICE                = 0x01000010;
	public static final int AE_QUERY_SERVICE_CONFIG          = 0x01000011;
	public static final int AE_MODIFY_SERVICE_CONFIG         = 0x01000012;
	public static final int AE_DISABLE_SERVICE               = 0x01000013;
	public static final int AE_ENABLE_SERVICE                = 0x01000014;
	public static final int AE_INVOKE_SERVICE                = 0x01000015;
	public static final int AE_TERMINATE_SERVICE             = 0x01000016;
	public static final int AE_QUERY_PROCESS_CONTEXT         = 0x01000017;
	public static final int AE_MODIFY_PROCESS_CONTEXT        = 0x01000018;
	
	public static final int AE_CREATE_PEER_ASSOC             = 0x01000019;
	public static final int AE_TERMINATE_PEER_ASSOC          = 0x0100001A;
	public static final int AE_QUERY_ASSOC_CONTEXT           = 0x0100001B;
	public static final int AE_MODIFY_ASSOC_CONTEXT          = 0x0100001C;
	public static final int AE_RECEIVE_DATA_VIA_ASSOC        = 0x0100001D;
	public static final int AE_SEND_DATA_VIA_ASSOC           = 0x0100001E;
	public static final int AE_CREATE_DATA_ITEM_ASSOC        = 0x0100001F;
	public static final int AE_TERMINATE_DATA_ITEM_ASSOC     = 0x01000020;
	public static final int AE_QUERY_DATA_ITEM_ASSOC_CONTEXT = 0x01000021;
	public static final int AE_MODIFY_DATA_ITEM_ASSOC_CONTEXT= 0x01000022;
	
	public static final int AE_QUERY_DATA_ITEM_CONTENTS      = 0x01000023;
	public static final int AE_MODIFY_DATA_ITEM_CONTENTS     = 0x01000024;
	
	public static final int AE_START_SYS                     = 0x01000025;
	public static final int AE_SHUTDOWN_SYS                  = 0x01000026;
	public static final int AE_RESOURCE_EXHAUST              = 0x01000027;
	public static final int AE_RESOURCE_CORRUPT              = 0x01000028;
	public static final int AE_BACKUP_DATASTORE              = 0x01000029;
	public static final int AE_RECOVER_DATASTORE             = 0x0100002A;
	
	public static final int AE_AUD_CONFIG                    = 0x0100002B;
	public static final int AE_AUD_DS_FULL                   = 0x0100002C;
	public static final int AE_AUD_DS_CORR                   = 0x0100002D;
	
	public static final int AE_MODIFY_AUTH_TOKEN             = 0x02000001;
	public static final int AE_APPROVAL_RECEIVED             = 0x02000002;
	public static final int AE_APPROVAL_REQUESTED            = 0x02000003;
	public static final int AE_REQUEST_ESCALATED             = 0x02000004;
	public static final int AE_NOTIFICATION_SENT             = 0x02000005;
	
	public static final int AE_CREATE_ROLE                   = 0x02000006;
	public static final int AE_DELETE_ROLE                   = 0x02000007;
	public static final int AE_DISABLE_ROLE                  = 0x02000008;
	public static final int AE_ENABLE_ROLE                   = 0x02000009;
	public static final int AE_QUERY_ROLE                    = 0x0200000A;
	public static final int AE_MODIFY_ROLE                   = 0x0200000B;
}

