/*******************************************************************************
 * Copyright (c) 2008 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Daniel Sanders - Initial cut
 *******************************************************************************/
package org.eclipse.higgins.audit.api;

/**
 * Standard Outcome Codes as defined by the OpenGroup XDAS specification. 
 */
public final class AuditOutcomes
{
    public static final int AUDIT_OUT_NOT_SPECIFIED              = 0xFFFFFFFF;
    
    public static final int AUDIT_OUT_SUCCESS                    = 0x00000000;
    public static final int AUDIT_OUT_PRIV_USED                  = 0x00000100;
    public static final int AUDIT_OUT_PRIV_GRANTED               = 0x00000200;
    public static final int AUDIT_OUT_PRIV_REVOKED               = 0x00000400;
    public static final int AUDIT_OUT_PRESELECT_CRITERIA_SET     = 0x00000800;
    public static final int AUDIT_OUT_THRESHOLDS_SET             = 0x00001000;
    public static final int AUDIT_OUT_ACTIONS_SET                = 0x00002000;
    
    public static final int AUDIT_OUT_FAILURE                    = 0x00000001;
    public static final int AUDIT_OUT_SERVICE_UNAVAILABLE        = 0x00000101;
    public static final int AUDIT_OUT_SERVICE_FAILURE            = 0x00000201;
    public static final int AUDIT_OUT_HARDWARE_FAILURE           = 0x00000401;
    public static final int AUDIT_OUT_LOST_ASSOCIATION           = 0x00000801;
    public static final int AUDIT_OUT_ALREADY_ENABLED            = 0x00001001;
    public static final int AUDIT_OUT_ALREADY_DISABLED           = 0x00002001;
    public static final int AUDIT_OUT_SERVICE_ERROR              = 0x00004001;
    public static final int AUDIT_OUT_BUSY                       = 0x00008001;
    public static final int AUDIT_OUT_DISABLED                   = 0x00010001;
    public static final int AUDIT_OUT_INVALID_INPUT              = 0x00020001;
    public static final int AUDIT_OUT_ENTITY_EXISTS              = 0x00040001;
    public static final int AUDIT_OUT_ENTITY_NON_EXISTENT        = 0x00080001;
    
    public static final int AUDIT_OUT_DENIAL                     = 0x00000002;
    public static final int AUDIT_OUT_INSUFFICIENT_PRIVILEGE     = 0x00000102;
    public static final int AUDIT_OUT_INVALID_IDENTITY           = 0x00000202;
    public static final int AUDIT_OUT_INVALID_CREDENTIALS        = 0x00000402;
    
    //The following are newly added outcome
    public static final int AUDIT_OUT_RESOURCE_WAIT              = 0x00003000;
}

