/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.cache;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.cache.CacheException;
import org.eclipse.higgins.cache.api.ICacheProvider;
import org.eclipse.higgins.cache.nocache.NOCacheProvider;
import org.eclipse.higgins.configuration.xml.ConfigurationHandler;

public class CacheProviderFactory {
    private static final Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$cache$CacheProviderFactory == null ? (class$org$eclipse$higgins$cache$CacheProviderFactory = CacheProviderFactory.class$("org.eclipse.higgins.cache.CacheProviderFactory")) : class$org$eclipse$higgins$cache$CacheProviderFactory));
    private static final ConfigurationHandler handler = new ConfigurationHandler();
    private static ICacheProvider cacheProvider;
    private static ClassLoader classLoader;
    static /* synthetic */ Class class$org$eclipse$higgins$cache$CacheProviderFactory;
    static /* synthetic */ Class class$org$eclipse$higgins$cache$api$ICacheProvider;

    private static synchronized void createInstance() {
        if (cacheProvider == null) {
            log.debug((Object)"createInstance");
            try {
                handler.configure(null);
                if (handler.getSettings() != null) {
                    if (!handler.getSettings().containsKey("CacheProviderClassName")) {
                        throw new CacheException("Configuration doesn't have CacheProviderClassName");
                    }
                    if (!handler.getSettings().containsKey("CacheProviderConfigurationURL")) {
                        throw new CacheException("Configuration doesn't have CacheProviderConfigurationURL");
                    }
                    Object provider = classLoader.loadClass(handler.getSettings().get("CacheProviderClassName").toString()).newInstance();
                    log.debug((Object)("cacheProvider of " + provider.getClass().getName() + " was created"));
                    if (!(provider instanceof ICacheProvider)) {
                        throw new CacheException("Class " + provider.getClass().getName() + " not implement " + (class$org$eclipse$higgins$cache$api$ICacheProvider == null ? (class$org$eclipse$higgins$cache$api$ICacheProvider = CacheProviderFactory.class$("org.eclipse.higgins.cache.api.ICacheProvider")) : class$org$eclipse$higgins$cache$api$ICacheProvider).getName() + " interface.");
                    }
                    cacheProvider = (ICacheProvider)provider;
                    Properties properties = new Properties();
                    properties.setProperty("CacheProviderConfigurationURL", handler.getSettings().get("CacheProviderConfigurationURL").toString());
                    cacheProvider.configure(properties);
                    log.debug((Object)"cacheProvider was configured");
                    log.debug((Object)"createInstance successful");
                } else {
                    log.info((Object)"Create NOCacheProvider");
                    cacheProvider = new NOCacheProvider();
                }
            }
            catch (Exception e) {
                log.error((Object)"createInstance:Error:", (Throwable)e);
                log.info((Object)"Create NOCacheProvider");
                cacheProvider = new NOCacheProvider();
            }
        }
    }

    public static ICacheProvider getCacheProvider() {
        log.debug((Object)"getCacheProvider");
        if (cacheProvider == null) {
            CacheProviderFactory.createInstance();
        }
        log.debug((Object)"getCacheProvider is succesful");
        return cacheProvider;
    }

    public static void setClassLoader(ClassLoader classLoader) {
        CacheProviderFactory.classLoader = classLoader;
    }

    public static void setConfigurationBase(String str) {
        handler.setConfigurationBase(str);
    }

    public static void setFileName(String strFile) {
        handler.setFileName(strFile);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        classLoader = (class$org$eclipse$higgins$cache$CacheProviderFactory == null ? (class$org$eclipse$higgins$cache$CacheProviderFactory = CacheProviderFactory.class$("org.eclipse.higgins.cache.CacheProviderFactory")) : class$org$eclipse$higgins$cache$CacheProviderFactory).getClassLoader();
    }
}

