/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko -  initial API and implementation
 * 
 */
package org.eclipse.higgins.cache.api.key;

import java.io.Serializable;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class CacheKey {

	protected final String key;

	/**
	 * @param key
	 */
	public CacheKey(String key) {
		super();
		this.key = key;
	}

	public Serializable getKey() {
		return this.key;
	}

	/**
	 * @param anObject
	 * @return
	 * @see java.lang.String#equals(java.lang.Object)
	 */
	public boolean equals(Object anObject) {
		return this.key.equals(anObject);
	}

	/**
	 * @return
	 * @see java.lang.String#hashCode()
	 */
	public int hashCode() {
		return this.key.hashCode();
	}

}