/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko -  initial API and implementation
 * 
 */
package org.eclipse.higgins.cache;

import java.util.Properties;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.cache.api.ICacheProvider;
import org.eclipse.higgins.cache.nocache.NOCacheProvider;
import org.eclipse.higgins.configuration.xml.ConfigurationHandler;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class CacheProviderFactory {

	private static final org.apache.commons.logging.Log log = LogFactory.getLog(CacheProviderFactory.class);

	private static final ConfigurationHandler handler = new ConfigurationHandler();

	private static ICacheProvider cacheProvider;

	private static ClassLoader classLoader = CacheProviderFactory.class.getClassLoader();

	/**
	 * 
	 */
	private synchronized static void createInstance() {
		if (cacheProvider == null) {
			log.debug("createInstance");
			try {
				try {
					handler.configure(null);
				} catch (Exception e) {
					log.warn("Configuration error " + e.getMessage());
				}
				if (handler.getSettings() != null) {
					if (!handler.getSettings().containsKey(ICacheProvider.CacheProviderClassName)) {
						throw new CacheException("Configuration doesn't have " + ICacheProvider.CacheProviderClassName);
					}
					if (!handler.getSettings().containsKey(ICacheProvider.CacheProviderConfigurationURL)) {
						throw new CacheException("Configuration doesn't have " + ICacheProvider.CacheProviderConfigurationURL);
					}

					final Object provider = classLoader.loadClass(
							handler.getSettings().get(ICacheProvider.CacheProviderClassName).toString()).newInstance();

					log.debug("cacheProvider of " + provider.getClass().getName() + " was created");

					if (!(provider instanceof ICacheProvider)) {
						throw new CacheException("Class " + provider.getClass().getName() + " not implement "
								+ ICacheProvider.class.getName() + " interface.");
					}

					cacheProvider = (ICacheProvider) provider;

					final Properties properties = new Properties();
					properties.setProperty(ICacheProvider.CacheProviderConfigurationURL, handler.getSettings().get(
							ICacheProvider.CacheProviderConfigurationURL).toString());
					cacheProvider.configure(properties);
					log.debug("cacheProvider was configured");

					log.debug("createInstance successful");
				} else {
					log.info("Create NOCacheProvider");
					cacheProvider = new NOCacheProvider();
				}

			} catch (final Exception e) {
				log.error("createInstance:Error:", e);
				log.info("Create NOCacheProvider");
				cacheProvider = new NOCacheProvider();
			}
		}
	}

	/**
	 * @return cacheProvider
	 * @throws CacheException
	 */
	public static ICacheProvider getCacheProvider() {
		log.debug("getCacheProvider");
		if (cacheProvider == null) {
			createInstance();
		}
		log.debug("getCacheProvider is succesful");
		return cacheProvider;
	}

	/**
	 * @param classLoader
	 *            the classLoader to set
	 */
	public static void setClassLoader(final ClassLoader classLoader) {
		CacheProviderFactory.classLoader = classLoader;
	};

	/**
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.configuration.api.IConfigurationHandler#setConfigurationBase(java.lang.String)
	 */
	public static void setConfigurationBase(final String str) {
		handler.setConfigurationBase(str);
	}

	/**
	 * @param strFile
	 * @see org.eclipse.higgins.configuration.xml.ConfigurationHandler#setFileName(java.lang.String)
	 */
	public static void setFileName(final String strFile) {
		handler.setFileName(strFile);
	}

}
