/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.cache;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.cache.CacheException;
import org.eclipse.higgins.cache.api.ICacheProvider;
import org.eclipse.higgins.cache.nocache.NOCacheProvider;
import org.eclipse.higgins.configuration.xml.ConfigurationHandler;

public class CacheProviderFactory {
    private static final Log log;
    private static final ConfigurationHandler handler;
    private static ICacheProvider cacheProvider;
    private static ClassLoader classLoader;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.cache.CacheProviderFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        handler = new ConfigurationHandler();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.higgins.cache.CacheProviderFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classLoader = clazz2.getClassLoader();
    }

    private static synchronized void createInstance() {
        block13: {
            if (cacheProvider == null) {
                log.debug((Object)"createInstance");
                try {
                    try {
                        handler.configure(null);
                    }
                    catch (Exception e) {
                        log.warn((Object)("Configuration error " + e.getMessage()));
                    }
                    if (handler.getSettings() != null) {
                        if (!handler.getSettings().containsKey("CacheProviderClassName")) {
                            throw new CacheException("Configuration doesn't have CacheProviderClassName");
                        }
                        if (!handler.getSettings().containsKey("CacheProviderConfigurationURL")) {
                            throw new CacheException("Configuration doesn't have CacheProviderConfigurationURL");
                        }
                        Object provider = classLoader.loadClass(handler.getSettings().get("CacheProviderClassName").toString()).newInstance();
                        log.debug((Object)("cacheProvider of " + provider.getClass().getName() + " was created"));
                        if (!(provider instanceof ICacheProvider)) {
                            StringBuffer stringBuffer = new StringBuffer("Class ").append(provider.getClass().getName()).append(" not implement ");
                            Class<?> clazz = class$1;
                            if (clazz == null) {
                                try {
                                    clazz = class$1 = Class.forName("org.eclipse.higgins.cache.api.ICacheProvider");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            throw new CacheException(stringBuffer.append(clazz.getName()).append(" interface.").toString());
                        }
                        cacheProvider = (ICacheProvider)provider;
                        Properties properties = new Properties();
                        properties.setProperty("CacheProviderConfigurationURL", handler.getSettings().get("CacheProviderConfigurationURL").toString());
                        cacheProvider.configure(properties);
                        log.debug((Object)"cacheProvider was configured");
                        log.debug((Object)"createInstance successful");
                        break block13;
                    }
                    log.info((Object)"Create NOCacheProvider");
                    cacheProvider = new NOCacheProvider();
                }
                catch (Exception e) {
                    log.error((Object)"createInstance:Error:", (Throwable)e);
                    log.info((Object)"Create NOCacheProvider");
                    cacheProvider = new NOCacheProvider();
                }
            }
        }
    }

    public static ICacheProvider getCacheProvider() {
        log.debug((Object)"getCacheProvider");
        if (cacheProvider == null) {
            CacheProviderFactory.createInstance();
        }
        log.debug((Object)"getCacheProvider is succesful");
        return cacheProvider;
    }

    public static void setClassLoader(ClassLoader classLoader) {
        CacheProviderFactory.classLoader = classLoader;
    }

    public static void setConfigurationBase(String str) {
        handler.setConfigurationBase(str);
    }

    public static void setFileName(String strFile) {
        handler.setFileName(strFile);
    }
}

