/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko -  initial API and implementation 
 * 
 */

package org.eclipse.higgins.cache.api;

import org.eclipse.higgins.cache.CacheException;

/**
 * @author Alexander Yuhimenko
 * 
 */
public interface ICache {

	/**
	 * 
	 * @param key
	 * @return object or null
	 * @throws CacheException
	 */
	public Object get(ICacheKey key) throws CacheException;

	/**
	 * Put object
	 * 
	 * @param key
	 * @param value
	 * @throws CacheException
	 */
	public void put(ICacheKey key, Object value) throws CacheException;

	/**
	 * Update or put object.
	 * 
	 * @param key
	 * @param value
	 * @throws CacheException
	 */
	public void update(ICacheKey key, Object value) throws CacheException;

	/**
	 * If object exist remove it
	 * 
	 * @param key
	 * @throws CacheException
	 */
	public void remove(ICacheKey key) throws CacheException;

	/**
	 * remove all objects from cache
	 * 
	 * @throws CacheException
	 */
	public void clear() throws CacheException;

	/**
	 * @param key
	 * @return true if object exist else false
	 * @throws CacheException
	 */
	public boolean isKeyInCache(ICacheKey key) throws CacheException;

}
