/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.configuration.api;

/**
 * Interface describing the common obejct factory methods
 * 
 * @author mikemci at us dot ibm dot com
 */
public interface IConfigurableComponentFactory
{
	/**
	 * Get a singleton instance
	 * 
	 * @return the same instance each time it is called
	 */
	public abstract IConfigurableComponent getSingletonInstance();
	
	/**
	 * Get a new instance
	 * 
	 * @return a new instance each time it is called
	 */
	public abstract IConfigurableComponent getNewInstance();
}
