/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) -- initial handler definition
 *    Greg Byrd (IBM Corporation) -- initial definition
 *******************************************************************************/

package org.eclipse.higgins.configuration.api;

public interface IConfigurationHandler {
	/***
	 * Set pathname to directory that contains configuration files.
	 */
	public abstract void setConfigurationBase(String str);
	
	/***
	 * Use properties in mapConfigurationSettings to read/create configuration map.
	 * Should be implemented as {@code synchronized}. 
	 * @return TRUE if configuration is successful, FALSE otherwise.
	 */
	public abstract boolean configure(java.util.Map mapConfigurationSettings)
		throws Exception;
	/***
	 * Return settings created by configure call, or null if not yet configured.
	 */
	public abstract java.util.Map getSettings() throws Exception;
}
