package org.eclipse.higgins.configuration.api;

import java.util.List;

public interface ISettingDescriptor {
	public String getName();
	public Class getType();
	public String getDisplayString();
	public String getDocString();
	public List getSubSettings();
	public Object getConstraint(String key);
	
	public void setName(String name);
	public void setType(Class type);
	public void setDisplayString(String display);
	public void setDocString(String doc);
		
	public void addConstraint(String name, Object value);
	public void removeConstraint(String name);
	public void addSubSetting(ISettingDescriptor sub);
	public void addSubSetting(int index, ISettingDescriptor sub);
	public boolean removeSubSetting(ISettingDescriptor sub);
	public ISettingDescriptor removeSubSetting(int index);

}
