/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial definition
 *    Greg Byrd (IBM Corporation) -- added documentation
 *    Rajalakshmi Iyer (IBM)
 *******************************************************************************/

package org.eclipse.higgins.configuration.api;

/**
 * @author mikemci
 *
 */
public interface IConfigurableComponent
{
	/**
	 * Use name/value pairs in map objects to configure.  The combination of values in 
	 * mapGlobalSettings and mapComponentSettings must be sufficient to fully configure
	 * this component.
	 * @param mapGlobalSettings Settings related to this component, and to
	 * other components that might be referenced by this one.
	 * @param strComponentName String used to identify this component (e.g., for logging).
	 * @param mapComponentSettings Component-specific settings, possibly a subset extracted from mapGlobalSettings.
	 * @param componentDescriptor Component-specific setting descriptor
	 * @param globalDescriptor Setting descriptors related to this component and to other 
	 * components that might be referenced by this one.
	 * @throws Exception
	 */
	public abstract void configure
		(final java.util.Map mapGlobalSettings,
		final String strComponentName,
		final java.util.Map mapComponentSettings,
		final ISettingDescriptor componentDescriptor,
		final ISettingDescriptor globalDescriptor)
		throws Exception;
	
	/* Returns the setting descriptor for this component. If no setting descriptor is
	 * configured, this method will return null. */
	public abstract ISettingDescriptor getComponentDescriptor();
	
}
