/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) -- initial handler definition
 *    Greg Byrd (IBM Corporation) -- initial definition
 *    Rajalakshmi Iyer (IBM)
 *******************************************************************************/

package org.eclipse.higgins.configuration.api;

public interface IConfigurationHandler {
	/***
	 * Set pathname to directory that contains configuration files.
	 */
	public abstract void setConfigurationBase(String str);
	
	/***
	 * Use properties in mapConfigurationSettings to read/create configuration map.
	 * Should be implemented as {@code synchronized}. 
	 * @return TRUE if configuration is successful, FALSE otherwise.
	 */
	public abstract boolean configure(java.util.Map mapConfigurationSettings)
		throws Exception;
	/***
	 * Return settings created by configure call, or null if not yet configured.
	 */
	public abstract java.util.Map getSettings() throws Exception;
	
	/**
	 * Commits any updates made to the settings created by the configure() call.
	 */
	public abstract void applyUpdates() throws Exception;
	
	/**
	 * Returns the global setting descriptor created by the configure call. 
	 */
	public abstract ISettingDescriptor getSettingDescriptor() throws Exception;
	
	/**
	 * Sets the global settings map. This is typically used when a new handler is
	 * created specifically for writing back settings to a new configuration file.
	 */
	public abstract void setGlobalSettings(java.util.Map settings) throws Exception;
	
	/**
	 * Sets the global setting descriptor. Typically used when a new handler is 
	 * created specifically for writing back settings to a new configuration file. 
	 * @param settingDescriptor
	 * @throws Exception
	 */
	public abstract void setGlobalSettingDescriptor(ISettingDescriptor settingDescriptor) throws Exception;
}
