/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Greg Byrd (IBM Corporation) -- initial definition
 *    Rajalakshmi Iyer (IBM)
 *******************************************************************************/

package org.eclipse.higgins.configuration.api;

import java.util.List;

public interface ISettingDescriptor {
	public String getName();
	public String getType();
	public String getDisplayString();
	public String getDocString();
	public List getSubSettings();
	public Object getConstraint(String key);
	
	public void setName(String name);
	public void setType(String type);
	public void setDisplayString(String display);
	public void setDocString(String doc);
		
	public void addConstraint(String name, Object value);
	public void removeConstraint(String name);
	
	public void addSubSetting(ISettingDescriptor sub);
	public void addSubSetting(int index, ISettingDescriptor sub);
	public ISettingDescriptor addSubSetting(String name, String type);
	public boolean removeSubSetting(ISettingDescriptor sub);
	public ISettingDescriptor removeSubSetting(int index);
	public ISettingDescriptor getSubSetting(String settingName);
	public ISettingDescriptor getSubSetting(int index);
}
