/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.configuration.common;

import java.lang.reflect.Method;
import org.eclipse.higgins.configuration.api.IConfigurableComponent;
import org.eclipse.higgins.configuration.api.IConfigurableComponentFactory;

public class ConfigurableComponentFactoryHelper {
    public static IConfigurableComponent getInstanceFromClassName(String className) throws Exception {
        Class theClass = ConfigurableComponentFactoryHelper.getClassByName(className);
        Object theObject = theClass.newInstance();
        IConfigurableComponent theConfigurableComponent = (IConfigurableComponent)theObject;
        return theConfigurableComponent;
    }

    public static IConfigurableComponent getSingletonFromClassName(String className) throws Exception {
        Class theClass = ConfigurableComponentFactoryHelper.getClassByName(className);
        Method theMethod = theClass.getMethod("getInstance", new Class[0]);
        Object theObject = theMethod.invoke(null, (Object[])new Class[0]);
        IConfigurableComponent theConfigurableComponent = (IConfigurableComponent)theObject;
        return theConfigurableComponent;
    }

    public static IConfigurableComponent getSingletonFromFactory(String factoryClassName) throws Exception {
        Class factoryClass = ConfigurableComponentFactoryHelper.getClassByName(factoryClassName);
        Object objectFactory = factoryClass.newInstance();
        IConfigurableComponentFactory factory = (IConfigurableComponentFactory)objectFactory;
        return factory.getSingletonInstance();
    }

    public static IConfigurableComponent getFromFactory(String factoryClassName) throws Exception {
        Class factoryClass = ConfigurableComponentFactoryHelper.getClassByName(factoryClassName);
        Object objectFactory = factoryClass.newInstance();
        IConfigurableComponentFactory factory = (IConfigurableComponentFactory)objectFactory;
        return factory.getNewInstance();
    }

    private static Class getClassByName(String factoryClassName) throws Exception {
        ClassLoader classLoader = null;
        Exception throw1 = null;
        Class<?> factoryClass = null;
        try {
            factoryClass = Class.forName(factoryClassName);
        }
        catch (Exception e) {
            throw1 = e;
        }
        if (factoryClass == null && (classLoader = Thread.currentThread().getContextClassLoader()) != null) {
            try {
                factoryClass = classLoader.loadClass(factoryClassName);
            }
            catch (Exception e) {
                if (throw1 != null) {
                    throw throw1;
                }
                throw e;
            }
        }
        return factoryClass;
    }
}

