/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.configuration.common;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;

public class SettingDescriptor
implements ISettingDescriptor {
    private String _name;
    private Class _type;
    private String _displayString;
    private String _docString;
    private Map _constraints;
    private Vector _subSettings;
    public static final String CONSTRAINT_MIN_VALUE_STRING = "minValue";
    public static final String CONSTRAINT_MAX_VALUE_STRING = "maxValue";
    public static final String CONSTRAINT_DEFAULT_VALUE_STRING = "defaultValue";
    public static final String CONSTRAINT_MIN_WIDTH_STRING = "minWidth";
    public static final String CONSTRAINT_MAX_WIDTH_STRING = "maxWidth";
    public static final String CONSTRAINT_REQUIRED_STRING = "required";
    public static final String CONSTRAINT_MIN_ELEMENTS_STRING = "minElements";
    public static final String CONSTRAINT_MAX_ELEMENTS_STRING = "maxElements";
    public static final String CONSTRAINT_ELEMENT_TYPE_STRING = "elementType";
    public static final String CONSTRAINT_CONFIGURABLE_STRING = "configurable";
    public static final String CONSTRAINT_SINGLETON_STRING = "singleton";

    public SettingDescriptor(String name, Class type, String displayString, String docString) {
        this._name = name;
        this._type = type;
        this._displayString = displayString;
        this._docString = docString;
        this._constraints = new HashMap();
        this._subSettings = null;
    }

    public SettingDescriptor() {
        this._name = null;
        this._type = null;
        this._displayString = null;
        this._docString = null;
        this._constraints = new HashMap();
        this._subSettings = null;
    }

    public String getName() {
        return this._name;
    }

    public Class getType() {
        return this._type;
    }

    public String getDisplayString() {
        return this._displayString;
    }

    public String getDocString() {
        return this._docString;
    }

    public List getSubSettings() {
        return (List)this._subSettings.clone();
    }

    public Object getConstraint(String key) {
        return this._constraints.get(key);
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setType(Class type) {
        this._type = type;
    }

    public void setDisplayString(String display) {
        this._displayString = display;
    }

    public void setDocString(String doc) {
        this._docString = doc;
    }

    public void addConstraint(String name, Object value) {
        this._constraints.put(name, value);
    }

    public void removeConstraint(String name) {
        this._constraints.remove(name);
    }

    public void addSubSetting(ISettingDescriptor sub) {
        this._subSettings.add(sub);
    }

    public void addSubSetting(int index, ISettingDescriptor sub) {
        this._subSettings.add(index, sub);
    }

    public boolean removeSubSetting(ISettingDescriptor sub) {
        return this._subSettings.remove(sub);
    }

    public ISettingDescriptor removeSubSetting(int index) {
        return (ISettingDescriptor)this._subSettings.remove(index);
    }
}

