/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.configuration.common;

import java.lang.reflect.Method;
import org.eclipse.higgins.configuration.api.IConfigurableComponent;
import org.eclipse.higgins.configuration.api.IConfigurableComponentFactory;
import org.eclipse.higgins.configuration.api.IExtensionHelper;

public class ConfigurableComponentFactoryHelper {
    public static IConfigurableComponent getInstanceFromClassName(String className) throws Exception {
        Class theClass = ConfigurableComponentFactoryHelper.getClassByName(className);
        Object theObject = theClass.newInstance();
        IConfigurableComponent theConfigurableComponent = (IConfigurableComponent)theObject;
        return theConfigurableComponent;
    }

    public static IConfigurableComponent getSingletonFromClassName(String className) throws Exception {
        Class theClass = ConfigurableComponentFactoryHelper.getClassByName(className);
        Method theMethod = theClass.getMethod("getInstance", new Class[0]);
        Object theObject = theMethod.invoke(null, (Object[])new Class[0]);
        IConfigurableComponent theConfigurableComponent = (IConfigurableComponent)theObject;
        return theConfigurableComponent;
    }

    public static IConfigurableComponent getSingletonFromFactory(String factoryClassName) throws Exception {
        Exception exception = null;
        try {
            Class factoryClass = ConfigurableComponentFactoryHelper.getClassByName(factoryClassName);
            Object objectFactory = factoryClass.newInstance();
            IConfigurableComponentFactory factory = (IConfigurableComponentFactory)objectFactory;
            return factory.getSingletonInstance();
        }
        catch (Exception e) {
            exception = e;
            try {
                Class extensionHelperClass = ConfigurableComponentFactoryHelper.getClassByName("org.eclipse.higgins.configuration.common.plugin.ExtensionHelper");
                Object objectFactory = ((IExtensionHelper)extensionHelperClass.newInstance()).getInstanceByExtension("org.eclipse.higgins.configuration.api.componentfactory", factoryClassName, "factoryclassname");
                IConfigurableComponentFactory factory = (IConfigurableComponentFactory)objectFactory;
                return factory.getSingletonInstance();
            }
            catch (Exception e2) {
                System.err.println(exception.getLocalizedMessage());
                exception.printStackTrace();
                System.err.println(e2.getLocalizedMessage());
                e2.printStackTrace();
                return null;
            }
        }
    }

    public static IConfigurableComponent getInstanceFromFactory(String factoryClassName) throws Exception {
        Exception exception = null;
        try {
            Class factoryClass = ConfigurableComponentFactoryHelper.getClassByName(factoryClassName);
            Object objectFactory = factoryClass.newInstance();
            IConfigurableComponentFactory factory = (IConfigurableComponentFactory)objectFactory;
            return factory.getNewInstance();
        }
        catch (Exception e) {
            exception = e;
            try {
                Class extensionHelperClass = ConfigurableComponentFactoryHelper.getClassByName("org.eclipse.higgins.configuration.common.plugin.ExtensionHelper");
                Object objectFactory = ((IExtensionHelper)extensionHelperClass.newInstance()).getInstanceByExtension("org.eclipse.higgins.configuration.api.componentfactory", factoryClassName, "factoryclassname");
                IConfigurableComponentFactory factory = (IConfigurableComponentFactory)objectFactory;
                return factory.getNewInstance();
            }
            catch (Exception e2) {
                System.err.println(exception.getLocalizedMessage());
                exception.printStackTrace();
                System.err.println(e2.getLocalizedMessage());
                e2.printStackTrace();
                return null;
            }
        }
    }

    public static Class getClassByName(String className) throws Exception {
        ClassLoader classLoader = null;
        Exception exception = null;
        Class<?> factoryClass = null;
        try {
            factoryClass = Class.forName(className);
        }
        catch (Exception e) {
            exception = e;
        }
        if (factoryClass == null && (classLoader = Thread.currentThread().getContextClassLoader()) != null) {
            try {
                factoryClass = classLoader.loadClass(className);
            }
            catch (Exception e) {
                if (null != exception) {
                    throw exception;
                }
                throw e;
            }
        }
        return factoryClass;
    }
}

