/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.configuration.common;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.configuration.api.IConfigurationHandler;

public class PropertyFileConfigurationHandler
implements IConfigurationHandler {
    private Map mapGlobalSettings = null;
    private boolean bConfiguring = false;
    private boolean bConfigured = false;
    private final Log log;
    private String strConfigurationBase;
    private String strFileName;
    static /* synthetic */ Class class$0;

    public PropertyFileConfigurationHandler() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.configuration.common.PropertyFileConfigurationHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((String)clazz.getName());
        this.strFileName = "configuration.properties";
    }

    public PropertyFileConfigurationHandler(String fileName) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.configuration.common.PropertyFileConfigurationHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((String)clazz.getName());
        this.strFileName = "configuration.properties";
        this.setFileName(fileName);
    }

    public PropertyFileConfigurationHandler(String configDir, String fileName) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.configuration.common.PropertyFileConfigurationHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((String)clazz.getName());
        this.strFileName = "configuration.properties";
        this.setFileName(fileName);
        this.setConfigurationBase(configDir);
    }

    public Map getSettings() throws Exception {
        return this.mapGlobalSettings;
    }

    public synchronized boolean configure(Map mapConfigurationSettings) throws Exception {
        this.log.trace((Object)"PropertiesConfigurationHandler::configure");
        if (this.bConfigured) {
            this.log.trace((Object)"PropertiesConfigurationHandler::configure Already Configured.");
            return true;
        }
        if (this.bConfiguring) {
            this.log.trace((Object)"ConfigurationHandler::configure Already Configuring.");
            return true;
        }
        this.bConfiguring = true;
        this.log.trace((Object)("ConfigurationBase: " + this.strConfigurationBase));
        this.log.trace((Object)("ConfigurationFile: " + this.strFileName));
        Properties props = new Properties();
        String separator = File.separator;
        File propFile = new File(String.valueOf(this.strConfigurationBase) + separator + this.strFileName);
        if (propFile.exists()) {
            try {
                FileInputStream fileInStream = new FileInputStream(propFile);
                BufferedInputStream inStream = new BufferedInputStream(fileInStream);
                props.load(inStream);
                ((InputStream)inStream).close();
                Enumeration<?> propNames = props.propertyNames();
                while (propNames.hasMoreElements()) {
                    String name = (String)propNames.nextElement();
                    String value = props.getProperty(name);
                    this.mapGlobalSettings.put(name, value);
                }
            }
            catch (IOException iOException) {}
        }
        this.bConfiguring = false;
        this.bConfigured = true;
        return true;
    }

    public void setConfigurationBase(String strBase) {
        this.strConfigurationBase = strBase;
    }

    public void setFileName(String strFile) {
        this.strFileName = strFile;
    }
}

