/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Greg Byrd (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.configuration.common;

import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/**
 * Describes the properties of a setting used to configure a component.
 * (See IConfigurableComponent.)
 * @author gbyrd
 *
 */
public class SettingDescriptor implements ISettingDescriptor {
	private String _name;
	private Class _type;
	private String _displayString;
	private String _docString;
	private Map _constraints;
	private Vector _subSettings;
	
	public SettingDescriptor(String name, Class type, 
								String displayString, String docString)
	{
		_name = name;
		_type = type;
		_displayString = displayString;
		_docString = docString;
		_constraints = new HashMap();
		_subSettings = null;
	}
	public SettingDescriptor() {
		_name = null; 
		_type = null; 
		_displayString = null; 
		_docString = null;
		_constraints = new HashMap();
		_subSettings = null;
	}
	
	public String getName() { return _name; }
	public Class getType() { return _type; }
	public String getDisplayString() { return _displayString; }
	public String getDocString() { return _docString; }
	public List getSubSettings() { return (List)_subSettings.clone(); }	
	public Object getConstraint(String key) {return _constraints.get(key); }
	
	public void setName(String name) { _name = name; }
	public void setType(Class type) { _type = type; }
	public void setDisplayString(String display) { _displayString = display; }
	public void setDocString(String doc) { _docString = doc; }
		
	public void addConstraint(String name, Object value) {
		_constraints.put(name, value);
	}
	public void removeConstraint(String name) {
		_constraints.remove(name);
	}
	
	public void addSubSetting(ISettingDescriptor sub) {
		_subSettings.add(sub);
	}
	public void addSubSetting(int index, ISettingDescriptor sub) {
		_subSettings.add(index, sub);	
	}
	public boolean removeSubSetting(ISettingDescriptor sub) {
		return _subSettings.remove(sub);
	}
	public ISettingDescriptor removeSubSetting(int index) {
		return (ISettingDescriptor)_subSettings.remove(index);
	}
	
	/**
	 * For integer/float settings, minimum allowable value.
	 */
	static final public String CONSTRAINT_MIN_VALUE_STRING = "minValue";
	/**
	 * For integer/float settings, maximum allowable value.
	 */
	static final public String CONSTRAINT_MAX_VALUE_STRING = "maxValue";
	/**
	 * For any setting, default value.
	 */
	static final public String CONSTRAINT_DEFAULT_VALUE_STRING = "defaultValue";
	/**
	 * For string-like settings, minimum width (characters).
	 */
	static final public String CONSTRAINT_MIN_WIDTH_STRING = "minWidth";
	/**
	 * For string-like settings, maximum width (characters).
	 */
	static final public String CONSTRAINT_MAX_WIDTH_STRING = "maxWidth";
	/**
	 * For any setting, set true if setting is required.
	 */
	static final public String CONSTRAINT_REQUIRED_STRING = "required";
	/**
	 * For list/map settings, minimum number of subsettings.
	 */
	static final public String CONSTRAINT_MIN_ELEMENTS_STRING = "minElements";
	/**
	 * For list/map settings, maximum number of subsettings.
	 */
	static final public String CONSTRAINT_MAX_ELEMENTS_STRING = "maxElements";
	/**
	 * For list/map settings, type of subsettings (if not explicitly listed).
	 */
	static final public String CONSTRAINT_ELEMENT_TYPE_STRING = "elementType";
	/**
	 * For object settings, set true if IConfigurableComponent.
	 */
	static final public String CONSTRAINT_CONFIGURABLE_STRING = "configurable";
	/**
	 * For component settings, set true if should be created as a singleton.
	 */
	static final public String CONSTRAINT_SINGLETON_STRING = "singleton";
	
}

