/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Peter Kimlach - initial API and implementation
 */
package org.eclipse.higgins.configuration.common.plugin;

import org.eclipse.higgins.configuration.api.IExtensionHelper;

public class ExtensionHelper implements IExtensionHelper {

	public Object getInstanceByExtension(
			final String extensionPointName, final String extensionName, final String executableExtensionName)
			throws Exception {
		org.eclipse.core.runtime.IExtensionPoint extensionPoint = org.eclipse.core.runtime.Platform
				.getExtensionRegistry().getExtensionPoint(extensionPointName);
		org.eclipse.core.runtime.IExtension extension = extensionPoint
				.getExtension(extensionName);
		org.eclipse.core.runtime.IConfigurationElement[] configurationElements = extension
				.getConfigurationElements();
		org.eclipse.core.runtime.IConfigurationElement component = configurationElements[0];
		Object instance = component
				.createExecutableExtension(executableExtensionName);
		return instance;
	}
}
