/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.configuration.common;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;

public class SettingDescriptor
implements ISettingDescriptor {
    private String _name;
    private String _type;
    private String _displayString;
    private String _docString;
    private Map _constraints;
    private Vector _subSettings;
    public static final String CONSTRAINT_MIN_VALUE_STRING = "minValue";
    public static final String CONSTRAINT_MAX_VALUE_STRING = "maxValue";
    public static final String CONSTRAINT_DEFAULT_VALUE_STRING = "defaultValue";
    public static final String CONSTRAINT_MIN_WIDTH_STRING = "minWidth";
    public static final String CONSTRAINT_MAX_WIDTH_STRING = "maxWidth";
    public static final String CONSTRAINT_REQUIRED_STRING = "required";
    public static final String CONSTRAINT_MIN_ELEMENTS_STRING = "minElements";
    public static final String CONSTRAINT_MAX_ELEMENTS_STRING = "maxElements";
    public static final String CONSTRAINT_ELEMENT_TYPE_STRING = "elementType";
    public static final String CONSTRAINT_CONFIGURABLE_STRING = "configurable";
    public static final String CONSTRAINT_SINGLETON_STRING = "singleton";

    public SettingDescriptor(String name, String type) {
        this._name = name;
        this._type = type;
        this._subSettings = null;
        this._displayString = null;
        this._docString = null;
        this._constraints = null;
    }

    public SettingDescriptor() {
        this._name = null;
        this._type = null;
        this._subSettings = null;
        this._displayString = null;
        this._docString = null;
        this._constraints = null;
    }

    public String getName() {
        return this._name;
    }

    public String getType() {
        return this._type;
    }

    public String getDisplayString() {
        return this._displayString;
    }

    public String getDocString() {
        return this._docString;
    }

    public List getSubSettings() {
        return (List)this._subSettings.clone();
    }

    public Object getConstraint(String key) {
        return null;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setType(String type) {
        this._type = type;
    }

    public void setDisplayString(String display) {
    }

    public void setDocString(String doc) {
    }

    public void addConstraint(String name, Object value) {
    }

    public void removeConstraint(String name) {
    }

    public ISettingDescriptor getSubSetting(String settingName) {
        if (this._subSettings == null || settingName == null) {
            return null;
        }
        Iterator itr = this._subSettings.iterator();
        while (itr.hasNext()) {
            ISettingDescriptor settingDescriptor = (ISettingDescriptor)itr.next();
            if (!settingName.equals(settingDescriptor.getName())) continue;
            return settingDescriptor;
        }
        return null;
    }

    public ISettingDescriptor getSubSetting(int index) {
        if (this._subSettings == null) {
            return null;
        }
        return (ISettingDescriptor)this._subSettings.get(index);
    }

    public ISettingDescriptor addSubSetting(String name, String type) {
        SettingDescriptor childDescriptor = new SettingDescriptor(name, type);
        this.addSubSetting(childDescriptor);
        return childDescriptor;
    }

    public void addSubSetting(ISettingDescriptor sub) {
        if (this._subSettings == null) {
            this._subSettings = new Vector();
        }
        this._subSettings.add(sub);
    }

    public void addSubSetting(int index, ISettingDescriptor sub) {
        if (this._subSettings == null) {
            this._subSettings = new Vector();
        }
        this._subSettings.add(index, sub);
    }

    public boolean removeSubSetting(ISettingDescriptor sub) {
        if (this._subSettings == null || !this._subSettings.contains(sub)) {
            return false;
        }
        return this._subSettings.remove(sub);
    }

    public ISettingDescriptor removeSubSetting(int index) {
        if (this._subSettings == null || index > this._subSettings.size()) {
            return null;
        }
        return (ISettingDescriptor)this._subSettings.remove(index);
    }
}

