/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) 
 *******************************************************************************/ 

package org.eclipse.higgins.configuration.xml;


/**
 * Reads string data from setting.
 * 
 * @author mikemci
 *
 */
public class StringHandler implements ISettingHandler
{
	static private final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog
		(StringHandler.class.getName());

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.configuration.xml.ISettingHandler#getSetting(org.w3c.dom.Element)
	 */
	public Object getSetting
		(String strName,
		String strConfigurationBase,
		java.util.Map mapSettingHandlers,
		java.util.Map mapSettingsGlobal,
		Object settingsParent,
		org.apache.axiom.om.OMElement omSetting)
	{
		String strValue = omSetting.getText();
		/****** Mask password out of trace ******/
		if (log.isTraceEnabled()) {
			String tempStr = strValue.toLowerCase();
			if (tempStr.indexOf("password") != -1) {
				// If strValue contains the substring "password"
				//   hide the value
				log.trace("Setting Name: " + strName + " Value: XXX");
			}
			else {
				log.trace("Setting Name: " + strName + " Value: " + strValue);
			}
		}
		/***************************************/
		return strValue;
	}

}
