/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial generation from WSDL using WSDL2Java
 *******************************************************************************/ 

package org.eclipse.higgins.configuration.xml;

import org.eclipse.higgins.configuration.api.IConfigurationHandler;


/**
 * @author mikemci at us dot ibm dot com
 */
// TODO: Find out when ConfigurationHandler instances are instantiated (singleton? instance per request? other?)

public class ConfigurationHandler implements IConfigurationHandler
{
	private java.util.Map mapGlobalSettings = null;

	private boolean bConfiguring = false;

	private boolean bConfigured = false;
	
	static private final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog
		(ConfigurationHandler.class.getName());
	
	private String strConfigurationBase;
	private String strFileName = "Configuration.xml";
	
	public java.util.Map getSettings() throws Exception
	{
		return mapGlobalSettings;
	}
	
	public void setConfigurationBase(String strBase) {
		strConfigurationBase = strBase;
	}
	
	public void setFileName(String strFile) {
		strFileName = strFile;
	}
	
	public static org.apache.axiom.om.OMElement toOM
		(String strElement)
		throws Exception
	{
	    java.io.ByteArrayInputStream inputStream = new java.io.ByteArrayInputStream
			(strElement.getBytes());
	    javax.xml.stream.XMLInputFactory xif = javax.xml.stream.XMLInputFactory.newInstance();
	    javax.xml.stream.XMLStreamReader reader = xif.createXMLStreamReader
	    	(inputStream);
	    org.apache.axiom.om.impl.builder.StAXOMBuilder builder = new org.apache.axiom.om.impl.builder.StAXOMBuilder
	    	(reader);
	    return builder.getDocumentElement();
	}

	public static org.apache.axiom.om.OMElement omFromFile
		(String strFileName)
		throws java.io.FileNotFoundException,
			Exception
	{
	    java.io.FileInputStream inputStream = null;
	    try
	    {
	    	inputStream = new java.io.FileInputStream
	    		(strFileName);
	    }
	    catch (java.io.FileNotFoundException fnfe)
	    {
			log.error(fnfe);
			throw fnfe;
	    }
	    return omFromStream(inputStream);
	}

	public static org.apache.axiom.om.OMElement omFromStream
		(java.io.InputStream inputStream)
		throws java.io.FileNotFoundException,
			Exception
	{
	    javax.xml.stream.XMLInputFactory xif = javax.xml.stream.XMLInputFactory.newInstance();
	    javax.xml.stream.XMLStreamReader reader = xif.createXMLStreamReader
	    	(inputStream);
	    org.apache.axiom.om.impl.builder.StAXOMBuilder builder = new org.apache.axiom.om.impl.builder.StAXOMBuilder
	    	(reader);
	    return builder.getDocumentElement();
	}
	
	/**
	 * Constructor that initializes the class
	 */
	public ConfigurationHandler()
	{
		log.trace("ConfigurationHandler::ConfigurationHandler");
	}
	
	private java.util.Iterator getConfigurationElementIterator
		(org.apache.axiom.om.OMElement omParent,
		String strElementName) throws Exception
	{
		log.trace("ConfigurationHandler::getConfigurationElementIterator: " + strElementName);
		if (null == strElementName)
			throw new Exception
				("getConfigurationElementIterator ElementName is null");
		final javax.xml.namespace.QName qnameElement = new javax.xml.namespace.QName
			(null,
			strElementName);
		java.util.Iterator iterResult = omParent.getChildrenWithName
			(qnameElement);
		if (null == iterResult)
			throw new Exception
				("ConfigurationHandler::getConfigurationElementIterator ElementName " + strElementName + " Result is null");
		return iterResult;
	}

	private org.apache.axiom.om.OMElement getConfigurationElement
		(org.apache.axiom.om.OMElement omParent,
		String strElementName) throws Exception
	{
		log.trace("ConfigurationHandler::getConfigurationElement: " + strElementName);
		if (null == strElementName)
			throw new Exception
				("ConfigurationHandler::getConfigurationElement ElementName is null");
		org.apache.axiom.om.OMElement omElement = null;
		java.util.Iterator iterElement = getConfigurationElementIterator
			(omParent,
			strElementName);
		if (!iterElement.hasNext())
		{
			throw new Exception
				("ConfigurationHandler::getConfigurationElement " + strElementName + " Result is null");
		}
		omElement = (org.apache.axiom.om.OMElement)iterElement.next();
		if (iterElement.hasNext())
		{
			throw new Exception("ConfigurationHandler::getConfigurationElement " + strElementName + " found more than one element");
		}
		return omElement;
	}

	public synchronized boolean configure
		(java.util.Map mapConfigurationSettings)
		throws Exception
	{
		log.trace("ConfigurationHandler::configure");
	
		if (bConfigured)
		{
			log.trace("ConfigurationHandler::configure Already Configured.");
			return true;
		}
		
		log.trace("ConfigurationBase: " + strConfigurationBase);
		
		org.apache.axiom.om.OMElement omConfiguration = null;
		try
		{
			omConfiguration = omFromFile
				(strConfigurationBase + "/" + strFileName);
		}
		catch (Exception e)
		{
			log.error(e.getLocalizedMessage());
			throw e;
		}
		return configure(omConfiguration, mapConfigurationSettings);
	}
	
	public synchronized boolean configure
		(String strConfiguration,
		java.util.Map mapConfigurationSettings)
		throws Exception
	{
		log.trace("ConfigurationHandler::configure");
		
		if (bConfigured)
		{
			log.trace("ConfigurationHandler::configure Already Configured.");
			return true;
		}
		
		log.trace("ConfigurationBase: " + strConfigurationBase);
		
		
		org.apache.axiom.om.OMElement omConfiguration = null;
		try
		{
			omConfiguration = toOM
				(strConfiguration);
		}
		catch (Exception e)
		{
			log.error(e.getLocalizedMessage());
			throw e;
		}
		return configure(omConfiguration, mapConfigurationSettings);
	}
	
	public synchronized boolean configure
		(org.apache.axiom.om.OMElement omConfiguration,
		java.util.Map mapConfigurationSettings)
		throws Exception
	{	
		log.trace("ConfigurationHandler::configure");
		
		if (bConfigured)
		{
			log.trace("ConfigurationHandler::configure Already Configured.");
			return true;
		}

		if (bConfiguring)
		{
			log.trace("ConfigurationHandler::configure Already Configuring.");
			return true;
		}
		
		bConfiguring = true;
		
		log.trace("ConfigurationBase: " + strConfigurationBase);
	
		//constants = new org.eclipse.higgins.sts.impl.Constants();
		javax.xml.namespace.QName qnameType = new javax.xml.namespace.QName
			(null,
			"Type");
		javax.xml.namespace.QName qnameHandler = new javax.xml.namespace.QName
			(null,
			"Handler");
		java.util.Map mapSettingHandlers = new java.util.Hashtable();
		org.apache.axiom.om.OMElement omSettingHandlers = getConfigurationElement
			(omConfiguration,
			"SettingHandlers");
		if (null == omSettingHandlers)
		{
			throw new Exception("SettingHandlers element not found in configuration file.");
		}
		java.util.Iterator iterSettingHandler = getConfigurationElementIterator
			(omSettingHandlers,
			"SettingHandler");
		while (iterSettingHandler.hasNext())
		{
			org.apache.axiom.om.OMElement omSettingHandler = (org.apache.axiom.om.OMElement)iterSettingHandler.next();
			String strType = omSettingHandler.getAttributeValue(qnameType);
			String strHandler = omSettingHandler.getAttributeValue(qnameHandler);
			log.trace("Registering SettingHandler Type: " + strType + " Handler: " + strHandler);
			try
			{
				Class classHandler = Class.forName(strHandler);
				Object objectHandler = classHandler.newInstance();
				mapSettingHandlers.put(strType, objectHandler);
			}
			catch (Exception e)
			{
				log.error(e.getLocalizedMessage());
				throw e;
			}
		}
		org.apache.axiom.om.OMElement omSetting = getConfigurationElement
			(omConfiguration,
			"Setting");
		if (null == omSetting)
		{
			throw new Exception("Setting element not found in configuration file.");
		}
		
		org.eclipse.higgins.configuration.xml.MapHandler mapHandler = new org.eclipse.higgins.configuration.xml.MapHandler();
		mapGlobalSettings = new java.util.Hashtable();
		try
		{
			mapGlobalSettings = (java.util.Map)mapHandler.getSetting
				("Configuration",
				strConfigurationBase,
				mapSettingHandlers,
				null,
				null,
				omSetting);
		}
		catch (Exception e)
		{
			log.error(e.getLocalizedMessage());
			throw e;
		}
		
		bConfigured = true;
		bConfiguring = false;
		
		log.trace("ConfigurationHandler::configure DONE");
		
		return true;
	}
}