/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) 
 *******************************************************************************/ 

package org.eclipse.higgins.configuration.xml;

import java.util.Map;


/**
 * Creates an instance of an IConfigurableComponent, using factory.
 * Gets component settings from mapSettings.  Configures component.
 * 
 * @author mikemci
 *
 */
public class InstanceHandler implements ISettingHandler
{
	static private final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog
		(InstanceHandler.class.getName());

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.configuration.xml.SettingHandler#getSetting(java.lang.String, java.util.Map, java.util.Map, org.w3c.dom.Element)
	 */
	public Object getSetting
		(String strName,
		String strConfigurationBase,
		Map mapSettingHandlers,
		Map mapSettingsGlobal,
		Object settingsParent,
		org.apache.axiom.om.OMElement omSetting)
		throws Exception
	{
		String strValue = omSetting.getText();
		log.trace("Setting Name: " + strName + " Value: " + strValue);
		
		org.eclipse.higgins.configuration.api.IConfigurableComponent component = org.eclipse.higgins.configuration.common.ConfigurableComponentFactoryHelper.getFromFactory
			(strValue);
		
		// We used to get component settings from "ComponentSettings"
		// at the root level of the global map:
		// Map mapComponentSettings = (Map)mapSettingsGlobal.get("ComponentSettings");
		//
		// Now we get it from "ComponentSettings" in the parent map.
		// Must verify that the parent is a map, first.  If it isn't, we'll
		// fall back on the original method (global "ComponentSettings").
		
		boolean isMap = false;
		Map mapComponentSettings = null;
		Class interfaces[] = settingsParent.getClass().getInterfaces();
		for (int j=0; j<interfaces.length; j++) {
			if (interfaces[j] == Class.forName("java.util.Map")) {
				isMap = true; 
				break;  // no need to look further
			}
		}		
		if (isMap) {
			mapComponentSettings = (Map)((Map)settingsParent).get("ComponentSettings");
		}
		else {
			mapComponentSettings = (Map)mapSettingsGlobal.get("ComponentSettings");
		}
				
		Map mapComponentSetting = (Map)mapComponentSettings.get(strName);		
		component.configure(mapSettingsGlobal, strName, mapComponentSetting);
		
		return component;

	}
}
