/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.configuration.xml;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.configuration.xml.ISettingHandler;
import org.eclipse.higgins.messages.utilities.MsgHelper;

public class MapHandler
implements ISettingHandler {
    private static final Log log;
    private final QName qnameName = new QName(null, "Name");
    private final QName qnameType = new QName(null, "Type");
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.configuration.xml.MapHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    public Object getSetting(String strName, String strConfigurationBase, Map mapSettingHandlers, Map mapSettingsGlobal, Object settingsParent, OMElement omSetting) throws Exception {
        log.trace((Object)("Setting Name: " + strName + " *Begin Map*"));
        Hashtable<String, Object> mapResult = new Hashtable<String, Object>();
        Hashtable<String, Object> mapGlobal = mapSettingsGlobal;
        if (mapGlobal == null) {
            mapGlobal = mapResult;
        }
        boolean parentIsMap = false;
        boolean parentIsList = false;
        if (settingsParent != null) {
            Class<?>[] interfaces = settingsParent.getClass().getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                if (interfaces[i] == Class.forName("java.util.Map")) {
                    parentIsMap = true;
                }
                if (interfaces[i] == Class.forName("java.util.List")) {
                    parentIsList = true;
                }
                ++i;
            }
            if (parentIsMap) {
                ((Map)settingsParent).put(strName, mapResult);
            } else if (parentIsList) {
                ((List)settingsParent).add(mapResult);
            }
        }
        Iterator iterChildren = omSetting.getChildElements();
        while (iterChildren.hasNext()) {
            OMElement omChild = (OMElement)iterChildren.next();
            String strSettingName = omChild.getAttributeValue(this.qnameName);
            String strSettingType = omChild.getAttributeValue(this.qnameType);
            ISettingHandler handler = (ISettingHandler)mapSettingHandlers.get(strSettingType);
            if (handler == null) {
                String errMsg = MsgHelper.getString((String)"settinghandler_not_found_for_type", (Object)strSettingType);
                log.error((Object)errMsg);
                throw new Exception(errMsg);
            }
            Object objectValue = handler.getSetting(strSettingName, strConfigurationBase, mapSettingHandlers, mapGlobal, mapResult, omChild);
            log.trace((Object)("Adding Map Entry for Name: " + strSettingName));
            mapResult.put(strSettingName, objectValue);
        }
        if (parentIsList) {
            ((List)settingsParent).remove(mapResult);
        }
        log.trace((Object)("Setting Name: " + strName + " *End Map*"));
        return mapResult;
    }
}

