/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) 
 *******************************************************************************/ 

package org.eclipse.higgins.configuration.xml;

import java.security.cert.X509Certificate;
import java.util.Map;


/**
 * Certificate setting is a map that contains keystore name and alias.
 * Keystore is looked up (by name) in mapSettings.  Alias is then used
 * to retrieve X.509 certificate from keystore.
 * 
 * @author mikemci
 *
 */
public class CertificateHandler extends MapHandler
{
	private final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog
		(CertificateHandler.class.getName());

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.configuration.xml.ISettingHandler#getSetting(java.lang.String, java.util.Map, java.util.Map, org.w3c.dom.Element)
	 */
	public Object getSetting
		(String strName,
		String strConfigurationBase,
		Map mapSettingHandlers,
		Map mapSettingsGlobal,
		Object settingsParent,
		org.apache.axiom.om.OMElement omSetting)
		throws Exception
	{
		log.trace("Setting Name: " + strName + " *Begin Certificate*");

		Map mapPrivateKeySettings = (Map)super.getSetting
			(strName,
			strConfigurationBase,
			mapSettingHandlers,
			mapSettingsGlobal,
			settingsParent,
			omSetting);
		
		String strKeyStoreName = (String)mapPrivateKeySettings.get
			("KeyStoreName");
		String strAlias = (String)mapPrivateKeySettings.get
			("Alias");
		
		// Note:  For this implementation, the keystore must be at
		// the same settings level as the Certificate, and containing
		// object (settingsParent) must be a Map.
		Map mapSettingsParent = (Map) settingsParent;
		java.security.KeyStore keyStore = (java.security.KeyStore)mapSettingsParent.get
			(strKeyStoreName);
		
		X509Certificate certificate = (X509Certificate)keyStore.getCertificate
			(strAlias);
		log.trace("Setting Name: " + strName + " *End Certificate*");
		return certificate;
	}
}
