/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) 
 *******************************************************************************/ 

package org.eclipse.higgins.configuration.xml;

import java.util.Map;

import org.eclipse.higgins.messages.utilities.MsgHelper;

/**
 * Reads multiple enclosed settings (which may be of different types),
 * and returns as list.
 * 
 * @author mikemci
 *
 */
public class ListHandler implements ISettingHandler
{
	static private final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog
		(ListHandler.class.getName());

	private final javax.xml.namespace.QName qnameName = new javax.xml.namespace.QName
		(null,
		"Name");
	
	private final javax.xml.namespace.QName qnameType = new javax.xml.namespace.QName
		(null,
		"Type");
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.configuration.xml.ISettingHandler#getSetting(java.lang.String, java.util.Map, java.util.Map, org.w3c.dom.Element)
	 */
	public Object getSetting
		(String strName,
		String strConfigurationBase,
		Map mapSettingHandlers,
		Map mapSettingsGlobal,
		Object settingsParent,
		org.apache.axiom.om.OMElement omSetting)
		throws Exception
	{	
		log.trace("Setting Name: " + strName + " *Begin List*");
		java.util.List listResult = new java.util.ArrayList();
		
		// add list to parent, so that it is visible in global settings
		// parent could be List or Map
		boolean parentIsMap = false;
		boolean parentIsList = false;
		if (settingsParent != null) {
			Class [] interfaces = settingsParent.getClass().getInterfaces();


			for (int i=0; i<interfaces.length; i++) {
				if (interfaces[i] == Class.forName("java.util.Map")) {
					parentIsMap = true;
				}
				if (interfaces[i] == Class.forName("java.util.List")) {
					parentIsList = true;
				}
			}
			if (parentIsMap) ((java.util.Map)settingsParent).put(strName, listResult);
			else if (parentIsList) ((java.util.List)settingsParent).add(listResult);
		}
		
		java.util.Iterator iterChildren = omSetting.getChildElements();
		while (iterChildren.hasNext())
		{
			org.apache.axiom.om.OMElement omChild = (org.apache.axiom.om.OMElement)iterChildren.next();
			String strSettingName = omChild.getAttributeValue(qnameName);
			String strSettingType = omChild.getAttributeValue(qnameType);
			ISettingHandler handler = (ISettingHandler)mapSettingHandlers.get
				(strSettingType);
			if (null == handler)
			{
				String errMsg = MsgHelper.getString(MsgHelper.settinghandler_not_found_for_type, strSettingType);
				log.error(errMsg);
				throw new Exception(errMsg);
			}
			Object objectValue = handler.getSetting
				(strSettingName,
				strConfigurationBase,
				mapSettingHandlers,
				mapSettingsGlobal,
				listResult,
				omChild);
			listResult.add(objectValue);
		}
		// because this return value will be added to the parent by its handler,
		// need to remove if parent is List, so that it doesn't get added twice
		// (for Map, adding again will just replace)
		if (parentIsList) {
			((java.util.List)settingsParent).remove(listResult);
		}

		log.trace("Setting Name: " + strName + " *End List*");
		return listResult;
	}
}
