/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) 
 *******************************************************************************/ 

package org.eclipse.higgins.configuration.xml;


/**
 * Reads a boolean value from the configuration file.
 * 
 * @author mikemci
 *
 */
public class BooleanHandler implements ISettingHandler
{
	private final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog
		(BooleanHandler.class.getName());

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.configuration.xml.ISettingHandler#getSetting(org.w3c.dom.Element)
	 */
	public Object getSetting
		(String strName,
		String strConfigurationBase,
		java.util.Map mapSettingHandlers,
		java.util.Map mapSettingsGlobal,
		Object settingsParent,
		org.apache.axiom.om.OMElement omSetting)
	{
		String strValue = omSetting.getText();
		log.trace("Setting Name: " + strName + " Value: " + strValue);
		return new java.lang.Boolean(strValue);
	}

}
