/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.configuration.xml;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.configuration.api.IConfigurationHandler;
import org.eclipse.higgins.configuration.api.IExtensionHelper;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.configuration.common.ConfigurableComponentFactoryHelper;
import org.eclipse.higgins.configuration.xml.MapHandler;

public class ConfigurationHandler
implements IConfigurationHandler {
    private Map mapGlobalSettings = null;
    private ISettingDescriptor _globalSettingDescriptor = null;
    private OMElement _omSettingHandlers = null;
    private boolean bConfiguring = false;
    private boolean bConfigured = false;
    private static final Log log = LogFactory.getLog((String)(class$org$eclipse$higgins$configuration$xml$ConfigurationHandler == null ? (class$org$eclipse$higgins$configuration$xml$ConfigurationHandler = ConfigurationHandler.class$("org.eclipse.higgins.configuration.xml.ConfigurationHandler")) : class$org$eclipse$higgins$configuration$xml$ConfigurationHandler).getName());
    private String strConfigurationBase;
    private String strFileName = "Configuration.xml";
    static /* synthetic */ Class class$org$eclipse$higgins$configuration$xml$ConfigurationHandler;

    public Map getSettings() throws Exception {
        return this.mapGlobalSettings;
    }

    public ISettingDescriptor getSettingDescriptor() throws Exception {
        return this._globalSettingDescriptor;
    }

    public void setConfigurationBase(String strBase) {
        this.strConfigurationBase = strBase;
    }

    public void setFileName(String strFile) {
        this.strFileName = strFile;
    }

    private OMElement addSetting(OMElement parent, String settingName, String settingType) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement child = factory.createOMElement("Setting", null);
        child.addAttribute("Name", settingName, null);
        child.addAttribute("Type", settingType, null);
        parent.addChild((OMNode)child);
        return child;
    }

    private OMElement addSetting(OMElement parent, ISettingDescriptor settingDescriptor, Object settingValue) {
        String settingType = settingDescriptor.getType();
        String settingName = settingDescriptor.getName();
        OMElement child = this.addSetting(parent, settingName, settingType);
        if (settingType.equalsIgnoreCase("htf:map")) {
            Map settingMap = (Map)settingValue;
            Iterator itr = settingMap.keySet().iterator();
            while (itr.hasNext()) {
                String subSettingName = itr.next().toString();
                this.addSetting(child, settingDescriptor.getSubSetting(subSettingName), settingMap.get(subSettingName));
            }
        } else if (settingType.equalsIgnoreCase("htf:list")) {
            List settingList = (List)settingValue;
            for (int i = 0; i < settingList.size(); ++i) {
                this.addSetting(child, settingDescriptor.getSubSetting(i), settingList.get(i));
            }
        } else if (settingType.equalsIgnoreCase("htf:classinstance") || settingType.equalsIgnoreCase("htf:classsingleton") || settingType.equalsIgnoreCase("htf:instance") || settingType.equalsIgnoreCase("htf:singleton")) {
            child.setText(settingValue.getClass().getName());
        } else if (settingType.equalsIgnoreCase("xsd:string")) {
            child.setText(settingValue.toString());
        } else if (settingType.equalsIgnoreCase("htf:jscriptexec")) {
            OMFactory factory = OMAbstractFactory.getOMFactory();
            factory.createOMText((OMContainer)child, settingValue.toString(), 12);
        }
        return child;
    }

    public void applyUpdates() throws Exception {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace htfNamespace = factory.createOMNamespace("http://higgins.eclipse.org/sts/Configuration", "htf");
        OMNamespace xsdNamespace = factory.createOMNamespace("http://www.w3.org/2001/XMLSchema", "xsd");
        OMElement omConfig = factory.createOMElement("Configuration", null);
        omConfig.declareNamespace(htfNamespace);
        omConfig.declareNamespace(xsdNamespace);
        omConfig.addAttribute("xsd:schemaLocation", "http://higgins.eclipse.org/sts/Configuration Configuration.xsd", null);
        omConfig.addChild((OMNode)this._omSettingHandlers);
        OMElement omDeployConfig = this.addSetting(omConfig, "DeploymentConfiguration", "htf:map");
        this.addSetting(omDeployConfig, this._globalSettingDescriptor.getSubSetting("ComponentSettings"), this.mapGlobalSettings.get("ComponentSettings"));
        Iterator itr = this.mapGlobalSettings.keySet().iterator();
        while (itr.hasNext()) {
            String settingName = itr.next().toString();
            if (settingName.equalsIgnoreCase("ComponentSettings")) continue;
            this.addSetting(omDeployConfig, this._globalSettingDescriptor.getSubSetting(settingName), this.mapGlobalSettings.get(settingName));
        }
        ConfigurationHandler.omToFile(this.strConfigurationBase + "/" + this.strFileName, omConfig);
    }

    public static OMElement toOM(String strElement) throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(strElement.getBytes());
        XMLInputFactory xif = XMLInputFactory.newInstance();
        xif.setProperty("javax.xml.stream.isCoalescing", new Boolean(true));
        XMLStreamReader reader = xif.createXMLStreamReader(inputStream);
        StAXOMBuilder builder = new StAXOMBuilder(reader);
        return builder.getDocumentElement();
    }

    public static OMElement omFromFile(String strFileName) throws FileNotFoundException, Exception {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(strFileName);
        }
        catch (FileNotFoundException fnfe) {
            log.error((Object)fnfe);
            throw fnfe;
        }
        return ConfigurationHandler.omFromStream(inputStream);
    }

    public static void omToFile(String strFileName, OMElement omElement) throws Exception {
        FileOutputStream outputStream = null;
        outputStream = new FileOutputStream(strFileName);
        ConfigurationHandler.omToStream(outputStream, omElement);
    }

    public static void omToStream(FileOutputStream outputStream, OMElement omElement) throws Exception {
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = xof.createXMLStreamWriter(outputStream);
        omElement.serialize(writer);
    }

    public static OMElement omFromStream(InputStream inputStream) throws FileNotFoundException, Exception {
        XMLInputFactory xif = XMLInputFactory.newInstance();
        xif.setProperty("javax.xml.stream.isCoalescing", new Boolean(true));
        XMLStreamReader reader = xif.createXMLStreamReader(inputStream);
        StAXOMBuilder builder = new StAXOMBuilder(reader);
        return builder.getDocumentElement();
    }

    public ConfigurationHandler() {
        log.trace((Object)"ConfigurationHandler::ConfigurationHandler");
    }

    private Iterator getConfigurationElementIterator(OMElement omParent, String strElementName) throws Exception {
        log.trace((Object)("ConfigurationHandler::getConfigurationElementIterator: " + strElementName));
        if (null == strElementName) {
            throw new Exception("getConfigurationElementIterator ElementName is null");
        }
        QName qnameElement = new QName(null, strElementName);
        Iterator iterResult = omParent.getChildrenWithName(qnameElement);
        if (null == iterResult) {
            throw new Exception("ConfigurationHandler::getConfigurationElementIterator ElementName " + strElementName + " Result is null");
        }
        return iterResult;
    }

    private OMElement getConfigurationElement(OMElement omParent, String strElementName) throws Exception {
        log.trace((Object)("ConfigurationHandler::getConfigurationElement: " + strElementName));
        if (null == strElementName) {
            throw new Exception("ConfigurationHandler::getConfigurationElement ElementName is null");
        }
        OMElement omElement = null;
        Iterator iterElement = this.getConfigurationElementIterator(omParent, strElementName);
        if (!iterElement.hasNext()) {
            throw new Exception("ConfigurationHandler::getConfigurationElement " + strElementName + " Result is null");
        }
        omElement = (OMElement)iterElement.next();
        if (iterElement.hasNext()) {
            throw new Exception("ConfigurationHandler::getConfigurationElement " + strElementName + " found more than one element");
        }
        return omElement;
    }

    public synchronized boolean configure(Map mapConfigurationSettings) throws Exception {
        log.trace((Object)"ConfigurationHandler::configure");
        if (this.bConfigured) {
            log.trace((Object)"ConfigurationHandler::configure Already Configured.");
            return true;
        }
        log.trace((Object)("ConfigurationBase: " + this.strConfigurationBase));
        OMElement omConfiguration = null;
        try {
            omConfiguration = ConfigurationHandler.omFromFile(this.strConfigurationBase + "/" + this.strFileName);
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage());
            throw e;
        }
        return this.configure(omConfiguration, mapConfigurationSettings);
    }

    public synchronized boolean configure(String strConfiguration, Map mapConfigurationSettings) throws Exception {
        log.trace((Object)"ConfigurationHandler::configure");
        if (this.bConfigured) {
            log.trace((Object)"ConfigurationHandler::configure Already Configured.");
            return true;
        }
        log.trace((Object)("ConfigurationBase: " + this.strConfigurationBase));
        OMElement omConfiguration = null;
        try {
            omConfiguration = ConfigurationHandler.toOM(strConfiguration);
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage());
            throw e;
        }
        return this.configure(omConfiguration, mapConfigurationSettings);
    }

    public synchronized boolean configure(OMElement omConfiguration, Map mapConfigurationSettings) throws Exception {
        log.trace((Object)"ConfigurationHandler::configure");
        if (this.bConfigured) {
            log.trace((Object)"ConfigurationHandler::configure Already Configured.");
            return true;
        }
        if (this.bConfiguring) {
            log.trace((Object)"ConfigurationHandler::configure Already Configuring.");
            return true;
        }
        this.bConfiguring = true;
        log.trace((Object)("ConfigurationBase: " + this.strConfigurationBase));
        QName qnameType = new QName(null, "Type");
        QName qnameHandler = new QName(null, "Handler");
        Hashtable<String, Object> mapSettingHandlers = new Hashtable<String, Object>();
        this._omSettingHandlers = this.getConfigurationElement(omConfiguration, "SettingHandlers");
        if (null == this._omSettingHandlers) {
            throw new Exception("SettingHandlers element not found in configuration file.");
        }
        Iterator iterSettingHandler = this.getConfigurationElementIterator(this._omSettingHandlers, "SettingHandler");
        while (iterSettingHandler.hasNext()) {
            OMElement omSettingHandler = (OMElement)iterSettingHandler.next();
            String strType = omSettingHandler.getAttributeValue(qnameType);
            String strHandler = omSettingHandler.getAttributeValue(qnameHandler);
            log.trace((Object)("Registering SettingHandler Type: " + strType + " Handler: " + strHandler));
            try {
                Class<?> classHandler = Class.forName(strHandler);
                Object objectHandler = classHandler.newInstance();
                mapSettingHandlers.put(strType, objectHandler);
            }
            catch (Exception e) {
                try {
                    Class extensionHelperClass = ConfigurableComponentFactoryHelper.getClassByName((String)"org.eclipse.higgins.configuration.common.plugin.ExtensionHelper");
                    Object objectHandler = ((IExtensionHelper)extensionHelperClass.newInstance()).getInstanceByExtension("org.eclipse.higgins.configuration.xml.settingshandler", strHandler, "factoryclassname");
                    mapSettingHandlers.put(strType, objectHandler);
                }
                catch (Exception e2) {
                    log.error((Object)("Exception caught while loading SettingHandler Type: " + strType + " Handler: " + strHandler));
                    log.error((Object)"Eclipse Plugin Error: ");
                    log.error((Object)e2.getLocalizedMessage());
                    log.error((Object)"Java Class Error: ");
                    log.error((Object)e.getLocalizedMessage());
                    throw e;
                }
            }
        }
        OMElement omSetting = this.getConfigurationElement(omConfiguration, "Setting");
        if (null == omSetting) {
            throw new Exception("Setting element not found in configuration file.");
        }
        MapHandler mapHandler = new MapHandler();
        this.mapGlobalSettings = new Hashtable();
        try {
            this.mapGlobalSettings = (Map)mapHandler.getSetting("Configuration", this.strConfigurationBase, mapSettingHandlers, null, null, null, null, omSetting);
            this._globalSettingDescriptor = mapHandler.getGlobalDescriptor();
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage());
            throw e;
        }
        this.bConfigured = true;
        this.bConfiguring = false;
        log.trace((Object)"ConfigurationHandler::configure DONE");
        return true;
    }

    public void setGlobalSettings(Map settings) throws Exception {
        this.mapGlobalSettings = settings;
    }

    public void setGlobalSettingDescriptor(ISettingDescriptor settingDescriptor) throws Exception {
        this._globalSettingDescriptor = settingDescriptor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

