/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Greg Byrd (IBM Corporation) 
 *    Rajalaskhmi Iyer (IBM)
 *******************************************************************************/ 

package org.eclipse.higgins.configuration.xml;

import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.configuration.common.SettingDescriptor;

/**
 * Reads a floating-point value from the configuration file.
 * 
 * @author mikemci
 *
 */
public class FloatHandler implements ISettingHandler
{
	private final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog
		(FloatHandler.class.getName());

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.configuration.xml.ISettingHandler#getSetting(org.w3c.dom.Element)
	 */
	public Object getSetting
		(String strName,
		String strConfigurationBase,
		java.util.Map mapSettingHandlers,
		java.util.Map mapSettingsGlobal,
		Object settingsParent,
		ISettingDescriptor globalDescriptor,
		ISettingDescriptor settingDescriptor,
		org.apache.axiom.om.OMElement omSetting)
	{
		String strValue = omSetting.getText();
		log.trace("Setting Name: " + strName + " Value: " + strValue);
		strValue = strValue.trim();
		if ( settingDescriptor == null ) { 
			settingDescriptor = new SettingDescriptor(strName, "xsd:float");
		}
		return new java.lang.Float(strValue);
	}

}
