/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Greg Byrd (IBM Corporation) 
 *    Rajalakshmi Iyer (IBM)
 *******************************************************************************/ 

package org.eclipse.higgins.configuration.xml;

import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.configuration.common.SettingDescriptor;

/**
 * Creates a new ConfigurationHandler object, pointing to 
 * specified file name.  Reads that configuration file and
 * returns settings.
 * 
 * @author gbyrd
 *
 */
public class IncludeHandler implements ISettingHandler {
	
	static private final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog
		(IncludeHandler.class.getName());

	public Object getSetting(
			String strName, 
			String strConfigurationBase,
			Map mapSettingHandlers, 
			Map mapSettingsGlobal, 
			Object settingsParent,
			ISettingDescriptor globalDescriptor,
			ISettingDescriptor settingDescriptor,
			OMElement omSetting)
			throws Exception 
	{		
		String strValue = omSetting.getText();
		log.trace("Setting Name: " + strName + " Value: " + strValue);
		
		if (settingDescriptor == null) {
			/* TODO: Check if 'htf:include' is the right type name */
			settingDescriptor = new SettingDescriptor(strName, "htf:include");
		}
		
		ConfigurationHandler handler = new ConfigurationHandler();
		handler.setConfigurationBase(strConfigurationBase);
		handler.setFileName(strValue);
		
		handler.configure(null);
		Map settings = handler.getSettings();
		
		return settings;
	}

}
